/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import twaver.Element;
import twaver.Generator;
import twaver.TWaverUtil;
import twaver.base.A.D.A.C;
import twaver.base.A.E.B;
import twaver.base.A.E.b;
import twaver.base.A.E.i;
import twaver.network.TNetwork;
import twaver.network.ui.AlarmAttachment;
import twaver.network.ui.Attachment;
import twaver.network.ui.BorderUI;
import twaver.network.ui.ComponentAttachment;
import twaver.network.ui.ElementUI;
import twaver.network.ui.IconAttachmentHolder;
import twaver.network.ui.LabelAttachment;

public abstract class AbstractElementUI
implements ElementUI {
    protected final TNetwork network;
    protected final Element element;
    protected int borderInsets;
    protected int stateOutlineInsets;
    protected float renderAlpha;
    protected twaver.base.A.D.D.C textureFactory;
    protected int attachmentPosition;
    protected int attachmentOrientation;
    protected int attachmentXOffset;
    protected int attachmentYOffset;
    protected int attachmentXGap;
    protected int attachmentYGap;
    protected List attachments = new LinkedList();
    protected AlarmAttachment alarmAttachment = null;
    protected LabelAttachment labelAttachment = null;
    private C A = null;

    public AbstractElementUI(TNetwork network, Element element) {
        this.network = network;
        this.element = element;
        this.A = new C(network, element);
        this.borderInsets = b.J(element, "border.insets");
        this.stateOutlineInsets = b.J(element, "state.outline.insets");
        this.attachmentPosition = b.J(element, "attachment.position");
        this.attachmentOrientation = b.J(element, "attachment.orientation");
        this.attachmentXOffset = b.J(element, "attachment.xoffset");
        this.attachmentYOffset = b.J(element, "attachment.yoffset");
        this.attachmentXGap = b.J(element, "attachment.xgap");
        this.attachmentYGap = b.J(element, "attachment.ygap");
        this.B();
        this.A();
        Iterator it = this.element.getClientProperties().keySet().iterator();
        while (it.hasNext()) {
            String propertyName = it.next().toString();
            if (!propertyName.startsWith("StateIcon:")) continue;
            this.A(propertyName);
        }
        this.installAttachments();
    }

    private void B() {
        Object value = b.C(this.element, "render.alpha");
        if (value instanceof Number) {
            this.renderAlpha = ((Number)value).floatValue();
            if (this.renderAlpha < 0.0f || this.renderAlpha > 1.0f) {
                this.renderAlpha = 1.0f;
            }
        }
    }

    public int getAttachmentOrientation() {
        return this.attachmentOrientation;
    }

    public int getAttachmentPosition() {
        return this.attachmentPosition;
    }

    public int getAttachmentXGap() {
        return this.attachmentXGap;
    }

    public int getAttachmentXOffset() {
        return this.attachmentXOffset;
    }

    public int getAttachmentYGap() {
        return this.attachmentYGap;
    }

    public int getAttachmentYOffset() {
        return this.attachmentYOffset;
    }

    public void addAttachment(Attachment a2) {
        if (a2 == null) {
            return;
        }
        if (this.attachments.contains(a2)) {
            this.attachments.remove(a2);
        }
        this.attachments.add(a2);
    }

    public void removeAttachment(Attachment a2) {
        if (a2 == null) {
            return;
        }
        if (!this.attachments.contains(a2)) {
            return;
        }
        this.attachments.remove(a2);
    }

    public TNetwork getNetwork() {
        return this.network;
    }

    public Element getElement() {
        return this.element;
    }

    protected void installAttachments() {
        this.labelAttachment = new LabelAttachment(this);
        this.attachments.add(this.labelAttachment);
        this.alarmAttachment = new AlarmAttachment(this);
        this.attachments.add(this.alarmAttachment);
    }

    public LabelAttachment getLabelAttachment() {
        return this.labelAttachment;
    }

    public AlarmAttachment getAlarmAttachment() {
        return this.alarmAttachment;
    }

    public void setLabelAttachment(LabelAttachment label) {
        if (this.labelAttachment != null) {
            this.removeAttachment(this.labelAttachment);
        }
        this.labelAttachment = label;
        if (this.labelAttachment != null) {
            this.addAttachment(this.labelAttachment);
        }
    }

    public void paintBorder(Graphics2D g2d) {
        BorderUI border;
        if (this.element.isSelected() && this.network.isSelectedStatePaintable(this.element) && (border = this.getBorder()) != null) {
            border.paintBorder(g2d);
        }
    }

    public Rectangle getUIBounds() {
        return null;
    }

    public Attachment getAttachmentAt(Point point) {
        ListIterator it = this.attachments.listIterator(this.attachments.size());
        while (it.hasPrevious()) {
            Attachment attachment = (Attachment)it.previous();
            if (!attachment.contains(point.x, point.y)) continue;
            return attachment;
        }
        return null;
    }

    public void paintAttachments(Graphics2D g2d) {
        Iterator it = this.attachments.iterator();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            if (!this.network.isPaintable(attachment)) continue;
            if (attachment.isShownOnTop()) {
                i.A.add(attachment);
                continue;
            }
            attachment.paint(g2d);
        }
    }

    public Iterator attachments() {
        return this.attachments.iterator();
    }

    protected Area getSeletableAttachementsArea() {
        return this.A(true);
    }

    protected boolean containInAttachments(int x, int y) {
        Area attachmentArea = this.getSeletableAttachementsArea();
        return attachmentArea == null ? false : attachmentArea.contains(x, y);
    }

    protected Area getAttachementsArea() {
        return this.A(false);
    }

    private Area A(boolean considerSeletable) {
        Area area = null;
        Iterator it = this.attachments();
        while (it.hasNext()) {
            Shape attachmentShape;
            Attachment attachment = (Attachment)it.next();
            if (considerSeletable && !attachment.isSelectable() || (attachmentShape = attachment.getShape()) == null) continue;
            if (area == null) {
                area = new Area(attachmentShape);
                continue;
            }
            area.add(new Area(attachmentShape));
        }
        return area;
    }

    protected Rectangle getAttachementsBounds() {
        Rectangle results = null;
        Iterator it = this.attachments();
        while (it.hasNext()) {
            Attachment attachment = (Attachment)it.next();
            Rectangle bounds = attachment.getBounds();
            if (bounds == null) continue;
            if (results == null) {
                results = bounds;
                continue;
            }
            results.add(bounds);
        }
        return results;
    }

    private void A(String propertyName) {
        Attachment attachment;
        String prefix = "StateIcon:";
        String stateIconName = propertyName.substring(prefix.length());
        if (stateIconName == null || stateIconName.equals("")) {
            return;
        }
        boolean added = false;
        if (this.element.getClientProperty(propertyName) != null) {
            added = (Boolean)this.element.getClientProperty(propertyName);
        }
        Iterator it = new ArrayList(this.attachments).iterator();
        while (it.hasNext()) {
            attachment = (Attachment)it.next();
            if (!stateIconName.equals(attachment.getName())) continue;
            if (this.network.isAnimateComponentAttachment() && attachment instanceof ComponentAttachment) {
                ((ComponentAttachment)attachment).animate(2, null);
                continue;
            }
            this.attachments.remove(attachment);
        }
        if (added && (attachment = IconAttachmentHolder.createAttachment(stateIconName, this)) != null) {
            this.addAttachment(attachment);
            if (this.network.isAnimateComponentAttachment() && attachment instanceof ComponentAttachment) {
                ((ComponentAttachment)attachment).animate(1, null);
            }
        }
    }

    public Color getStateOutlineColor() {
        if (this.A.B()) {
            return null;
        }
        if (this.network.isShowPlainElement()) {
            return null;
        }
        Generator generator = this.network.getElementStateOutlineColorGenerator();
        return generator == null ? null : (Color)generator.generate(this.element);
    }

    public Color getPaintBodyColor(Color naturalBodyColor) {
        Color color;
        if (this.A.A()) {
            return naturalBodyColor;
        }
        if (this.network.isShowPlainElement()) {
            return naturalBodyColor;
        }
        Generator generator = this.network.getElementBodyColorGenerator();
        Color color2 = color = generator == null ? null : (Color)generator.generate(this.element);
        if (color != null) {
            return color;
        }
        return naturalBodyColor;
    }

    public void setBodyPaint(Graphics2D g2d, Color color) {
        if (this.textureFactory != null) {
            g2d.setPaint(this.textureFactory.A(color));
        } else {
            g2d.setColor(color);
        }
    }

    public int getDefaultBorderInset() {
        return this.borderInsets;
    }

    public void performAction(int gesture, MouseEvent e2) {
    }

    public void updateClientProperty(String propertyName) {
        if (propertyName.equals("render.alpha")) {
            this.B();
        } else if (propertyName.equals("border.insets")) {
            this.borderInsets = b.J(this.element, "border.insets");
        } else if (propertyName.equals("state.outline.insets")) {
            this.stateOutlineInsets = b.J(this.element, "state.outline.insets");
        } else if (propertyName.equals("attachment.position")) {
            this.attachmentPosition = b.J(this.element, "attachment.position");
        } else if (propertyName.equals("attachment.orientation")) {
            this.attachmentOrientation = b.J(this.element, "attachment.orientation");
        } else if (propertyName.equals("attachment.xoffset")) {
            this.attachmentXOffset = b.J(this.element, "attachment.xoffset");
        } else if (propertyName.equals("attachment.yoffset")) {
            this.attachmentYOffset = b.J(this.element, "attachment.yoffset");
        } else if (propertyName.equals("attachment.xgap")) {
            this.attachmentXGap = b.J(this.element, "attachment.xgap");
        } else if (propertyName.equals("attachment.ygap")) {
            this.attachmentYGap = b.J(this.element, "attachment.ygap");
        } else if (propertyName.equals("texture.factory")) {
            this.A();
        } else if (propertyName.startsWith("StateIcon:")) {
            this.A(propertyName);
        }
    }

    private void A() {
        String value = b.Q(this.element, "texture.factory");
        this.textureFactory = value != null ? B.A(value) : null;
    }

    public void elementPropertyChange(PropertyChangeEvent evt) {
        Iterator it = this.attachments.iterator();
        while (it.hasNext()) {
            Attachment attachemnt = (Attachment)it.next();
            attachemnt.elementPropertyChange(evt);
        }
        BorderUI borderUI = this.getBorder();
        if (borderUI != null) {
            borderUI.elementPropertyChange(evt);
        }
    }

    public Shape getBorderShape() {
        return null;
    }

    public C getBlinkStruct() {
        return this.A;
    }

    public final boolean isBodyDark() {
        return this.A.A();
    }

    public final boolean isOutlineDark() {
        return this.A.B();
    }

    public void mouseClicked(MouseEvent e2) {
    }

    protected void setStateOutline(Graphics2D g2, Color color) {
        if (color != null) {
            g2.setColor(color);
        }
        int width = this.element.getStateOutlineWidth();
        g2.setStroke(TWaverUtil.createStroke(width));
    }
}

