/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.ImageIcon;
import javax.swing.event.EventListenerList;
import twaver.AlarmModel;
import twaver.AlarmPropagator;
import twaver.BTS;
import twaver.BTSAntenna;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.Batchable;
import twaver.ClientPropertyPersistentFilter;
import twaver.DataBoxEvent;
import twaver.DataBoxJarReader;
import twaver.DataBoxJarWriter;
import twaver.DataBoxListener;
import twaver.DataBoxOutputSetting;
import twaver.DataBoxQuickFinder;
import twaver.DataBoxSelectionModel;
import twaver.DataBoxSequenceListener;
import twaver.Element;
import twaver.ElementCallbackHandler;
import twaver.ElementPersistentFilter;
import twaver.Equipment;
import twaver.Follower;
import twaver.Generator;
import twaver.Group;
import twaver.Layer;
import twaver.LayerModel;
import twaver.Link;
import twaver.MovableFilter;
import twaver.Node;
import twaver.PersistenceManager;
import twaver.PolyLine;
import twaver.Resizable;
import twaver.SummingAlarmPropagator;
import twaver.TSubNetwork;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.UndoRedoEvent;
import twaver.UndoRedoManager;
import twaver.VisibleFilter;
import twaver.base.A.E.Q;
import twaver.base.A.E.W;
import twaver.base.A.E.X;
import twaver.base.A.E.l;
import twaver.base.A.F.C.A;
import twaver.base.A.F.C.B;
import twaver.base.A.F.C.C;
import twaver.base.A.F.C.D;
import twaver.base.A.F.C.E;
import twaver.base.A.F.C.F;
import twaver.base.A.F.C.G;
import twaver.base.A.F.C.H;
import twaver.base.A.F.C.I;
import twaver.base.A.F.C.J;
import twaver.base.A.F.C.K;
import twaver.network.background.Background;

public class TDataBox
implements PropertyChangeListener,
Serializable,
Batchable {
    private boolean K = true;
    private List O = new LinkedList();
    private Map Z = new HashMap(30);
    private Map a = new HashMap(30);
    private List C = new LinkedList();
    private Object S = null;
    private Map P = new HashMap();
    private String c = "DataBox";
    private String H = TWaverUtil.getDataBoxVersion();
    private boolean N = true;
    private EventListenerList b = new EventListenerList();
    private EventListenerList M = new EventListenerList();
    private PropertyChangeSupport E = new PropertyChangeSupport(this);
    private DataBoxSelectionModel R = new twaver.base.A.F.B(this);
    private AlarmModel B = new AlarmModel(this);
    private LayerModel I = new LayerModel();
    protected Map clientProperties;
    private Background Y;
    private transient List J = null;
    private transient AlarmPropagator V = null;
    private transient List X = null;
    private transient List L = null;
    private transient twaver.base.A.D.B.D G = null;
    private transient twaver.base.A.D.B.D D = null;
    private transient List T = null;
    private transient UndoRedoManager W = null;
    private transient Generator _ = TUIManager.getLinkBundleAgentGenerator();
    private transient VisibleFilter F = TUIManager.getLinkBundleFilter();
    private int Q = 0;
    private transient List U = new ArrayList();

    public boolean isBatching() {
        return this.Q > 0;
    }

    public void startBatch() {
        ++this.Q;
        int count = this.U.size();
        if (this.Q == 1 && count > 0) {
            BatchEvent event = new BatchEvent(this);
            for (int i2 = 0; i2 < count; ++i2) {
                BatchListener l2 = (BatchListener)this.U.get(i2);
                l2.batchStarted(event);
            }
        }
    }

    public void endBatch() {
        if (this.Q == 0) {
            throw new IllegalStateException("batch hasn't started yet.");
        }
        --this.Q;
        int count = this.U.size();
        if (this.Q == 0 && count > 0) {
            BatchEvent event = new BatchEvent(this);
            for (int i2 = 0; i2 < count; ++i2) {
                BatchListener l2 = (BatchListener)this.U.get(i2);
                l2.batchEnded(event);
            }
        }
    }

    public void addBatchListener(BatchListener l2) {
        if (!this.U.contains(l2)) {
            this.U.add(l2);
        }
    }

    public void removeBatchListener(BatchListener l2) {
        this.U.remove(l2);
    }

    public void setBackground(Background background) {
        Background oldValue = this.Y;
        this.Y = background;
        this.firePropertyChange("background", oldValue, this.Y);
    }

    public Background getBackground() {
        return this.Y;
    }

    public String getName() {
        return this.c;
    }

    public void setName(String name) {
        String oldValue = this.c;
        this.c = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public Object getClientProperty(Object key) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.getClientProperties().get(key);
    }

    public Map getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new LinkedHashMap();
        }
        return this.clientProperties;
    }

    public void putClientProperty(Object key, Object value) {
        Object oldValue = this.getClientProperties().get(key);
        if (value != null) {
            this.getClientProperties().put(key, value);
        } else if (oldValue != null) {
            this.getClientProperties().remove(key);
        }
        String propertyName = "CP:" + key.toString();
        this.firePropertyChange(propertyName, oldValue, value);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.E.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.E.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.E.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.E.removePropertyChangeListener(propertyName, listener);
    }

    public TDataBox() {
        this("DataBox");
    }

    public TDataBox(String name) {
        this(name, null);
    }

    public TDataBox(List elements) {
        this("DataBox", elements);
    }

    public TDataBox(String name, List elements) {
        this.c = name;
        if (elements != null) {
            this.O = elements;
        }
        if (this.O.size() > 0) {
            throw new IllegalArgumentException("elements should be empty.");
        }
        this.A();
    }

    public AlarmModel getAlarmModel() {
        return this.B;
    }

    public LayerModel getLayerModel() {
        return this.I;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.A();
    }

    private void A() {
        this.V = new SummingAlarmPropagator();
        this.L = new ArrayList();
        this._ = TUIManager.getLinkBundleAgentGenerator();
        this.F = TUIManager.getLinkBundleFilter();
        this.U = new ArrayList();
        this.W = new UndoRedoManager(this);
        this.T = new ArrayList();
        this.T.add(new I(this));
        this.T.add(new H(this));
        this.T.add(new K(this, this.a, this.C));
        this.T.add(new F(this));
        this.T.add(new J(this));
        this.T.add(new G(this.P));
        this.T.add(new B(this));
        this.T.add(new A());
        this.T.add(new D(this));
        this.T.add(new E(this));
        this.T.add(new C(this));
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.E;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.E.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.E.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addDataBoxSequenceListener(DataBoxSequenceListener l2) {
        this.M.add(DataBoxSequenceListener.class, l2);
    }

    public void removeDataBoxSequenceListener(DataBoxSequenceListener l2) {
        this.M.remove(DataBoxSequenceListener.class, l2);
    }

    public void fireIndexChanged(Element element) {
        Object[] listeners = this.M.getListenerList();
        for (int i2 = 0; i2 <= listeners.length - 2; i2 += 2) {
            if (listeners[i2] != (class$twaver$DataBoxSequenceListener == null ? TDataBox.class$("twaver.DataBoxSequenceListener") : class$twaver$DataBoxSequenceListener)) continue;
            ((DataBoxSequenceListener)listeners[i2 + 1]).indexChanged(element);
        }
    }

    void B(DataBoxListener l2) {
        if (l2 == null) {
            return;
        }
        if (this.J == null) {
            this.J = new ArrayList();
        }
        if (!this.J.contains(l2)) {
            this.J.add(l2);
        }
    }

    void A(DataBoxListener l2) {
        if (this.J != null) {
            this.J.remove(l2);
        }
    }

    void B(PropertyChangeListener l2) {
        if (this.X == null) {
            this.X = new ArrayList();
        }
        if (!this.X.contains(l2)) {
            this.X.add(l2);
        }
    }

    void A(PropertyChangeListener l2) {
        if (this.X != null) {
            this.X.remove(l2);
        }
    }

    public void addDataBoxListener(DataBoxListener l2) {
        this.b.add(DataBoxListener.class, l2);
    }

    private void B(Element element) {
        Node host = null;
        if (element instanceof Follower) {
            host = ((Follower)element).getHost();
        }
        Node from = null;
        Node to = null;
        if (element instanceof Link) {
            Link link = (Link)element;
            from = link.getFrom();
            to = link.getTo();
        }
        BTS bts = null;
        if (element instanceof BTSAntenna) {
            bts = ((BTSAntenna)element).getBTS();
        }
        DataBoxEvent e2 = new DataBoxEvent(this, element, element.getParent(), from, to, host, bts, 1);
        if (this.J != null) {
            Iterator it = this.J.iterator();
            while (it.hasNext()) {
                ((DataBoxListener)it.next()).elementAdded(e2);
            }
        }
        Object[] listeners = this.b.getListenerList();
        for (int i2 = 0; i2 <= listeners.length - 2; i2 += 2) {
            ((DataBoxListener)listeners[i2 + 1]).elementAdded(e2);
        }
    }

    private void A(Element element, Element parent, Node from, Node to, Node host, BTS bts) {
        DataBoxEvent e2 = new DataBoxEvent(this, element, parent, from, to, host, bts, 2);
        if (this.J != null) {
            Iterator it = this.J.iterator();
            while (it.hasNext()) {
                ((DataBoxListener)it.next()).elementRemoved(e2);
            }
        }
        Object[] listeners = this.b.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            ((DataBoxListener)listeners[i2 + 1]).elementRemoved(e2);
        }
    }

    private void A(List elements) {
        DataBoxEvent e2 = new DataBoxEvent(this, null, 3);
        e2.setUserObject(elements);
        if (this.J != null) {
            Iterator it = this.J.iterator();
            while (it.hasNext()) {
                ((DataBoxListener)it.next()).elementsCleared(e2);
            }
        }
        Object[] listeners = this.b.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            ((DataBoxListener)listeners[i2 + 1]).elementsCleared(e2);
        }
    }

    public void removeDataBoxListener(DataBoxListener l2) {
        this.b.remove(DataBoxListener.class, l2);
    }

    public DataBoxSelectionModel getSelectionModel() {
        return this.R;
    }

    public Element getLastSelectedElement() {
        return this.R.lastElement();
    }

    public Iterator selection() {
        return this.R.selection();
    }

    public void setSelectionModel(DataBoxSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null TDataBox DataBoxSelectionModel");
        }
        this.R = selectionModel;
    }

    public Element getElementByID(Object id) {
        return (Element)this.Z.get(id);
    }

    public Element getRandomElement() {
        int size = this.O.size();
        if (size == 0) {
            return null;
        }
        return (Element)this.O.get(TWaverUtil.getRandomInt(size));
    }

    public Element getElementByName(String name) {
        if (name == null) {
            return null;
        }
        Iterator it = this.Z.values().iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (element.getName() == null || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public Element getElementByTag(String tag) {
        return (Element)this.P.get(tag);
    }

    public boolean containsByID(Object id) {
        return this.Z.containsKey(id);
    }

    public boolean contains(Element element) {
        if (element == null) {
            return false;
        }
        return element == this.Z.get(element.getID());
    }

    public void addElement(Element element) throws IllegalArgumentException {
        this.addElement(-1, element);
    }

    public void addElement(int index, Element element) {
        Equipment equipment;
        Link link;
        if (element == null) {
            return;
        }
        if (this.Z.containsKey(element.getID())) {
            throw new IllegalArgumentException("Element with ID '" + element.getID() + "' already exist");
        }
        if (twaver.base.A.E.W.B(element) && ((link = (Link)element).getFrom() == null || link.getTo() == null)) {
            throw new IllegalArgumentException("Link element with ID '" + element.getID() + "' must set from node and to node.");
        }
        this.Z.put(element.getID(), element);
        if (element instanceof PolyLine) {
            this.O.add(element);
        } else {
            this.O.add(0, element);
        }
        if (element.getParent() == null) {
            this.a.put(element.getID(), element);
            if (index >= 0) {
                this.C.add(index, element);
            } else {
                this.C.add(element);
            }
        }
        element.addPropertyChangeListener(this);
        this.B(element);
        if (element.isSelected()) {
            this.R.appendSelection(element);
        }
        if (element instanceof Link) {
            link = (Link)element;
            link.checkAgentNode();
            this.tagLinkIndex(link);
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            l.A(node);
        }
        twaver.base.A.E.E.A(this, element);
        if (element instanceof Group) {
            ((Group)element).invalidateGroupShape();
        }
        if (element instanceof BTS) {
            ((BTS)element).P();
            twaver.base.A.E.W.A((BTS)element);
        }
        if (element instanceof BTSAntenna) {
            ((BTSAntenna)element).invalidateAntennaShape();
        }
        twaver.base.A.E.W.F(element);
        if (this.getAlarmPropagator() != null && !element.getAlarmState().isEmpty()) {
            AlarmPropagator propagator = this.getAlarmPropagator();
            propagator.propagate(element);
        }
        if (element instanceof Equipment && (equipment = (Equipment)element).getTag() != null) {
            this.P.put(equipment.getTag(), equipment);
        }
    }

    public int size() {
        return this.O.size();
    }

    public int getChildIndex(Element element) {
        if (element == null) {
            return -1;
        }
        if (element.getParent() != null) {
            return element.getParent().getChildren().indexOf(element);
        }
        return this.C.indexOf(element);
    }

    public boolean removeElement(Element element) {
        if (element != null) {
            return this.removeElementByID(element.getID()) == element;
        }
        return false;
    }

    public Element removeElementByID(Object id) {
        int i2;
        if (id == null) {
            return null;
        }
        if (!this.containsByID(id)) {
            return null;
        }
        Element element = (Element)this.Z.get(id);
        Node from = null;
        Node to = null;
        if (element instanceof Link) {
            Link link = (Link)element;
            from = link.getFrom();
            to = link.getTo();
            link.setFrom(null);
            link.setTo(null);
            if (from == to && from != null) {
                this.tagLinkIndex(from, to);
            }
        }
        if (element instanceof Node && ((Node)element).getAllLinks() != null) {
            Object[] links = ((Node)element).getAllLinks().toArray();
            for (i2 = 0; i2 < links.length; ++i2) {
                this.removeElement((Link)links[i2]);
            }
        }
        if (element instanceof Node && ((Node)element).getAllFollowers() != null) {
            Object[] followers = ((Node)element).getAllFollowers().toArray();
            for (i2 = 0; i2 < followers.length; ++i2) {
                Follower follower = (Follower)followers[i2];
                follower.setHost(null);
            }
        }
        Node host = null;
        if (element instanceof Follower && ((Follower)element).getHost() != null) {
            host = ((Follower)element).getHost();
            ((Follower)element).setHost(null);
        }
        if (element instanceof BTS) {
            ((BTS)element).clearAntennas();
        }
        BTS bts = null;
        if (element instanceof BTSAntenna) {
            bts = ((BTSAntenna)element).getBTS();
            ((BTSAntenna)element).setBTS(null);
        }
        Object[] children = element.getChildren().toArray();
        for (int i3 = 0; i3 < children.length; ++i3) {
            Element child = (Element)children[i3];
            this.removeElementByID(child.getID());
        }
        Element oldParent = element.getParent();
        if (element.getParent() != null) {
            element.getParent().removeChild(element);
        }
        if (this.getSelectionModel().contains(element)) {
            this.getSelectionModel().removeSelection(element);
        }
        this.Z.remove(id);
        this.O.remove(element);
        if (this.a.containsKey(element.getID())) {
            this.a.remove(element.getID());
            this.C.remove(element);
        }
        if (element instanceof Equipment) {
            this.P.remove(((Equipment)element).getTag());
        }
        this.A(element, oldParent, from, to, host, bts);
        element.removePropertyChangeListener(this);
        return element;
    }

    public void removeSelectedElements() {
        if (this.getSelectionModel().isEmpty()) {
            return;
        }
        List eldestElements = this.getSelectionModel().getToppestSelectedElement();
        this.getSelectionModel().clearSelection();
        Iterator it = eldestElements.iterator();
        while (it.hasNext()) {
            this.removeElement((Element)it.next());
        }
    }

    public Iterator iterator() {
        return this.O.iterator();
    }

    public Iterator iteratorReverse() {
        return this.getAllElementsReverse().iterator();
    }

    public void iterator(ElementCallbackHandler handler) {
        Iterator it = this.O.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (handler.processElement(element)) continue;
            return;
        }
    }

    public void iteratorSelection(ElementCallbackHandler handler) {
        Iterator it = this.selection();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            if (handler.processElement(element)) continue;
            return;
        }
    }

    public void iteratorReverse(ElementCallbackHandler handler) {
        ListIterator it = this.O.listIterator(this.O.size());
        while (it.hasPrevious()) {
            Element element = (Element)it.previous();
            if (handler.processElement(element)) continue;
            return;
        }
    }

    public void iteratorReverseByLayer(ElementCallbackHandler handler) {
        int layerSize = this.I.size();
        for (int index = 0; index < layerSize; ++index) {
            Layer layer = this.I.getLayerByIndex(index);
            ListIterator it = this.O.listIterator(this.O.size());
            while (it.hasPrevious()) {
                Element element = (Element)it.previous();
                if (!this.I.contains(element, layer) || handler.processElement(element)) continue;
                return;
            }
        }
    }

    public void iteratorByLayer(ElementCallbackHandler handler) {
        int layerSize = this.I.size();
        for (int index = layerSize - 1; index >= 0; --index) {
            Layer layer = this.I.getLayerByIndex(index);
            Iterator it = this.O.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!this.I.contains(element, layer) || handler.processElement(element)) continue;
                return;
            }
        }
    }

    public Iterator iterator(Class clazz) {
        return this.getElementsByType(clazz).iterator();
    }

    public List getElementsByType(Class clazz) {
        ArrayList list = new ArrayList();
        if (clazz != null) {
            Iterator it = this.O.iterator();
            while (it.hasNext()) {
                Object e2 = it.next();
                if (!clazz.isAssignableFrom(e2.getClass())) continue;
                list.add(e2);
            }
        }
        return list;
    }

    public boolean isEmpty() {
        return this.O.isEmpty();
    }

    public ListIterator listIterator(int index) {
        return this.O.listIterator(index);
    }

    public List getAllElements() {
        return new ArrayList(this.O);
    }

    public List getAllElementsReverse() {
        ArrayList<Element> list = new ArrayList<Element>();
        ListIterator listIt = this.listIterator(this.size());
        while (listIt.hasPrevious()) {
            Element element = (Element)listIt.previous();
            list.add(element);
        }
        return list;
    }

    public List getRootElements() {
        return this.C;
    }

    public List getRootElementsReverse() {
        ArrayList result = new ArrayList(this.C);
        Collections.reverse(result);
        return result;
    }

    public void clear() {
        this.getSelectionModel().clearSelection();
        Iterator it = this.O.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            element.removePropertyChangeListener(this);
        }
        ArrayList oldValue = new ArrayList(this.O);
        this.Z.clear();
        this.O.clear();
        this.a.clear();
        this.C.clear();
        this.P.clear();
        this.A(oldValue);
    }

    public int indexOf(Element element) {
        return this.O.indexOf(element);
    }

    public void sendToTop(Element element) {
        BTS bts;
        Node node;
        List followers;
        if (!this.K) {
            return;
        }
        if (!this.contains(element)) {
            return;
        }
        this.O.remove(element);
        this.O.add(0, element);
        this.fireIndexChanged(element);
        if (twaver.base.A.E.W.B(element)) {
            Node toAgent;
            Link link = (Link)element;
            Node fromAgent = link.getFromAgent();
            if (fromAgent != null && !fromAgent.isAdjustToBottom()) {
                this.sendToTop(link.getFromAgent());
            }
            if ((toAgent = link.getToAgent()) != null && !toAgent.isAdjustToBottom()) {
                this.sendToTop(link.getToAgent());
            }
        }
        if (element instanceof Node && !(element instanceof BTS) && !(element instanceof BTSAntenna) && (followers = (node = (Node)element).getAllFollowers()) != null) {
            for (int i2 = 0; i2 < followers.size(); ++i2) {
                Follower f2 = (Follower)followers.get(i2);
                if (twaver.base.A.E.W.D(f2, node) || twaver.base.A.E.W.B((Element)node, f2)) continue;
                this.sendToTop(f2);
            }
        }
        if (element instanceof PolyLine) {
            List routerNodes = ((PolyLine)element).getAllNodes();
            for (int i3 = 0; i3 < routerNodes.size(); ++i3) {
                Node routerNode = (Node)routerNodes.get(i3);
                if (twaver.base.A.E.W.D(element, routerNode)) continue;
                this.sendToTop(routerNode);
            }
        }
        if (element instanceof BTSAntenna && (bts = ((BTSAntenna)element).getBTS()) != null) {
            this.sendToTop(bts);
        }
        if (element instanceof TSubNetwork || element instanceof BTS) {
            return;
        }
        if (element instanceof Group && !((Group)element).isExpand()) {
            return;
        }
        Iterator it = element.children();
        while (it.hasNext()) {
            Element child = (Element)it.next();
            if (child instanceof Link) continue;
            this.sendToTop(child);
        }
    }

    public void sendToBottom(Element element) {
        this.sendToBottom(element, null);
    }

    public void sendToBottom(Element element, Element referenceElement) {
        if (!this.K) {
            return;
        }
        if (!this.contains(element)) {
            return;
        }
        if (referenceElement != null && !this.contains(referenceElement)) {
            return;
        }
        this.O.remove(element);
        int newIndex = referenceElement == null ? this.O.size() : this.O.indexOf(referenceElement) + 1;
        this.O.add(newIndex, element);
        this.fireIndexChanged(element);
        Element parent = element.getParent();
        if (!(parent instanceof TSubNetwork) && !(parent instanceof Link)) {
            this.sendToBottom(parent, element);
        }
    }

    public AlarmPropagator getAlarmPropagator() {
        return this.V;
    }

    public void setAlarmPropagator(AlarmPropagator alarmPropagator) {
        Element element;
        if (this.V == alarmPropagator) {
            return;
        }
        AlarmPropagator oldValue = this.V;
        this.V = alarmPropagator;
        Iterator it = this.O.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            element.getAlarmState().setPropagateSeverity(null);
        }
        it = this.O.iterator();
        while (it.hasNext()) {
            element = (Element)it.next();
            if (this.getAlarmPropagator() == null || element.getAlarmState().isEmpty()) continue;
            AlarmPropagator propagator = this.getAlarmPropagator();
            propagator.propagate(element);
        }
        this.firePropertyChange("alarmPropagator", oldValue, this.V);
    }

    public void propertyChange(PropertyChangeEvent e2) {
        PropertyChangeListener l2;
        if (this.X != null) {
            Iterator it = this.X.iterator();
            while (it.hasNext()) {
                l2 = (PropertyChangeListener)it.next();
                l2.propertyChange(e2);
            }
        }
        for (int i2 = 0; i2 < this.T.size(); ++i2) {
            twaver.base.A.F.C handler = (twaver.base.A.F.C)this.T.get(i2);
            if (!handler.B(e2)) continue;
            handler.A(e2);
        }
        Iterator it = this.L.iterator();
        while (it.hasNext()) {
            l2 = (PropertyChangeListener)it.next();
            l2.propertyChange(e2);
        }
    }

    public void addElementPropertyChangeListener(PropertyChangeListener l2) {
        if (!this.L.contains(l2)) {
            this.L.add(l2);
        }
    }

    public void removeElementPropertyChangeListener(PropertyChangeListener l2) {
        this.L.remove(l2);
    }

    public List getElementPropertyChangeListeners() {
        return new ArrayList(this.L);
    }

    public void parseJar(InputStream in) throws IOException {
        this.parseJar(in, null);
    }

    public void parseJar(InputStream in, Element parentOfRootElement) throws IOException {
        String xml = null;
        JarInputStream jarIn = new JarInputStream(in);
        JarEntry entry = jarIn.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            if (!name.equals("data.xml")) {
                byte[] bytes = TWaverUtil.getByteArrayFromInputStream(jarIn);
                if (bytes != null) {
                    ImageIcon img = new ImageIcon(bytes);
                    TWaverUtil.registerImageIcon(name, img);
                }
            } else {
                byte[] xmlChars = TWaverUtil.getByteArrayFromInputStream(jarIn);
                xml = new String(xmlChars, "UTF-8");
            }
            entry = jarIn.getNextJarEntry();
        }
        jarIn.close();
        if (xml != null) {
            PersistenceManager.readByXML(this, xml, parentOfRootElement);
        }
    }

    public void outputJar(String fileName) throws IOException {
        if (fileName == null) {
            return;
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring("file:".length());
            while (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
        }
        FileOutputStream out = new FileOutputStream(fileName);
        this.outputJar(out);
        ((OutputStream)out).close();
    }

    public byte[] toJarBytes() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataBoxJarWriter writer = new DataBoxJarWriter(out);
        writer.write(this);
        return out.toByteArray();
    }

    public void outputJar(OutputStream out) throws IOException {
        DataBoxJarWriter writer = new DataBoxJarWriter(out);
        writer.write(this);
    }

    public void parseJar(String filename) throws IOException {
        this.parseJar(filename, null);
    }

    public void parseJar(String filename, Element parentOfRootElement) throws IOException {
        filename = "jar:file:/" + filename + "!/";
        URL url = new URL(filename);
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        DataBoxJarReader reader = new DataBoxJarReader(conn);
        reader.read(this, parentOfRootElement);
    }

    public void parse(InputStream in) throws IOException {
        this.parse(in, null);
    }

    public void parse(String url) throws IOException {
        this.parse(url, null);
    }

    public void parse(InputStream in, Element parentOfRootElement) throws IOException {
        PersistenceManager.readByXML(this, in, parentOfRootElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String url, Element parentOfRootElement) throws IOException {
        InputStream in = twaver.base.A.E.C.B(url, true);
        if (in == null) {
            throw new NullPointerException("can not find resource '" + url + "'");
        }
        try {
            PersistenceManager.readByXML(this, in, parentOfRootElement);
        }
        finally {
            in.close();
        }
    }

    public void output(String fileName, boolean withElementId) throws IOException {
        DataBoxOutputSetting setting = new DataBoxOutputSetting();
        setting.setWithElementId(withElementId);
        this.output(fileName, setting);
    }

    public void output(String fileName, boolean withElementId, boolean withAlarmState, ElementPersistentFilter elementFilter, ClientPropertyPersistentFilter clientPropertyFilter) throws IOException {
        DataBoxOutputSetting setting = new DataBoxOutputSetting();
        setting.setWithElementId(withElementId);
        setting.setWithAlarmState(withAlarmState);
        setting.setElementFilter(elementFilter);
        setting.setClientPropertyFilter(clientPropertyFilter);
        this.output(fileName, setting);
    }

    public void output(String fileName, DataBoxOutputSetting outputSetting) throws IOException {
        if (fileName == null) {
            return;
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring("file:".length());
            while (fileName.startsWith("/")) {
                fileName = fileName.substring(1);
            }
        }
        FileOutputStream out = new FileOutputStream(fileName);
        outputSetting.setOutputStream(out);
        twaver.base.A.E.Q.A(this, outputSetting);
        ((OutputStream)out).close();
    }

    public void output(DataBoxOutputSetting outputSetting) throws IOException {
        twaver.base.A.E.Q.A(this, outputSetting);
    }

    public void output(OutputStream out, boolean withElementId) throws IOException {
        DataBoxOutputSetting setting = new DataBoxOutputSetting();
        setting.setWithElementId(withElementId);
        setting.setOutputStream(out);
        twaver.base.A.E.Q.A(this, setting);
    }

    public twaver.base.A.D.B.D getGifImageFinder() {
        if (this.G == null) {
            this.G = new twaver.base.A.D.B.D(this, false);
        }
        return this.G;
    }

    public twaver.base.A.D.B.D getGifIconFinder() {
        if (this.D == null) {
            this.D = new twaver.base.A.D.B.D(this, true);
        }
        return this.D;
    }

    public void selectAll() {
        this.getSelectionModel().selectAll();
    }

    public List getLayers() {
        return this.O;
    }

    public Enumeration depthFirstEnumeration() {
        return new twaver.base.A.F.F(this.C);
    }

    public Enumeration depthFirstEnumeration(Element root) {
        return new twaver.base.A.F.F(root);
    }

    public Enumeration breadthFirstEnumeration() {
        return new twaver.base.A.F.E(this.C);
    }

    public Enumeration breadthFirstEnumeration(Element root) {
        return new twaver.base.A.F.E(root);
    }

    public void addElementWithDescendant(Element element) {
        this.addElementWithDescendant(element, null);
    }

    public void addElementWithDescendant(Element element, VisibleFilter filter) {
        twaver.base.A.E.E.A(this, element, filter);
    }

    public void removeDescendant(Element element) {
        twaver.base.A.E.E.B(this, element);
    }

    public DataBoxQuickFinder createJavaBeanFinder(String propertyName) {
        return this.createJavaBeanFinder(propertyName, null);
    }

    public DataBoxQuickFinder createJavaBeanFinder(final String propertyName, Class elementClass) {
        Method readMethod;
        if (elementClass == null) {
            Class clazz = elementClass = Element.class;
        }
        if ((readMethod = twaver.base.A.E.H.A(elementClass, propertyName)) == null) {
            throw new RuntimeException("can not find '" + propertyName + "' read method in '" + elementClass + "'");
        }
        Generator keyGenerator = new Generator(){

            public Object generate(Object element) {
                return twaver.base.A.E.H.A(element, readMethod, propertyName);
            }
        };
        DataBoxQuickFinder finder = new DataBoxQuickFinder(this, propertyName, elementClass, keyGenerator);
        return finder;
    }

    public DataBoxQuickFinder createClientPropertyFinder(String clientPropertyKey) {
        return this.createClientPropertyFinder(clientPropertyKey, Element.class);
    }

    public DataBoxQuickFinder createClientPropertyFinder(final String clientPropertyKey, Class elementClass) {
        Generator keyGenerator = new Generator(){

            public Object generate(Object element) {
                return ((Element)element).getClientProperty(clientPropertyKey);
            }
        };
        DataBoxQuickFinder finder = new DataBoxQuickFinder(this, "CP:" + clientPropertyKey, elementClass, keyGenerator);
        return finder;
    }

    public DataBoxQuickFinder createUserPropertyFinder(String userPropertyKey) {
        return this.createUserPropertyFinder(userPropertyKey, Element.class);
    }

    public DataBoxQuickFinder createUserPropertyFinder(final String userPropertyKey, Class elementClass) {
        Generator keyGenerator = new Generator(){

            public Object generate(Object element) {
                return ((Element)element).getUserProperty(userPropertyKey);
            }
        };
        DataBoxQuickFinder finder = new DataBoxQuickFinder(this, "UP:" + userPropertyKey, elementClass, keyGenerator);
        return finder;
    }

    public Generator getLinkBundleAgentGenerator() {
        return this._;
    }

    public void setLinkBundleAgentGenerator(Generator linkBundleAgentGenerator) {
        this._ = linkBundleAgentGenerator;
    }

    public void reverseBundleExpand(Link link) {
        this.W.setEnable(false);
        link.setBundleExpand(!link.isLinkBundleExpand());
        this.W.setEnable(true);
        this.W.addEvent(new UndoRedoEvent(link));
        this.tagLinkIndex(link);
    }

    public void tagLinkIndex(Link link) {
        if (link != null) {
            this.tagLinkIndex(link.getFromAgent(), link.getToAgent());
        }
    }

    public void tagLinkIndex(Node node1, Node node2) {
        this.W.setEnable(false);
        l.A(node1, node2, this);
        this.W.setEnable(true);
        this.W.addEvent(new UndoRedoEvent(this, node1, node2));
    }

    public List getBundledLinks(Link link) {
        return this.getBundledLinks(link.getFromAgent(), link.getToAgent());
    }

    public List getBundledLinks(Node node1, Node node2) {
        List links = l.A(node1, node2);
        if (this.F != null && links != null && links.size() > 0) {
            Iterator it = links.iterator();
            while (it.hasNext()) {
                Link link = (Link)it.next();
                if (this.F.isVisible(link)) continue;
                it.remove();
            }
        }
        return links;
    }

    private void A(Element element) {
        Object[] listeners = this.M.getListenerList();
        for (int i2 = 0; i2 <= listeners.length - 2; i2 += 2) {
            if (listeners[i2] != (class$twaver$DataBoxSequenceListener == null ? TDataBox.class$("twaver.DataBoxSequenceListener") : class$twaver$DataBoxSequenceListener)) continue;
            ((DataBoxSequenceListener)listeners[i2 + 1]).hiberarchyChanged(element);
        }
    }

    public void moveTo(int index, Element element) {
        Element pElement = element.getParent();
        List list = pElement == null ? this.C : pElement.getChildren();
        int nowIndex = list.indexOf(element);
        if (nowIndex == index || nowIndex < 0) {
            return;
        }
        if (index >= 0 && index <= list.size()) {
            list.remove(element);
            if (index > list.size()) {
                --index;
            }
            list.add(index, element);
            this.A(element);
        }
    }

    public void moveToUp(Element element) {
        Element pElement = element.getParent();
        List list = pElement == null ? this.C : pElement.getChildren();
        this.moveTo(list.indexOf(element) - 1, element);
    }

    public void moveToDown(Element element) {
        Element pElement = element.getParent();
        List list = pElement == null ? this.C : pElement.getChildren();
        this.moveTo(list.indexOf(element) + 1, element);
    }

    public void moveToTop(Element element) {
        this.moveTo(0, element);
    }

    public void moveToBottom(Element element) {
        Element pElement = element.getParent();
        List list = pElement == null ? this.C : pElement.getChildren();
        this.moveTo(list.size(), element);
    }

    public void moveSelectionToUp() {
        ArrayList elements = new ArrayList();
        twaver.base.A.E.E.C(elements, this.C);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Element element = (Element)elements.get(i2);
            this.moveToUp(element);
        }
    }

    public void moveSelectionToDown() {
        ArrayList elements = new ArrayList();
        twaver.base.A.E.E.A(elements, this.C);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Element element = (Element)elements.get(i2);
            this.moveToDown(element);
        }
    }

    public void moveSelectionToTop() {
        ArrayList elements = new ArrayList();
        twaver.base.A.E.E.D(elements, this.C);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Element element = (Element)elements.get(i2);
            this.moveToTop(element);
        }
    }

    public void moveSelectionToBottom() {
        ArrayList elements = new ArrayList();
        twaver.base.A.E.E.B(elements, this.C);
        for (int i2 = 0; i2 < elements.size(); ++i2) {
            Element element = (Element)elements.get(i2);
            this.moveToBottom(element);
        }
    }

    public void copySelection() {
        if (!this.R.isEmpty()) {
            ArrayList list = new ArrayList();
            Iterator it = this.selection();
            while (it.hasNext()) {
                list.add(it.next());
            }
            TWaverUtil.setPasteOffset(0);
            TWaverUtil.setCopyElements(list);
        }
    }

    public List pasteElements(Element parentElement) {
        ArrayList<Element> pastes = new ArrayList<Element>();
        List list = TWaverUtil.getCopyElements();
        if (list != null && list.size() > 0) {
            int offset = TWaverUtil.getPasteOffset() + 5;
            TWaverUtil.setPasteOffset(offset);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Element element = (Element)list.get(i2);
                Element newElement = element.copy(this);
                if (element.getLocation() != null) {
                    int x = element.getLocation().x + offset;
                    int y = element.getLocation().y + offset;
                    newElement.setLocation(x, y);
                }
                if (parentElement != null && newElement.getParent() == null) {
                    newElement.setParent(parentElement);
                }
                if (!this.contains(newElement)) {
                    this.addElement(newElement);
                }
                pastes.add(newElement);
            }
            this.R.setSelection(pastes);
        }
        return pastes;
    }

    public void sameHeightSelection() {
        if (this.R.size() > 1) {
            int size = this.R.firstElement().getHeight();
            Iterator it = this.R.selection();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!(element instanceof Resizable)) continue;
                Resizable resizable = (Resizable)element;
                resizable.setSize(element.getWidth(), size);
            }
        }
    }

    public void sameWidthSelection() {
        if (this.R.size() > 1) {
            int size = this.R.firstElement().getWidth();
            Iterator it = this.R.selection();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!(element instanceof Resizable)) continue;
                Resizable resizable = (Resizable)element;
                resizable.setSize(size, element.getHeight());
            }
        }
    }

    public void alignBottomSelection() {
        twaver.base.A.E.X.A(this);
    }

    public void alignCenterSelection() {
        twaver.base.A.E.X.E(this);
    }

    public void alignLeftSelection() {
        twaver.base.A.E.X.F(this);
    }

    public void alignMiddleSelection() {
        twaver.base.A.E.X.I(this);
    }

    public void alignRightSelection() {
        twaver.base.A.E.X.L(this);
    }

    public void alignTopSelection() {
        twaver.base.A.E.X.C(this);
    }

    public void evenHSpaceSelection() {
        twaver.base.A.E.X.B(this);
    }

    public void evenVSpaceSelection() {
        twaver.base.A.E.X.J(this);
    }

    public void bottomPileSelection() {
        twaver.base.A.E.X.D(this);
    }

    public void leftPileSelection() {
        twaver.base.A.E.X.K(this);
    }

    public void topPileSelection() {
        twaver.base.A.E.X.G(this);
    }

    public void rightPileSelection() {
        twaver.base.A.E.X.H(this);
    }

    public static void moveElements(Iterator elements, MovableFilter movableFilter, double xOffset, double yOffset) {
        TWaverUtil.moveElements(elements, movableFilter, xOffset, yOffset);
    }

    public UndoRedoManager getUndoRedoManager() {
        return this.W;
    }

    public boolean isTagLinkWhenAlarmStateChanged() {
        return this.N;
    }

    public void setTagLinkWhenAlarmStateChanged(boolean tagLinkWhenAlarmStateChanged) {
        if (this.N != tagLinkWhenAlarmStateChanged) {
            boolean oldValue = this.N;
            this.N = tagLinkWhenAlarmStateChanged;
            this.firePropertyChange("tagLinkWhenAlarmStateChanged", oldValue, tagLinkWhenAlarmStateChanged);
        }
    }

    public void loadSubNetwork(TSubNetwork subNetwork) {
        if (this.contains(subNetwork)) {
            TWaverUtil.getDataLoader().load(subNetwork, this);
        }
    }

    public void loadSubNetwork(TSubNetwork subNetwork, Component component) {
        Cursor cursor = null;
        if (component != null) {
            cursor = component.getCursor();
            component.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.loadSubNetwork(subNetwork);
        if (component != null) {
            component.setCursor(cursor);
        }
    }

    public void addElements(Collection collection) {
        this.addElements(collection, null);
    }

    public void addElements(Collection collection, Element parentOfRootElement) {
        if (collection == null) {
            return;
        }
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            this.addElement(element, parentOfRootElement);
        }
    }

    public void addElement(Element element, Element parentOfRootElement) {
        if (element == null) {
            return;
        }
        Element parent = element.getParent();
        if (parentOfRootElement != null && parent == null) {
            element.setParent(parentOfRootElement);
        }
        if (twaver.base.A.E.W.B(element)) {
            Link link = (Link)element;
            if (link.getFrom() == null || link.getTo() == null) {
                TWaverUtil.handleError("link with id '" + link.getID() + "'and name '" + link.getName() + "' has no from or to Node.", null);
                return;
            }
            if (!this.containsByID(link.getFrom().getID())) {
                this.addElement(link.getFrom(), parentOfRootElement);
            }
            if (!this.containsByID(link.getTo().getID())) {
                this.addElement(link.getTo(), parentOfRootElement);
            }
        }
        if (parent != null && !twaver.base.A.E.W.B(parent) && !this.containsByID(parent.getID())) {
            this.addElement(parent, parentOfRootElement);
        }
        if (!this.containsByID(element.getID())) {
            this.addElement(element);
        }
    }

    public void parseXML(String xml) {
        this.parseXML(xml, null);
    }

    public void parseXML(String xml, Element parent) {
        try {
            PersistenceManager.readByXML(this, xml, parent);
        }
        catch (IOException e2) {
            TWaverUtil.handleError(null, e2);
        }
    }

    public String toXML() {
        return this.toXML(new DataBoxOutputSetting());
    }

    public String toXML(DataBoxOutputSetting setting) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        setting.setOutputStream(out);
        try {
            twaver.base.A.E.Q.A(this, setting);
            out.close();
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException ex) {
            TWaverUtil.handleError(null, ex);
            return null;
        }
    }

    public void clearAllElementAlarmState() {
        Iterator it = this.O.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            element.getAlarmState().clear();
        }
    }

    public boolean isEnableAdjustIndex() {
        return this.K;
    }

    public void setEnableAdjustIndex(boolean enableAdjustIndex) {
        this.K = enableAdjustIndex;
    }

    public String getVersion() {
        return this.H;
    }

    public void setVersion(String version) {
        String oldValue = this.H;
        this.H = version;
        this.firePropertyChange("version", oldValue, this.H);
    }

    public Object getID() {
        return this.S;
    }

    public void setID(Object id) {
        Object oldValue = this.S;
        this.S = id;
        this.firePropertyChange("id", oldValue, this.S);
    }

    public VisibleFilter getLinkBundleFilter() {
        return this.F;
    }

    public void setLinkBundleFilter(VisibleFilter linkBundleFilter) {
        this.F = linkBundleFilter;
    }
}

