/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.dropdown.component;

import com.nepxion.swing.menuitem.JBasicCheckBoxMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.selector.dropdown.IDropDownPopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownDraggablePopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownPane;
import com.nepxion.swing.selector.dropdown.JDropDownPopupMenu;
import com.nepxion.swing.selector.dropdown.JDropDownSelector;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public abstract class JTableDropDownSelector
extends JDropDownSelector {
    private JTable table;
    private JBasicPopupMenu popupMenu;
    private JBasicCheckBoxMenuItem showPathMenuItem;
    private JBasicCheckBoxMenuItem showRootMenuItem;
    private String text;

    public JTableDropDownSelector(JTable table) {
        this(table, true);
    }

    public JTableDropDownSelector(JTable table, boolean isDraggablePopupMenu) {
        this.table = table;
        IDropDownPopupMenu dropDownPopupMenu = null;
        dropDownPopupMenu = isDraggablePopupMenu ? new JDropDownDraggablePopupMenu() : new JDropDownPopupMenu();
        DropDownPane dropDownPane = new DropDownPane(dropDownPopupMenu, table);
        this.setDropDownPane(dropDownPane);
        this.getTextField().addMouseListener(new TextFieldMouseListener());
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean doConfirm() {
        boolean returnValue = this.confirm();
        if (returnValue) {
            this.adaptText();
        }
        return returnValue;
    }

    private void adaptText() {
    }

    public boolean doCancel() {
        return this.cancel();
    }

    public abstract boolean confirm();

    public abstract boolean cancel();

    public class TextFieldMouseListener
    extends MouseAdapter {
        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            JTableDropDownSelector.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public class DropDownPane
    extends JDropDownPane {
        public DropDownPane(IDropDownPopupMenu popupMenu, JTable table) {
            super(popupMenu, new JBasicScrollPane(table));
        }

        @Override
        public boolean confirm() {
            return JTableDropDownSelector.this.doConfirm();
        }

        @Override
        public boolean cancel() {
            return JTableDropDownSelector.this.doCancel();
        }
    }
}

