/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.query.condition;

import com.nepxion.swing.border.BorderManager;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.selector.calendar.JDateTimeSelector;
import com.nepxion.swing.selector.calendar.editor.JSpinnerDateTimeEditor;
import com.nepxion.swing.validation.IValidation;
import com.nepxion.util.time.TimeUtil;
import com.toedter.calendar.IDateEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class JQueryDateTimeBar
extends JPanel
implements SwingConstants,
IValidation {
    private JDateTimeSelector startDateTimeSelector;
    private JDateTimeSelector endDateTimeSelector;

    public JQueryDateTimeBar() {
        this(1);
    }

    public JQueryDateTimeBar(int direction) {
        Date endDateTime = new Date();
        Date startDateTime = TimeUtil.calculateDateTime((Date)endDateTime, (int)10, (int)-24);
        JLabel startDateTimeLabel = new JLabel(SwingLocale.getString("start_time"));
        JLabel endDateTimeLabel = new JLabel(SwingLocale.getString("end_time"));
        this.startDateTimeSelector = new JDateTimeSelector(startDateTime, "yyyy-MM-dd HH:mm:ss", (IDateEditor)new JSpinnerDateTimeEditor());
        this.endDateTimeSelector = new JDateTimeSelector(endDateTime, "yyyy-MM-dd HH:mm:ss", (IDateEditor)new JSpinnerDateTimeEditor());
        switch (direction) {
            case 1: {
                double[][] size = new double[][]{{60.0, -1.0}, {-2.0, -2.0}};
                TableLayout tableLayout = new TableLayout(size);
                tableLayout.setHGap(5);
                tableLayout.setVGap(5);
                this.setLayout(tableLayout);
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), BorderManager.createComplexTitledBorder(SwingLocale.getString("time_parameter"))));
                this.add((Component)startDateTimeLabel, "0, 0");
                this.add((Component)((Object)this.startDateTimeSelector), "1, 0");
                this.add((Component)endDateTimeLabel, "0, 1");
                this.add((Component)((Object)this.endDateTimeSelector), "1, 1");
                break;
            }
            case 0: {
                DimensionManager.setDimension((Component)((Object)this.startDateTimeSelector), new Dimension(180, this.startDateTimeSelector.getPreferredSize().height));
                DimensionManager.setDimension((Component)((Object)this.endDateTimeSelector), new Dimension(180, this.endDateTimeSelector.getPreferredSize().height));
                this.setLayout(new BoxLayout(this, 0));
                this.add(startDateTimeLabel);
                this.add((Component)((Object)this.startDateTimeSelector));
                this.add(Box.createHorizontalStrut(5));
                this.add(endDateTimeLabel);
                this.add((Component)((Object)this.endDateTimeSelector));
            }
        }
    }

    public JDateTimeSelector getStartDateTimeSelector() {
        return this.startDateTimeSelector;
    }

    public void setStartDateTimeSelector(JDateTimeSelector startDateTimeSelector) {
        this.startDateTimeSelector = startDateTimeSelector;
    }

    public JDateTimeSelector getEndDateTimeSelector() {
        return this.endDateTimeSelector;
    }

    public void setEndDateTimeSelector(JDateTimeSelector endDateTimeSelector) {
        this.endDateTimeSelector = endDateTimeSelector;
    }

    public String getTimeRange() {
        Date startDateTime = this.startDateTimeSelector.getDate();
        Date endDateTime = this.endDateTimeSelector.getDate();
        return TimeUtil.getDateTime((Date)startDateTime) + " - " + TimeUtil.getDateTime((Date)endDateTime);
    }

    @Override
    public boolean verify() {
        Date startDateTime = this.startDateTimeSelector.getDate();
        Date endDateTime = this.endDateTimeSelector.getDate();
        return TimeUtil.isTimeBefore((String)TimeUtil.getDateTime((Date)startDateTime), (String)TimeUtil.getDateTime((Date)endDateTime));
    }
}

