/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import y.algo.Bipartitions;
import y.algo.GraphConnectivity;
import y.algo.NodeOrders;
import y.algo.Trees;
import y.algo.if;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;

public class GraphChecker {
    public static boolean isAcyclic(Graph graph) {
        return NodeOrders.topological(graph, new int[graph.nodeCount()]);
    }

    public static boolean isCyclic(Graph graph) {
        return !GraphChecker.isAcyclic(graph);
    }

    public static boolean isPlanar(Graph graph) {
        return new if().a(graph);
    }

    public static boolean isConnected(Graph graph) {
        return GraphConnectivity.isConnected(graph);
    }

    public static boolean isBiconnected(Graph graph) {
        return GraphConnectivity.isBiconnected(graph);
    }

    public static boolean isBipartite(Graph graph) {
        return Bipartitions.isBipartite(graph);
    }

    public static boolean isNaryTree(Graph graph, int n) {
        return Trees.isNaryTree(graph, n);
    }

    public static boolean isRootedTree(Graph graph) {
        return Trees.isRootedTree(graph);
    }

    public static boolean isTree(Graph graph) {
        return Trees.isTree(graph);
    }

    public static boolean isForest(Graph graph) {
        return Trees.isForest(graph);
    }

    public static boolean isSelfLoopFree(Graph graph) {
        EdgeCursor edgeCursor = graph.edges();
        while (edgeCursor.ok()) {
            if (edgeCursor.edge().isSelfLoop()) {
                return false;
            }
            edgeCursor.next();
        }
        return true;
    }

    public static boolean isSimple(Graph graph) {
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            int n = node.index() + 1;
            NodeCursor nodeCursor2 = node.successors();
            while (nodeCursor2.ok()) {
                Node node2 = nodeCursor2.node();
                int n2 = node2.index();
                if (nArray[n2] == n) {
                    return false;
                }
                nArray[n2] = n;
                nodeCursor2.next();
            }
            nodeCursor.next();
        }
        return true;
    }

    public static boolean isMultipleEdgeFree(Graph graph) {
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            int n = node.index() + 1;
            NodeCursor nodeCursor2 = node.neighbors();
            while (nodeCursor2.ok()) {
                Node node2 = nodeCursor2.node();
                int n2 = node2.index();
                if (nArray[n2] == n) {
                    return false;
                }
                nArray[n2] = n;
                nodeCursor2.next();
            }
            nodeCursor.next();
        }
        return true;
    }
}

