/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.net.http.apache;

import com.nepxion.util.encoder.EncoderContext;
import com.nepxion.util.encoder.EncoderUtil;
import com.nepxion.util.io.IOUtil;
import com.nepxion.util.net.http.HttpConstants;
import com.nepxion.util.net.http.apache.ServerLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerInvoker
extends HttpServlet
implements HttpConstants {
    public static final int REQUEST_ENTITY_TYPE_PARAMETER = 0;
    public static final int REQUEST_ENTITY_TYPE_STRING = 1;
    public static final int REQUEST_ENTITY_TYPE_SERIALIZABLE = 2;
    public static final int RESPONSE_ENTITY_TYPE_STREAM = 3;
    public static final int RESPONSE_ENTITY_TYPE_PRINTWRITER = 4;
    private int requestEntityType = 2;
    private int responseEntityType = 3;
    private String charset = EncoderContext.getHttpCharset();

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doExecute(request, response, "Get");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doExecute(request, response, "Post");
    }

    public void doExecute(HttpServletRequest request, HttpServletResponse response, String method) throws ServletException, IOException {
        IllegalArgumentException illegalArgumentException;
        HashMap<String, String> requestObject = null;
        switch (this.requestEntityType) {
            case 0: {
                HashMap<String, String> parameters = new HashMap<String, String>();
                Enumeration enumeration = request.getParameterNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = request.getParameter(key);
                    if (method.equals("Get")) {
                        value = EncoderUtil.format(value, this.charset);
                    }
                    parameters.put(key, value);
                }
                requestObject = parameters;
                ServerLogger.requestInfo(method, this.charset, "List - [URL Parameter]", requestObject);
                break;
            }
            case 1: {
                requestObject = IOUtil.getString((InputStream)request.getInputStream(), this.charset);
                ServerLogger.requestInfo(method, this.charset, "String - [Text, XML, JSON, Properties ...]", requestObject);
                break;
            }
            case 2: {
                try {
                    requestObject = IOUtil.read((InputStream)request.getInputStream());
                }
                catch (Exception e) {
                    illegalArgumentException = new IllegalArgumentException("The request serializable entity is null or invalid");
                    ServerLogger.responseInfo("Serializable Entity", illegalArgumentException);
                    illegalArgumentException.printStackTrace();
                }
                ServerLogger.requestInfo(method, "Serializable Entity", requestObject);
            }
        }
        Object responseObject = this.invoke(requestObject, request, response);
        switch (this.responseEntityType) {
            case 3: {
                if (responseObject != null) {
                    ServerLogger.responseInfo("Serializable Entity", responseObject);
                    IOUtil.write((OutputStream)response.getOutputStream(), responseObject);
                    break;
                }
                illegalArgumentException = new IllegalArgumentException("The response serializable entity is null or invalid");
                ServerLogger.responseInfo("Serializable Entity", illegalArgumentException);
                IOUtil.write((OutputStream)response.getOutputStream(), illegalArgumentException);
                break;
            }
            case 4: {
                ServerLogger.responseInfo("String - [Text, XML, JSON, Properties ...]", "It is output by the PrintWriter");
            }
        }
    }

    public Object invoke(Object requestObject, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return null;
    }

    public int getRequestEntityType() {
        return this.requestEntityType;
    }

    public void setRequestEntityType(int requestEntityType) {
        this.requestEntityType = requestEntityType;
    }

    public int getResponseEntityType() {
        return this.responseEntityType;
    }

    public void setResponseEntityType(int responseEntityType) {
        this.responseEntityType = responseEntityType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

