/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table;

import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.table.ITable;
import com.nepxion.swing.table.ITableAdapter;
import com.nepxion.swing.table.ITableModel;
import com.nepxion.swing.table.TableManager;
import com.nepxion.swing.thread.dialog.JThreadDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;

public class TableController {
    public static void add(JTable table, ITableAdapter tableAdapter) {
        if (!tableAdapter.addRowPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table") + SwingLocale.getString("add_record_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        Object rowData = tableAdapter.addRow();
        if (rowData == null) {
            return;
        }
        ITableModel tableModel = TableManager.getModel(table);
        tableModel.addRow(rowData);
    }

    public static void modify(JTable table, ITableAdapter tableAdapter) {
        boolean isSingleSelection = TableController.isSingleSelection(table, SwingLocale.getString("modify") + SwingLocale.getString("record"));
        if (!isSingleSelection) {
            return;
        }
        int selectedRow = table.getSelectedRow();
        if (!tableAdapter.modifyRowPermitted(selectedRow)) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table_row_selection") + SwingLocale.getString("modify_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedRowIndex = ((ITable)((Object)table)).getRowIndexToModel(selectedRow);
        Object rowData = tableAdapter.modifyRow(selectedRowIndex);
        if (rowData == null) {
            return;
        }
        ITableModel tableModel = TableManager.getModel(table);
        tableModel.updateRow(rowData, selectedRowIndex);
    }

    public static void delete(final JTable table, final ITableAdapter tableAdapter) {
        boolean isMultiSelection = TableController.isMultiSelection(table, SwingLocale.getString("delete") + SwingLocale.getString("record"));
        if (!isMultiSelection) {
            return;
        }
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length == 1) {
            int selectedRow = selectedRows[0];
            if (!tableAdapter.deleteRowPermitted(selectedRow)) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table_row_selection") + SwingLocale.getString("delete_no_permission"), SwingLocale.getString("warning"), 2);
                return;
            }
            int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_delete_selected_records"), SwingLocale.getString("confirm"), 0);
            if (selectedValue != 0) {
                return;
            }
            final int selectedRowIndex = ((ITable)((Object)table)).getRowIndexToModel(selectedRow);
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(table), SwingLocale.getString("delete"), SwingLocale.getString("delete_and_wait")){

                @Override
                protected void loadForeground(Object data) throws Exception {
                    Boolean flag = (Boolean)data;
                    if (flag.booleanValue()) {
                        ITableModel tableModel = TableManager.getModel(table);
                        tableModel.deleteRow(selectedRowIndex);
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("delete_record_success"), SwingLocale.getString("information"), 1);
                    }
                }

                @Override
                protected Object loadBackground() throws Exception {
                    return tableAdapter.deleteRow(selectedRowIndex);
                }
            };
            dialog.execute();
        } else {
            if (!tableAdapter.deleteRowsPermitted(selectedRows)) {
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table_row_selection") + SwingLocale.getString("delete_no_permission"), SwingLocale.getString("warning"), 2);
                return;
            }
            int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_delete_selected_records"), SwingLocale.getString("confirm"), 0);
            if (selectedValue != 0) {
                return;
            }
            final int[] selectedRowIndexes = ((ITable)((Object)table)).getRowIndexesToModel(selectedRows);
            JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(table), SwingLocale.getString("delete"), SwingLocale.getString("delete_and_wait")){

                @Override
                protected void loadForeground(Object data) throws Exception {
                    Boolean flag = (Boolean)data;
                    if (flag.booleanValue()) {
                        ITableModel tableModel = TableManager.getModel(table);
                        tableModel.deleteRows(selectedRowIndexes);
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("delete_record_success"), SwingLocale.getString("information"), 1);
                    }
                }

                @Override
                protected Object loadBackground() throws Exception {
                    return tableAdapter.deleteRows(selectedRowIndexes);
                }
            };
            dialog.execute();
        }
    }

    public static void refresh(final JTable table, final ITableAdapter tableAdapter) {
        if (!tableAdapter.refreshPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table") + SwingLocale.getString("refresh_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (table.getRowCount() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("no_refresh_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_refresh"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(table), SwingLocale.getString("refresh"), SwingLocale.getString("refresh_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                List rowDatas = (List)data;
                TableController.setRowDatas(table, rowDatas);
            }

            @Override
            protected Object loadBackground() throws Exception {
                List rowDatas = tableAdapter.refresh();
                return rowDatas;
            }
        };
        dialog.execute();
    }

    public static void clear(final JTable table, final ITableAdapter tableAdapter) {
        if (!tableAdapter.clearPermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table") + SwingLocale.getString("clear_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (table.getRowCount() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("no_clear_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_clear"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(table), SwingLocale.getString("clear"), SwingLocale.getString("clear_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                Boolean flag = (Boolean)data;
                if (flag.booleanValue()) {
                    ITableModel tableModel = TableManager.getModel(table);
                    tableModel.clearRows();
                }
            }

            @Override
            protected Object loadBackground() throws Exception {
                return tableAdapter.clear();
            }
        };
        dialog.execute();
    }

    public static void save(final JTable table, final ITableAdapter tableAdapter) {
        if (!tableAdapter.savePermitted()) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("table") + SwingLocale.getString("save_no_permission"), SwingLocale.getString("warning"), 2);
            return;
        }
        if (table.getRowCount() == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("no_save_records"), SwingLocale.getString("warning"), 2);
            return;
        }
        int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(table), SwingLocale.getString("confirm_to_save"), SwingLocale.getString("confirm"), 0);
        if (selectedValue != 0) {
            return;
        }
        JThreadDialog dialog = new JThreadDialog(HandleManager.getFrame(table), SwingLocale.getString("save"), SwingLocale.getString("save_and_wait")){

            @Override
            protected void loadForeground(Object data) throws Exception {
                List rowDatas = (List)data;
                TableController.setRowDatas(table, rowDatas);
                JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("save_record_success"), SwingLocale.getString("information"), 1);
            }

            @Override
            protected Object loadBackground() throws Exception {
                List rowDatas = tableAdapter.save();
                return rowDatas;
            }
        };
        dialog.execute();
    }

    public static void setRowDatas(JTable table, List rowDatas) {
        ITableModel tableModel = TableManager.getModel(table);
        tableModel.setRowDatas(rowDatas);
    }

    public static boolean isSingleSelection(JTable table, String operationName) {
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("select_records_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        if (selectedRows.length != 1) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("select_one_node_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static boolean isMultiSelection(JTable table, String operationName) {
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            JBasicOptionPane.showMessageDialog(HandleManager.getFrame(table), SwingLocale.getString("select_records_to") + " " + SwingLocale.getString("quotation_left") + operationName + SwingLocale.getString("quotation_right"), SwingLocale.getString("warning"), 2);
            return false;
        }
        return true;
    }

    public static JSecurityAction getAddAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("add"), IconFactory.getSwingIcon("stereo/add_16.png"), SwingLocale.getString("add") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.add(table, tableAdapter);
            }
        };
        KeyStrokeManager.registerComponent(table, action, 78, 2);
        return action;
    }

    public static JSecurityAction getModifyAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("modify"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("modify") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.modify(table, tableAdapter);
            }
        };
        KeyStrokeManager.registerComponent(table, action, 73, 2);
        return action;
    }

    public static JSecurityAction getDeleteAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("delete"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("delete") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.delete(table, tableAdapter);
            }
        };
        KeyStrokeManager.registerComponent((JComponent)table, (ActionListener)action, 127);
        return action;
    }

    public static JSecurityAction getRefreshAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("refresh"), IconFactory.getSwingIcon("stereo/refresh_16.png"), SwingLocale.getString("refresh") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.refresh(table, tableAdapter);
            }
        };
        return action;
    }

    public static JSecurityAction getClearAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("clear"), IconFactory.getSwingIcon("stereo/delete_16.png"), SwingLocale.getString("clear") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.clear(table, tableAdapter);
            }
        };
        return action;
    }

    public static JSecurityAction getSaveAction(final JTable table, final ITableAdapter tableAdapter) {
        JSecurityAction action = new JSecurityAction(SwingLocale.getString("save"), IconFactory.getSwingIcon("solid_save.png"), SwingLocale.getString("save") + SwingLocale.getString("record")){

            @Override
            public void execute(ActionEvent e) {
                TableController.save(table, tableAdapter);
            }
        };
        return action;
    }
}

