/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import com.nepxion.swing.icon.paint.CloseIcon;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CloseTabIcon
implements Icon {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean isHint = false;
    private CloseIcon closeIcon;
    private Icon icon;

    public CloseTabIcon(Icon icon) {
        this(icon, true, true, false);
    }

    public CloseTabIcon(Icon icon, boolean isDrawBorder, boolean isDrawCenter, boolean isHint) {
        this.icon = icon;
        this.closeIcon = new CloseIcon(isDrawBorder, isDrawCenter);
        this.isHint = isHint;
        if (LookAndFeelManager.isNimbusLookAndFeel()) {
            this.width = this.closeIcon.getIconWidth() + 4;
            this.height = this.closeIcon.getIconHeight();
        } else {
            this.width = this.closeIcon.getIconWidth() + 4;
            this.height = this.closeIcon.getIconHeight() + 2;
        }
    }

    public CloseIcon getCloseIcon() {
        return this.closeIcon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public boolean isHint() {
        return this.isHint;
    }

    public void setHint(boolean isHint) {
        this.isHint = isHint;
    }

    public Rectangle getBounds() {
        if (LookAndFeelManager.isNimbusLookAndFeel()) {
            return new Rectangle(this.x + 4, this.y, this.closeIcon.getIconWidth(), this.closeIcon.getIconHeight());
        }
        return new Rectangle(this.x, this.y, this.closeIcon.getIconWidth(), this.closeIcon.getIconHeight());
    }

    @Override
    public int getIconWidth() {
        return this.width + (this.icon != null ? this.icon.getIconWidth() : 0);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.x = x;
        this.y = y;
        if (this.closeIcon != null) {
            if (LookAndFeelManager.isNimbusLookAndFeel()) {
                this.closeIcon.paintIcon(c, g, x + 4, y);
            } else {
                this.closeIcon.paintIcon(c, g, x, y);
            }
        }
        if (this.icon != null) {
            if (LookAndFeelManager.isNimbusLookAndFeel()) {
                this.icon.paintIcon(c, g, x + this.width + 4, y);
            } else {
                this.icon.paintIcon(c, g, x + this.width, y);
            }
        }
    }
}

