/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.base.A.E.M;
import twaver.table.editor.TextActionTableCellEditor;

public class ColorEditor
extends TextActionTableCellEditor {
    public ColorEditor() {
        this(TUIManager.getString("table.alignment.color"));
    }

    public ColorEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.textField, alignment);
    }

    public void actionPerformed(ActionEvent e2) {
        String title = TWaverUtil.getString("PICK_COLOR");
        Color color = (Color)this.value;
        Color selectedColor = JColorChooser.showDialog(this.getWindow(), title, color);
        if (selectedColor != null) {
            String colorString = M.A(selectedColor, true);
            this.textField.setText(colorString);
            this.stopCellEditing();
        }
    }

    public void setComponentValue() {
        if (this.value instanceof Color) {
            this.textField.setText(M.A((Color)this.value, true));
        } else {
            this.textField.setText(null);
        }
    }

    public Object getCellEditorValue() {
        if (this.isClear) {
            return null;
        }
        String text = this.textField.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        try {
            Color color = M.D(text);
            return color;
        }
        catch (Exception ex) {
            return this.value;
        }
    }
}

