/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.style.button;

import com.nepxion.swing.button.IButtonModel;
import com.nepxion.swing.style.button.IButtonUI;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public abstract class AbstractButtonUI
extends BasicButtonUI
implements IButtonUI {
    private Color shadow = UIManager.getColor("controlShadow");
    private Color darkShadow = Color.black;
    private int widthOffset = 0;
    private int heightOffset = 0;
    protected boolean isArrowPainted = true;

    public int getWidthOffset() {
        return this.widthOffset;
    }

    public void setWidthOffset(int widthOffset) {
        this.widthOffset = widthOffset;
    }

    public int getHeightOffset() {
        return this.heightOffset;
    }

    public void setHeightOffset(int heightOffset) {
        this.heightOffset = heightOffset;
    }

    public boolean isArrowPainted() {
        return this.isArrowPainted;
    }

    public void setArrowPainted(boolean isArrowPainted) {
        this.isArrowPainted = isArrowPainted;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton button = (AbstractButton)c;
        button.setRolloverEnabled(true);
        button.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        IButtonModel buttonModel = (IButtonModel)button.getModel();
        Action action = button.getAction();
        if (action != null && !action.isEnabled()) {
            buttonModel.setEnabled(false);
        }
        Color background = g.getColor();
        if (buttonModel.isMenuDropDown()) {
            this.paintMenuDropDown(buttonModel, g, c);
        } else if (buttonModel.isPressed()) {
            this.paintPressed(buttonModel, g, c);
        } else if (buttonModel.isSelected()) {
            this.paintSelected(buttonModel, g, c);
        } else if (buttonModel.isRollover()) {
            this.paintRollover(buttonModel, g, c);
        }
        if (this.isArrowPainted) {
            this.paintArrow(buttonModel, g, c);
        }
        g.setColor(background);
        super.paint(g, c);
    }

    public abstract void paintMenuDropDown(IButtonModel var1, Graphics var2, JComponent var3);

    public abstract void paintPressed(IButtonModel var1, Graphics var2, JComponent var3);

    public abstract void paintSelected(IButtonModel var1, Graphics var2, JComponent var3);

    public abstract void paintRollover(IButtonModel var1, Graphics var2, JComponent var3);

    public void paintArrow(IButtonModel buttonModel, Graphics g, JComponent c) {
        if (buttonModel.isEnabled()) {
            g.setColor(this.darkShadow);
        } else {
            g.setColor(this.shadow);
        }
        g.drawLine(c.getWidth() - 6 - 2, c.getHeight() / 2 - 1, c.getWidth() - 6 + 2, c.getHeight() / 2 - 1);
        g.drawLine(c.getWidth() - 6 - 1, c.getHeight() / 2, c.getWidth() - 6 + 1, c.getHeight() / 2);
        g.drawLine(c.getWidth() - 6, c.getHeight() / 2 + 1, c.getWidth() - 6, c.getHeight() / 2 + 1);
    }
}

