/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.inputhandler;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import twaver.TWaverUtil;
import twaver.network.CanvasMarker;
import twaver.network.TNetwork;
import twaver.network.inputhandler.InputAdapter;

public abstract class CreatePointsInputHandler
extends InputAdapter
implements CanvasMarker {
    protected TNetwork network;
    protected Point movingPoint = null;
    protected List points = new ArrayList();
    protected List buttonTags = new ArrayList();
    private long R = 0L;

    public CreatePointsInputHandler(TNetwork network) {
        this.network = network;
    }

    public TNetwork getNetwork() {
        return this.network;
    }

    public void mouseDragged(MouseEvent e2) {
        if (e2.isShiftDown()) {
            this.mousePressed(e2);
        }
    }

    public void mousePressed(MouseEvent e2) {
        this.D();
        this.movingPoint = null;
        if (this.isValid(e2)) {
            this.points.add(this.B(e2));
            this.buttonTags.add(SwingUtilities.isLeftMouseButton(e2));
        }
        if (this.multiPointProcess(e2, this.points, this.buttonTags)) {
            this.C();
            this.network.getCanvas().repaint();
        } else {
            this.movingPoint = this.B(e2);
        }
    }

    protected boolean isValid(MouseEvent e2) {
        if (e2.isShiftDown()) {
            long current = e2.getWhen();
            if (current - this.R > 100L) {
                this.R = current;
                return true;
            }
            return false;
        }
        return e2.getClickCount() == 1;
    }

    private void C() {
        if (this.points.size() > 0) {
            this.points = new ArrayList();
        }
        if (this.buttonTags.size() > 0) {
            this.buttonTags = new ArrayList();
        }
        this.movingPoint = null;
    }

    private Point B(MouseEvent e2) {
        double zoom = this.network.getZoomer().getZoom();
        Point point = (Point)e2.getPoint().clone();
        point.x = (int)((double)point.x / zoom);
        point.y = (int)((double)point.y / zoom);
        return point;
    }

    public void mouseMoved(MouseEvent e2) {
        if (this.points.size() > 0) {
            this.D();
            this.movingPoint = this.B(e2);
            this.D();
        }
    }

    private void D() {
        if (this.points.size() > 0 && this.movingPoint != null) {
            Point point = (Point)this.points.get(this.points.size() - 1);
            Rectangle rect = TWaverUtil.getRectangle(point, this.movingPoint);
            this.network.getRenderer().repaintLogicalBounds(rect);
        }
        this.network.getCanvas().repaint();
    }

    public abstract boolean multiPointProcess(MouseEvent var1, List var2, List var3);

    public void mark(Graphics2D g2) {
        if (this.points.size() == 0) {
            return;
        }
        ArrayList<Point> list = new ArrayList<Point>();
        list.addAll(this.points);
        if (this.movingPoint != null) {
            list.add(this.movingPoint);
        }
        if (list.size() > 1) {
            TWaverUtil.drawDashShape(g2, this.getPath());
        }
    }

    public GeneralPath getPath() {
        GeneralPath path = new GeneralPath();
        ArrayList<Point> list = new ArrayList<Point>();
        list.addAll(this.points);
        if (this.movingPoint != null) {
            list.add(this.movingPoint);
        }
        if (list.size() > 1) {
            path = new GeneralPath();
            Point point = (Point)list.get(0);
            path.moveTo(point.x, point.y);
            for (int i2 = 1; i2 < list.size(); ++i2) {
                point = (Point)list.get(i2);
                path.lineTo(point.x, point.y);
            }
        }
        return path;
    }

    public void init() {
        this.C();
        this.network.addCanvasMarker(this);
    }

    public void cleanup() {
        this.C();
        this.network.removeCanvasMarker(this);
    }
}

