/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searchable;

import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.nepxion.swing.searchable.JComboBoxSearchable;
import com.nepxion.swing.searchable.JListSearchable;
import com.nepxion.swing.searchable.JSearchableContainer;
import com.nepxion.swing.searchable.JTableSearchable;
import com.nepxion.swing.searchable.JTextComponentSearchable;
import com.nepxion.swing.searchable.JTreeSearchable;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class JSearchableFactory {
    public static JTreeSearchable installSearchable(JTree tree) {
        JTreeSearchable treeSearchable = new JTreeSearchable(tree);
        treeSearchable.setRepeats(true);
        treeSearchable.setRecursive(true);
        return treeSearchable;
    }

    public static JTableSearchable installSearchable(JTable table) {
        JTableSearchable tableSearchable = new JTableSearchable(table);
        tableSearchable.setRepeats(true);
        return tableSearchable;
    }

    public static JListSearchable installSearchable(JList list) {
        JListSearchable listSearchable = new JListSearchable(list);
        listSearchable.setRepeats(true);
        return listSearchable;
    }

    public static JComboBoxSearchable installSearchable(JComboBox comboBox) {
        JComboBoxSearchable comboBoxSearchable = new JComboBoxSearchable(comboBox);
        comboBoxSearchable.setRepeats(true);
        return comboBoxSearchable;
    }

    public static JTextComponentSearchable installSearchable(JTextComponent textComponent) {
        JTextComponentSearchable textComponentSearchable = new JTextComponentSearchable(textComponent);
        textComponentSearchable.setRepeats(true);
        return textComponentSearchable;
    }

    public static void uninstallSearchable(Searchable searchable) {
        searchable.uninstallListeners();
    }

    public static void installSearchableBar(JComponent component, JSearchableContainer searchableContainer) {
        JSearchableFactory.installSearchableBar(component, searchableContainer, false);
    }

    public static void installSearchableBar(JComponent component, final JSearchableContainer searchableContainer, boolean disableEscKeyboard) {
        Object searchable = null;
        if (component instanceof JTree) {
            searchable = JSearchableFactory.installSearchable((JTree)component);
        } else if (component instanceof JTable) {
            searchable = JSearchableFactory.installSearchable((JTable)component);
        } else if (component instanceof JList) {
            searchable = JSearchableFactory.installSearchable((JList)component);
        } else if (component instanceof JComboBox) {
            searchable = JSearchableFactory.installSearchable((JComboBox)component);
        } else if (component instanceof JTextComponent) {
            searchable = JSearchableFactory.installSearchable((JTextComponent)component);
        }
        if (searchable == null) {
            return;
        }
        searchable.setRepeats(true);
        SearchableBar searchableBar = SearchableBar.install((Searchable)searchable, (KeyStroke)KeyStroke.getKeyStroke(70, 2), (SearchableBar.Installer)new SearchableBar.Installer(){

            public void openSearchBar(SearchableBar searchableBar) {
                searchableContainer.show((Component)searchableBar);
            }

            public void closeSearchBar(SearchableBar searchableBar) {
                searchableContainer.hide((Component)searchableBar);
            }
        });
        if (disableEscKeyboard) {
            NullPanel nullPanel = (NullPanel)searchableBar.getComponent(5);
            JTextField textField = (JTextField)nullPanel.getComponent(0);
            textField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
    }
}

