/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.dialog;

import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.dialog.DialogResizer;
import com.nepxion.swing.dialog.JBasicDialog;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.textarea.JBasicTextArea;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.util.exception.ExceptionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JExceptionDialog
extends JBasicDialog {
    private static JExceptionDialog exceptionDialog;
    private JBasicTextField hintTextField;
    private JBasicTextField toggleTextField;
    private JClassicButton closeButton;
    private JClassicButton detailButton;
    private JBasicTextArea detailTextArea;
    private JPanel bottomPanel;
    private boolean open = false;

    public static void traceException(Component owner, String hint, Exception e) {
        JExceptionDialog.traceException(owner, hint, SwingLocale.getString("exception_detail"), e);
    }

    public static void traceException(Component owner, String hint, String summary, Exception e) {
        if (exceptionDialog == null) {
            exceptionDialog = owner instanceof Dialog ? new JExceptionDialog((Dialog)owner) : (owner instanceof Frame ? new JExceptionDialog((Frame)owner) : new JExceptionDialog(HandleManager.getFrame(owner)));
        }
        if (exceptionDialog == null) {
            return;
        }
        if (!exceptionDialog.isVisible()) {
            exceptionDialog.setException(hint, summary, e);
            exceptionDialog.setVisible(true);
        } else {
            exceptionDialog.addException(e);
        }
    }

    public JExceptionDialog(Dialog owner) {
        super(owner, SwingLocale.getString("exception"), new Dimension(440, 110));
        this.initComponents();
    }

    public JExceptionDialog(Frame owner) {
        super(owner, SwingLocale.getString("exception"), new Dimension(440, 110));
        this.initComponents();
    }

    private void initComponents() {
        JLabel iconLabel = new JLabel(IconFactory.getSwingIcon("warning.png"));
        this.hintTextField = new JBasicTextField(SwingLocale.getString("exception_none"));
        this.hintTextField.setPreferredSize(new Dimension(250, this.hintTextField.getPreferredSize().height));
        this.hintTextField.setLabelStyle();
        this.toggleTextField = new JBasicTextField(SwingLocale.getString("exception_view_description"));
        this.toggleTextField.setPreferredSize(new Dimension(250, this.toggleTextField.getPreferredSize().height));
        this.toggleTextField.setLabelStyle();
        this.closeButton = new JClassicButton(SwingLocale.getString("exception_close"), IconFactory.getSwingIcon("stereo/close_16.png"), SwingLocale.getString("exception_close_tooltip"));
        DimensionManager.setDimension(this.closeButton, new Dimension(96, 29));
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JExceptionDialog.this.setVisible(false);
            }
        };
        this.closeButton.addActionListener(closeActionListener);
        KeyStrokeManager.registerButtonToEscapeKey(this.closeButton, closeActionListener);
        KeyStrokeManager.registerButtonToEnterKey(this.closeButton, closeActionListener);
        this.detailButton = new JClassicButton(SwingLocale.getString("exception_view"), IconFactory.getSwingIcon("stereo/info_16.png"), SwingLocale.getString("exception_view_tooltip"));
        DimensionManager.setDimension(this.detailButton, new Dimension(96, 29));
        ActionListener detailActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JExceptionDialog.this.open) {
                    JExceptionDialog.this.bottomPanel.setVisible(false);
                    JExceptionDialog.this.detailButton.setText(SwingLocale.getString("exception_view"));
                    JExceptionDialog.this.detailButton.setToolTipText(SwingLocale.getString("exception_view_tooltip"));
                    JExceptionDialog.this.toggleTextField.setText(SwingLocale.getString("exception_view_description"));
                    JExceptionDialog.this.setSize(440, 110);
                } else {
                    JExceptionDialog.this.bottomPanel.setVisible(true);
                    JExceptionDialog.this.detailButton.setText(SwingLocale.getString("exception_hide"));
                    JExceptionDialog.this.detailButton.setToolTipText(SwingLocale.getString("exception_hide_tooltip"));
                    JExceptionDialog.this.toggleTextField.setText(SwingLocale.getString("exception_hide_description"));
                    JExceptionDialog.this.setSize(440, 270);
                }
                JExceptionDialog.this.open = !JExceptionDialog.this.open;
            }
        };
        this.detailButton.addActionListener(detailActionListener);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new FiledLayout(0, 0, 0));
        messagePanel.add(Box.createVerticalStrut(7));
        messagePanel.add(this.hintTextField);
        messagePanel.add(Box.createVerticalStrut(2));
        messagePanel.add(this.toggleTextField);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(iconLabel);
        labelPanel.add(Box.createHorizontalStrut(10));
        labelPanel.add(messagePanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.closeButton);
        buttonPanel.add(Box.createVerticalStrut(5));
        buttonPanel.add(this.detailButton);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        topPanel.add((Component)labelPanel, "West");
        topPanel.add((Component)buttonPanel, "East");
        this.detailTextArea = new JBasicTextArea(SwingLocale.getString("exception_detail_none"));
        JBasicScrollPane detailScrollPane = new JBasicScrollPane();
        detailScrollPane.setPreferredSize(new Dimension(400, 150));
        detailScrollPane.setVerticalScrollBarPolicy(22);
        detailScrollPane.getViewport().add(this.detailTextArea);
        this.bottomPanel = new JPanel();
        this.bottomPanel.add(detailScrollPane);
        this.bottomPanel.setVisible(false);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)topPanel, "North");
        container.add((Component)this.bottomPanel, "Center");
        this.setResizable(false);
        for (int i = 0; i < this.getComponentListeners().length; ++i) {
            ComponentListener componentListener = this.getComponentListeners()[i];
            if (!(componentListener instanceof DialogResizer)) continue;
            this.removeComponentListener(componentListener);
            break;
        }
    }

    public void setException(String hint, String summary, Exception e) {
        summary = summary == null ? "" : summary + "\n";
        this.hintTextField.setText(hint);
        this.hintTextField.setCaretPosition(0);
        String exceptionText = ExceptionUtil.getText((Exception)e);
        this.detailTextArea.setText(summary + exceptionText + "\n");
        this.detailTextArea.setCaretPosition(0);
    }

    public void addException(Exception e) {
        String exceptionText = ExceptionUtil.getText((Exception)e);
        this.detailTextArea.setText(this.detailTextArea.getText() + exceptionText + "\n");
        this.detailTextArea.setCaretPosition(0);
    }

    public String getExceptionText() {
        return this.detailTextArea.getText();
    }
}

