/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.table.editor.AbstractCellEditor;

public class ByteEditor
extends AbstractCellEditor {
    public ByteEditor() {
        this(TUIManager.getString("table.alignment.number"));
    }

    public ByteEditor(String alignment) {
        TWaverUtil.setHorizontalAlignment(this.getComponent(), alignment);
    }

    public Object getCellEditorValue() {
        Object value = super.getCellEditorValue();
        if (value == null || "".equals(value)) {
            return null;
        }
        if (value instanceof Byte) {
            return value;
        }
        if (value instanceof Number) {
            return new Byte(((Number)value).byteValue());
        }
        try {
            return new Byte(Byte.parseByte(value.toString()));
        }
        catch (Exception ex) {
            return value;
        }
    }

    public boolean validInputValue(Object inputValue) {
        return inputValue instanceof Byte;
    }
}

