/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.xml.dom4j;

import com.nepxion.util.encoder.EncoderContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class Dom4JWriter {
    public static Document createDocument() {
        return DocumentHelper.createDocument();
    }

    public static String getText(Document document) throws IOException, UnsupportedEncodingException {
        return Dom4JWriter.getText(document, EncoderContext.getIOCharset());
    }

    public static String getText(Document document, String charset) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat("  ", true, charset);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)baos, outputFormat);
            writer.write(document);
            baos.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toString(charset);
    }
}

