/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CombinationIcon
implements Icon {
    private Icon smallIcon;
    private int smallIconX = -1;
    private int smallIconY = -1;
    private Icon largeIcon;
    private int largeIconX = -1;
    private int largeIconY = -1;
    private int xOffset;
    private int yOffset;

    public CombinationIcon(Icon smallIcon, Icon largeIcon, int xOffset, int yOffset) {
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public CombinationIcon(Icon smallIcon, int smallIconX, int smallIconY, Icon largeIcon, int largeIconX, int largeIconY) {
        this.smallIcon = smallIcon;
        this.smallIconX = smallIconX;
        this.smallIconY = smallIconY;
        this.largeIcon = largeIcon;
        this.largeIconX = largeIconX;
        this.largeIconY = largeIconY;
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(Icon smallIcon) {
        this.smallIcon = smallIcon;
    }

    public Icon getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(Icon largeIcon) {
        this.largeIcon = largeIcon;
    }

    @Override
    public int getIconWidth() {
        return this.largeIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.largeIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.largeIcon != null && this.smallIcon != null) {
            if (this.smallIconX == -1 || this.smallIconY == -1 || this.largeIconX == -1 || this.largeIconY == -1) {
                this.largeIcon.paintIcon(c, g, x, y);
                this.smallIcon.paintIcon(c, g, x + this.getIconWidth() / 2 - this.smallIcon.getIconWidth() / 2 + this.xOffset, y + this.getIconHeight() / 2 - this.smallIcon.getIconHeight() / 2 + this.yOffset);
            } else {
                this.largeIcon.paintIcon(c, g, x + this.largeIconX, y + this.largeIconY);
                this.smallIcon.paintIcon(c, g, x + this.smallIconX, y + this.smallIconY);
            }
        }
    }
}

