/*
 * Decompiled with CFR 0.152.
 */
package y.layout.hierarchic;

import y.base.DataProvider;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.geom.YPoint;
import y.layout.LayoutGraph;
import y.layout.hierarchic.AbstractDrawer;
import y.layout.hierarchic.Drawer;
import y.layout.hierarchic.MedianLinearSegmentDrawer;
import y.util.D;

public class TreeDrawer
extends AbstractDrawer {
    private Drawer p = new MedianLinearSegmentDrawer();

    public void setMinimalEdgeDistance(double d2) {
        super.setMinimalEdgeDistance(d2);
        this.p.setMinimalEdgeDistance(d2);
    }

    public void setMinimalMultiEdgeDistance(double d2) {
        super.setMinimalMultiEdgeDistance(d2);
        this.p.setMinimalMultiEdgeDistance(d2);
    }

    public void setMinimalNodeDistance(double d2) {
        this.minimalNodeDistance = d2;
        this.p.setMinimalNodeDistance(d2);
    }

    public void setMinimalLayerDistance(double d2) {
        this.minimalLayerDistance = d2;
        this.p.setMinimalLayerDistance(d2);
    }

    public void setAlternativeDrawer(Drawer drawer) {
        this.p = drawer;
    }

    protected void assignCoordinates(NodeList[] nodeListArray, DataProvider dataProvider) {
        LayoutGraph layoutGraph = this.graph;
        if (this.p != null && this.dummyMap != null) {
            this.p.setDummyMap(this.dummyMap);
        }
        if (nodeListArray[0].size() != 1) {
            D.bug(this, (Object)"Treedrawer: Not a tree !");
            this.p.assignCoordinates(layoutGraph, nodeListArray, dataProvider);
            return;
        }
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            if (nodeCursor.node().inDegree() > 1) {
                D.bug(this, (Object)"Treedrawer: Not a tree !");
                this.p.assignCoordinates(layoutGraph, nodeListArray, dataProvider);
                return;
            }
            nodeCursor.next();
        }
        D.bug(this, (Object)"Treedrawer: It's a tree !");
        NodeCursor[] nodeCursorArray = new NodeCursor[nodeListArray.length];
        int n = 0;
        while (n < nodeListArray.length) {
            nodeCursorArray[n] = nodeListArray[n].nodes();
            ++n;
        }
        this.assignYCoords(layoutGraph, nodeCursorArray);
        Node node = nodeListArray[0].firstNode();
        NodeMap nodeMap = layoutGraph.createNodeMap();
        this.a(layoutGraph, nodeMap, node);
        this.a(layoutGraph, nodeMap, nodeListArray);
        this.a(layoutGraph, nodeCursorArray);
        layoutGraph.disposeNodeMap(nodeMap);
    }

    private double a(LayoutGraph layoutGraph, NodeMap nodeMap, Node node) {
        double d2 = layoutGraph.getWidth(node);
        double d3 = 0.0;
        NodeCursor nodeCursor = node.successors();
        while (nodeCursor.ok()) {
            d3 += this.a(layoutGraph, nodeMap, nodeCursor.node());
            nodeCursor.next();
        }
        d2 = Math.max(d2, d3 += (double)(node.outDegree() - 1) * this.getMinimalNodeDistance());
        nodeMap.setDouble(node, d2);
        D.bug(this, (Object)("Calculated size for: " + node + " -> " + d2));
        return d2;
    }

    private void a(LayoutGraph layoutGraph, NodeMap nodeMap, NodeList[] nodeListArray) {
        NodeMap nodeMap2 = layoutGraph.createNodeMap();
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            nodeMap2.setDouble(nodeCursor.node(), 0.0);
            nodeCursor.next();
        }
        nodeMap2.setDouble(nodeListArray[0].firstNode(), 0.0);
        int n = 0;
        while (n < nodeListArray.length) {
            D.bug(this, (Object)("Layer: " + n));
            double d2 = 0.0;
            NodeCursor nodeCursor2 = nodeListArray[n].nodes();
            while (nodeCursor2.ok()) {
                Node node = nodeCursor2.node();
                D.bug(this, (Object)("Node: " + node));
                d2 = nodeMap2.getDouble(node);
                NodeCursor nodeCursor3 = node.successors();
                while (nodeCursor3.ok()) {
                    Node node2 = nodeCursor3.node();
                    nodeMap2.setDouble(node2, d2);
                    d2 += nodeMap.getDouble(node2) + this.getMinimalNodeDistance();
                    nodeCursor3.next();
                }
                D.bug(this, (Object)("OffsetX: " + nodeMap2.getDouble(node)));
                double d3 = nodeMap2.getDouble(node);
                layoutGraph.setLocation(node, new YPoint(d3, layoutGraph.getY(node)));
                D.bug(this, (Object)("Pos: " + d3));
                nodeCursor2.next();
            }
            ++n;
        }
        layoutGraph.disposeNodeMap(nodeMap2);
    }

    double a(LayoutGraph layoutGraph, Node node, NodeCursor nodeCursor) {
        double d2;
        if (!nodeCursor.ok()) {
            d2 = layoutGraph.getCenter(node).getX();
        } else {
            int n = (nodeCursor.size() - 1) / 2;
            while (n > 0) {
                nodeCursor.next();
                --n;
            }
            d2 = layoutGraph.getCenter(nodeCursor.node()).getX();
            if (nodeCursor.size() % 2 == 0) {
                nodeCursor.next();
                d2 = (d2 + layoutGraph.getCenter(nodeCursor.node()).getX()) / 2.0;
            }
        }
        return d2;
    }

    void a(LayoutGraph layoutGraph, NodeCursor[] nodeCursorArray) {
        int n = nodeCursorArray.length - 1;
        while (n >= 0) {
            double d2 = Double.MAX_VALUE;
            NodeCursor nodeCursor = nodeCursorArray[n];
            nodeCursor.toLast();
            while (nodeCursor.ok()) {
                double d3;
                Node node = nodeCursor.node();
                double d4 = d3 = this.a(layoutGraph, node, node.successors()) - layoutGraph.getWidth(node) / 2.0;
                layoutGraph.setLocation(node, new YPoint(d4, layoutGraph.getY(node)));
                d2 = layoutGraph.getX(node) - this.getMinimalNodeDistance();
                nodeCursor.prev();
            }
            --n;
        }
    }
}

