/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.graph.TGraph;
import com.nepxion.cots.twaver.graph.TGraphControlBar;
import com.nepxion.cots.twaver.graph.TGraphController;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.cots.twaver.locale.TLocale;
import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicSplitButton;
import com.nepxion.swing.button.JClassicMenuButton;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import com.nepxion.swing.menu.JBasicMenu;
import com.nepxion.swing.menuitem.JBasicMenuItem;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.toolbar.JBasicToolBar;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class TGraphToolBar
extends JBasicToolBar {
    public TGraphToolBar(TGraph graph) {
        this(graph, true);
    }

    public TGraphToolBar(TGraph graph, boolean showControlBar) {
        graph.setToolbar((JToolBar)((Object)this));
        JBasicPopupMenu controlBarPopupMenu = new JBasicPopupMenu();
        JBasicMenuItem controlBarVisibleMenuItem = new JBasicMenuItem((Action)TGraphController.getShowControlBarAction(graph));
        controlBarPopupMenu.add((JMenuItem)controlBarVisibleMenuItem);
        JBasicMenuItem controlBarHiddenMenuItem = new JBasicMenuItem((Action)TGraphController.getHideControlBarAction(graph));
        controlBarPopupMenu.add((JMenuItem)controlBarHiddenMenuItem);
        if (showControlBar) {
            controlBarVisibleMenuItem.doClick();
        } else {
            controlBarHiddenMenuItem.doClick();
        }
        controlBarPopupMenu.addSeparator();
        JBasicMenu toggleTabMenu = new JBasicMenu(TLocale.getString("operation_pane_toggle"), TLocale.getString("operation_pane_toggle"));
        toggleTabMenu.setIcon((Icon)TIconFactory.getSwingIcon((String)"toggle_layout.png"));
        controlBarPopupMenu.add((JMenuItem)toggleTabMenu);
        TGraphControlBar controlBar = (TGraphControlBar)((Object)graph.getControlBarInternalFrame().getContent());
        for (int i = 0; i < controlBar.getTabCount(); ++i) {
            JBasicMenuItem toggleMenuItem = new JBasicMenuItem((Action)TGraphController.getToggleControlBarAction(graph.getControlBarInternalFrame(), i));
            toggleTabMenu.add((JMenuItem)toggleMenuItem);
        }
        if (LookAndFeelManager.isNimbusLookAndFeel()) {
            JClassicMenuButton panelButton = new JClassicMenuButton(TLocale.getString("operation_pane"), (Icon)TIconFactory.getContextIcon("pane.png"), TLocale.getString("operation_pane_description"));
            panelButton.setPopupMenu((JPopupMenu)controlBarPopupMenu);
            this.add((Component)panelButton);
        } else {
            JBasicSplitButton panelButton = new JBasicSplitButton((Action)TGraphController.getToggleControlBarAction(graph));
            panelButton.setPopupMenu((JPopupMenu)controlBarPopupMenu);
            this.add((Component)panelButton);
        }
        ButtonManager.updateUI((Container)((Object)this));
    }
}

