/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.icon.paint;

import com.nepxion.swing.icon.paint.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorCombinationIcon
implements Icon {
    private Icon icon;
    private ColorIcon colorIcon;
    private int width;
    private int height;

    public ColorCombinationIcon(Icon icon) {
        this(icon, null);
    }

    public ColorCombinationIcon(Icon icon, Color fillColor) {
        this(icon, fillColor, Color.gray);
    }

    public ColorCombinationIcon(Icon icon, Color fillColor, Color borderColor) {
        this(icon, fillColor, borderColor, 16, 16);
    }

    public ColorCombinationIcon(Icon icon, Color fillColor, Color borderColor, int width, int height) {
        this.icon = icon;
        this.width = width;
        this.height = height;
        this.colorIcon = new ColorIcon(fillColor, borderColor, 16, 4);
    }

    public Color getFillColor() {
        return this.colorIcon.getFillColor();
    }

    public void setFillColor(Color fillColor) {
        this.colorIcon.setFillColor(fillColor);
    }

    public Color getBorderColor() {
        return this.colorIcon.getBorderColor();
    }

    public void setBorderColor(Color borderColor) {
        this.colorIcon.setBorderColor(borderColor);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
        this.colorIcon.paintIcon(c, g, x, y + this.height - 4);
    }
}

