/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.button;

import com.nepxion.swing.button.IToggleButton;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.button.JBasicMenuButton;
import com.nepxion.swing.button.JBasicSplitButton;
import com.nepxion.swing.button.JBasicToggleButton;
import com.nepxion.swing.buttonbar.JBasicButtonBar;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.font.FontContext;
import com.nepxion.swing.lookandfeel.LookAndFeelManager;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.swing.style.button.AbstractButtonUI;
import com.nepxion.swing.style.button.IButtonStyle;
import com.nepxion.swing.style.button.IButtonUI;
import com.nepxion.swing.style.button.flat.FlatButtonUI;
import com.nepxion.swing.style.button.flat.FlatMenuButtonUI;
import com.nepxion.swing.style.button.flat.FlatSplitButtonUI;
import com.nepxion.swing.style.buttonbar.ButtonBarUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

public class ButtonManager
implements SwingConstants {
    private static IButtonUI buttonUI;
    private static IButtonUI menuButtonUI;
    private static IButtonUI splitButtonUI;
    private static IButtonStyle buttonStyle;
    private static FlatButtonUI flatButtonUI;
    private static FlatMenuButtonUI flatMenuButtonUI;
    private static FlatSplitButtonUI flatSplitButtonUI;
    private static ButtonBarUI buttonBarUI;

    public static void setPreferenceStyle(AbstractButton button) {
        if (LookAndFeelManager.isNimbusLookAndFeel()) {
            button.setMargin(new Insets(0, 0, 0, 0));
        } else {
            button.setMargin(new Insets(3, 9, 3, 9));
            button.setFocusPainted(false);
        }
    }

    public static void updateUI(Container container) {
        ButtonManager.updateUI(container, (Insets)null);
    }

    public static void updateUI(Container container, Insets insets) {
        ButtonManager.updateUI(container, insets, new int[]{0, 0});
    }

    public static void updateUI(Container container, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, new int[]{0, 0}, isFlatButtonUI);
    }

    public static void updateUI(Container container, int[] layout) {
        ButtonManager.updateUI(container, (Insets)null, layout);
    }

    public static void updateUI(Container container, Insets insets, int[] layout) {
        ButtonManager.updateUI(container, insets, null, layout);
    }

    public static void updateUI(Container container, ButtonGroup buttonGroup) {
        ButtonManager.updateUI(container, (Insets)null, buttonGroup);
    }

    public static void updateUI(Container container, Insets insets, ButtonGroup buttonGroup) {
        ButtonManager.updateUI(container, insets, buttonGroup, new int[]{0, 0});
    }

    public static void updateUI(Container container, Dimension dimension) {
        ButtonManager.updateUI(container, dimension, false);
    }

    public static void updateUI(Container container, int[] layout, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, (Dimension)null, layout, isFlatButtonUI);
    }

    public static void updateUI(Container container, ButtonGroup buttonGroup, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, null, buttonGroup, isFlatButtonUI);
    }

    public static void updateUI(Container container, Dimension dimension, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, dimension, (ButtonGroup)null, isFlatButtonUI);
    }

    public static void updateUI(Container container, ButtonGroup buttonGroup, int[] layout) {
        ButtonManager.updateUI(container, (Insets)null, buttonGroup, layout);
    }

    public static void updateUI(Container container, Insets insets, ButtonGroup buttonGroup, int[] layout) {
        ButtonManager.updateUI(container, null, insets, buttonGroup, layout, false);
    }

    public static void updateUI(Container container, Dimension dimension, int[] layout) {
        ButtonManager.updateUI(container, dimension, null, layout);
    }

    public static void updateUI(Container container, Dimension dimension, ButtonGroup buttonGroup) {
        ButtonManager.updateUI(container, dimension, buttonGroup, new int[]{0, 0});
    }

    public static void updateUI(Container container, ButtonGroup buttonGroup, int[] layout, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, null, buttonGroup, layout, isFlatButtonUI);
    }

    public static void updateUI(Container container, Dimension dimension, int[] layout, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, dimension, null, layout, isFlatButtonUI);
    }

    public static void updateUI(Container container, Dimension dimension, ButtonGroup buttonGroup, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, dimension, buttonGroup, new int[]{0, 0}, isFlatButtonUI);
    }

    public static void updateUI(Container container, Dimension dimension, ButtonGroup buttonGroup, int[] layout) {
        ButtonManager.updateUI(container, dimension, buttonGroup, layout, false);
    }

    public static void updateUI(Container container, Dimension dimension, ButtonGroup buttonGroup, int[] layout, boolean isFlatButtonUI) {
        ButtonManager.updateUI(container, dimension, null, buttonGroup, layout, isFlatButtonUI);
    }

    public static void updateUI(Container container, Dimension dimension, Insets insets, ButtonGroup buttonGroup, int[] layout, boolean isFlatButtonUI) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof AbstractButton) {
                AbstractButton button;
                IToggleButton toggleButton;
                AbstractButton abstractButton = (AbstractButton)component;
                if (layout != null) {
                    ButtonManager.setButtonLayout(abstractButton, layout);
                }
                if (container instanceof JToolBar) {
                    abstractButton.setFocusPainted(false);
                }
                if (insets != null) {
                    abstractButton.setMargin(insets);
                } else if (container instanceof JToolBar && abstractButton instanceof JButton) {
                    abstractButton.setMargin(new Insets(3, 3, 3, 3));
                }
                abstractButton.setFont(FontContext.getFont());
                if (buttonGroup != null && abstractButton instanceof IToggleButton && (toggleButton = (IToggleButton)((Object)component)).isGrouped()) {
                    buttonGroup.add(abstractButton);
                }
                if (component instanceof JBasicSplitButton) {
                    button = (JBasicSplitButton)component;
                    if (isFlatButtonUI) {
                        if (flatSplitButtonUI == null) {
                            flatSplitButtonUI = new FlatSplitButtonUI();
                        }
                        ((JBasicButton)button).setUI(flatSplitButtonUI);
                    } else {
                        ((JBasicButton)button).setUI((AbstractButtonUI)splitButtonUI);
                    }
                    if (dimension == null) continue;
                    ((JBasicButton)button).setDimension(new Dimension(dimension.width + 5, dimension.height));
                    continue;
                }
                if (component instanceof JBasicMenuButton) {
                    button = (JBasicMenuButton)component;
                    if (isFlatButtonUI) {
                        if (flatMenuButtonUI == null) {
                            flatMenuButtonUI = new FlatMenuButtonUI();
                        }
                        ((JBasicButton)button).setUI(flatMenuButtonUI);
                    } else {
                        ((JBasicButton)button).setUI((AbstractButtonUI)menuButtonUI);
                    }
                    if (dimension == null) continue;
                    if (container instanceof JToolBar) {
                        JToolBar toolBar = (JToolBar)container;
                        if (toolBar.getOrientation() == 1) {
                            ((JBasicButton)button).setDimension(dimension);
                            continue;
                        }
                        ((JBasicButton)button).setDimension(new Dimension(dimension.width + 5, dimension.height));
                        continue;
                    }
                    ((JBasicButton)button).setDimension(new Dimension(dimension.width + 5, dimension.height));
                    continue;
                }
                if (component instanceof JBasicButton) {
                    button = (JBasicButton)component;
                    if (isFlatButtonUI) {
                        if (flatButtonUI == null) {
                            flatButtonUI = new FlatButtonUI();
                        }
                        ((JBasicButton)button).setUI(flatButtonUI);
                    } else {
                        ((JBasicButton)button).setUI((AbstractButtonUI)buttonUI);
                    }
                    if (dimension == null) continue;
                    ((JBasicButton)button).setDimension(dimension);
                    continue;
                }
                if (component instanceof JBasicToggleButton) {
                    button = (JBasicToggleButton)component;
                    if (isFlatButtonUI) {
                        if (flatButtonUI == null) {
                            flatButtonUI = new FlatButtonUI();
                        }
                        ((JBasicToggleButton)button).setUI(flatButtonUI);
                    } else {
                        ((JBasicToggleButton)button).setUI((AbstractButtonUI)buttonUI);
                    }
                    if (dimension == null) continue;
                    ((JBasicToggleButton)button).setDimension(dimension);
                    continue;
                }
                if (dimension == null) continue;
                DimensionManager.setDimension(abstractButton, dimension);
                continue;
            }
            if (!(component instanceof JBasicSeparator)) continue;
            JBasicSeparator separator = (JBasicSeparator)component;
            Dimension size = null;
            size = dimension != null ? dimension : container.getPreferredSize();
            if (container instanceof JToolBar) {
                separator.setLength(separator.getOrientation() == 1 ? size.height - 8 : size.width - 8);
                continue;
            }
            separator.setLength(size.height - 8);
        }
    }

    public static void updateUI(JBasicButtonBar buttonBar) {
        buttonBar.setUI((com.l2fprod.common.swing.plaf.ButtonBarUI)buttonBarUI);
    }

    public static void setButtonLayout(AbstractButton button, int[] layout) {
        int iconTextLayout = layout[0];
        int alignmentLayout = layout[1];
        if (iconTextLayout == 1) {
            button.setHorizontalTextPosition(0);
            button.setVerticalTextPosition(3);
            button.setVerticalAlignment(alignmentLayout);
        } else if (iconTextLayout == 0) {
            button.setHorizontalTextPosition(11);
            button.setVerticalTextPosition(0);
            button.setHorizontalAlignment(alignmentLayout);
        }
    }

    public static void setUI(String buttonUIClass, String menuButtonUIClass, String splitButtonUIClass, String buttonStyleClass) {
        try {
            buttonStyle = (IButtonStyle)Class.forName(buttonStyleClass).newInstance();
            Constructor<?> buttonUIConstructor = Class.forName(buttonUIClass).getConstructor(IButtonStyle.class);
            buttonUI = (IButtonUI)buttonUIConstructor.newInstance(buttonStyle);
            Constructor<?> menuButtonUIConstructor = Class.forName(menuButtonUIClass).getConstructor(IButtonStyle.class);
            menuButtonUI = (IButtonUI)menuButtonUIConstructor.newInstance(buttonStyle);
            Constructor<?> splitButtonUIConstructor = Class.forName(splitButtonUIClass).getConstructor(IButtonStyle.class);
            splitButtonUI = (IButtonUI)splitButtonUIConstructor.newInstance(buttonStyle);
            buttonBarUI = new ButtonBarUI((AbstractButtonUI)buttonUI);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static IButtonUI getButtonUI() {
        return buttonUI;
    }

    public static IButtonUI getMenuButtonUI() {
        return menuButtonUI;
    }

    public static IButtonUI getSplitButtonUI() {
        return splitButtonUI;
    }

    public static IButtonStyle getButtonStyle() {
        return buttonStyle;
    }

    public static ButtonBarUI getButtonBarUI() {
        return buttonBarUI;
    }

    public static String getHtmlText(String text) {
        if (text == null) {
            return null;
        }
        String delimiter = "\n";
        if (text.indexOf(delimiter) > -1) {
            String html = "<html>";
            StringTokenizer stringTokenizer = new StringTokenizer(text, delimiter);
            while (stringTokenizer.hasMoreTokens()) {
                String next = stringTokenizer.nextToken();
                html = html + "<p align=center>" + next + "</p>";
            }
            html = html + "</html>";
            return html;
        }
        return text;
    }
}

