/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import twaver.EnumType;
import twaver.EnumTypeManager;
import twaver.TUIManager;
import twaver.base.A.A.B;
import twaver.swing.TComboBox;

public class EnumTypeEditor
extends DefaultCellEditor {
    private String A = null;
    private boolean B = true;

    public String getEnumTypeName() {
        return this.A;
    }

    public void setEnumTypeName(String enumTypeName) {
        this.A = enumTypeName;
    }

    public boolean isNullable() {
        return this.B;
    }

    public void setNullable(boolean isNullable) {
        this.B = isNullable;
    }

    public EnumTypeEditor(String enumTypeName) {
        this(enumTypeName, "true");
    }

    public EnumTypeEditor(String enumTypeName, String nullable) {
        this(enumTypeName, nullable, TUIManager.getString("table.alignment.enumtype"));
    }

    public EnumTypeEditor(String enumTypeName, String nullable, String alignment) {
        super(new TComboBox());
        this.A = enumTypeName;
        this.B = "true".equalsIgnoreCase(nullable);
        JComboBox comboBox = (JComboBox)this.getComponent();
        comboBox.setRenderer(new B(alignment));
    }

    public Object getCellEditorValue() {
        Object editorValue = super.getCellEditorValue();
        if (editorValue instanceof EnumType) {
            return ((EnumType)editorValue).getValue();
        }
        return editorValue;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox comboBox = (JComboBox)this.getComponent();
        comboBox.removeAllItems();
        Object[] enumTypes = EnumTypeManager.getInstance().getEnumTypes(this.A);
        if (enumTypes == null) {
            comboBox.addItem(value);
        } else {
            if (this.B) {
                comboBox.addItem(null);
            }
            for (int i2 = 0; i2 < enumTypes.length; ++i2) {
                comboBox.addItem(enumTypes[i2]);
            }
        }
        if (enumTypes != null) {
            value = EnumTypeManager.getInstance().getEnumType(this.A, value);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

