/*
 * Decompiled with CFR 0.152.
 */
package twaver.combobox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import twaver.BatchAdapter;
import twaver.BatchEvent;
import twaver.BatchListener;
import twaver.DataBoxEvent;
import twaver.DataBoxListener;
import twaver.DataBoxSelectionEvent;
import twaver.DataBoxSelectionListener;
import twaver.DataBoxSequenceAdapter;
import twaver.DataBoxSequenceListener;
import twaver.Element;
import twaver.Generator;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TView;
import twaver.TWaverUtil;
import twaver.VisibleFilter;
import twaver.base.A.F.D;
import twaver.combobox.TComboBoxRenderer;

public class TComboBox
extends JComboBox
implements TView {
    private TDataBox \u0552 = new TDataBox();
    private _A \u0549 = new _A();
    private List \u054b = new ArrayList();
    private Comparator \u054d = null;
    private Generator \u0561 = null;
    private Generator \u0547 = null;
    private Generator \u0555 = null;
    private TComboBoxRenderer \u0563 = null;
    private boolean \u0559 = TUIManager.getBoolean("combobox.icon.visible");
    private boolean \u0553 = false;
    private Element \u0556 = null;
    private int \u0545 = 0;
    private boolean \u0548 = TUIManager.getBoolean("combobox.lazy.publish.mode");
    private boolean \u054e = false;
    private boolean \u0550 = false;
    protected boolean locked = false;
    private boolean \u054a = false;
    private boolean \u0564 = TUIManager.getBoolean("combobox.popup.with.preferred.width");
    private Map \u054f = new HashMap();
    private Map \u0551 = new HashMap();
    private BatchListener \u0544 = new BatchAdapter(){

        public void batchEnded(BatchEvent e2) {
            TComboBox.this.publishData();
        }
    };
    private DataBoxSequenceListener \u0546 = new DataBoxSequenceAdapter(){

        public void hiberarchyChanged(Element element) {
            TComboBox.this.publishData();
        }
    };
    private DataBoxListener \u054c = new DataBoxListener(){

        public void elementAdded(DataBoxEvent e2) {
            TComboBox.this.publishData();
        }

        public void elementRemoved(DataBoxEvent e2) {
            TComboBox.this.publishData();
        }

        public void elementsCleared(DataBoxEvent e2) {
            TComboBox.this.publishData();
        }
    };
    private DataBoxSelectionListener \u0554 = new DataBoxSelectionListener(){

        public void selectionChanged(DataBoxSelectionEvent e2) {
            TComboBox.this.o();
        }
    };
    private PropertyChangeListener \u0562 = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName()) && TComboBox.this.\u054b.size() == 1 && TComboBox.this.\u054b.get(0) == D.C) {
                TComboBox.this.publishData();
            } else if (TComboBox.this.\u054d == null && TComboBox.this.\u054b.size() == 0) {
                Element element = (Element)evt.getSource();
                int row = TComboBox.this.getRowIndexByElement(element);
                TComboBox.this.\u0549.fireContentsChanged(element, row, row);
            } else {
                TComboBox.this.publishData();
            }
        }
    };

    public Element getElementByRowIndex(int rowIndex) {
        return (Element)this.\u054f.get(TWaverUtil.valueOf(rowIndex));
    }

    public int getRowIndexByElement(Element element) {
        Integer row = (Integer)this.\u0551.get(element);
        if (row == null) {
            return -1;
        }
        return row;
    }

    public void lock() {
        if (!this.locked) {
            this.locked = true;
            this.firePropertyChange("locked", false, true);
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void unlock() {
        if (this.locked) {
            this.locked = false;
            this.publishData();
            this.firePropertyChange("locked", true, false);
        }
    }

    public void cleanDirtyState() {
        if (this.\u054e) {
            this.\u0550 = true;
            this.publishData();
            this.\u0550 = false;
            this.\u054e = false;
        }
    }

    public TComboBox() {
        this(new TDataBox());
    }

    public TComboBox(TDataBox box) {
        this.\u054b.add(D.C);
        this.setDataBox(box);
        this.setModel(this.\u0549);
        this.\u0563 = new TComboBoxRenderer(this);
        this.setRenderer(this.\u0563);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                if (e2.getStateChange() == 1) {
                    TComboBox.this.p();
                }
            }
        });
        this.publishData();
    }

    public TDataBox getDataBox() {
        return this.\u0552;
    }

    public void setDataBox(TDataBox dataBox) {
        if (this.\u0552 == null) {
            throw new IllegalArgumentException("DataBox must be non null");
        }
        if (this.\u0552 != null) {
            this.q();
        }
        TDataBox oldValue = this.\u0552;
        this.\u0552 = dataBox;
        this.n();
        this.publishData();
        this.firePropertyChange("databox", oldValue, this.\u0552);
    }

    public void updateTViewUI() {
        this.publishData();
    }

    public void paint(Graphics g2) {
        this.cleanDirtyState();
        super.paint(g2);
    }

    public void publishData() {
        if (this.isLocked()) {
            return;
        }
        if (this.\u0552.isBatching()) {
            return;
        }
        if (!this.\u0550 && this.isLazyPublishMode()) {
            this.\u054e = true;
            this.repaint();
            return;
        }
        this.\u054f.clear();
        this.\u0551.clear();
        this.\u0545 = 0;
        if (this.\u054d == null) {
            Enumeration e2 = this.\u0552.breadthFirstEnumeration();
            while (e2.hasMoreElements()) {
                Element element = (Element)e2.nextElement();
                if (!this.isVisible(element)) continue;
                Integer row = TWaverUtil.valueOf(this.\u0545);
                this.\u054f.put(row, element);
                this.\u0551.put(element, row);
                ++this.\u0545;
            }
        } else {
            LinkedList<Element> publishElements = new LinkedList<Element>();
            Enumeration e3 = this.\u0552.breadthFirstEnumeration();
            while (e3.hasMoreElements()) {
                Element element = (Element)e3.nextElement();
                if (!this.isVisible(element)) continue;
                publishElements.add(element);
            }
            Collections.sort(publishElements, this.\u054d);
            this.\u0545 = publishElements.size();
            for (int i2 = 0; i2 < this.\u0545; ++i2) {
                Element element = (Element)publishElements.get(i2);
                Integer row = TWaverUtil.valueOf(i2);
                this.\u054f.put(row, element);
                this.\u0551.put(element, row);
            }
        }
        this.\u0549.fireContentsChanged(this, -1, -1);
        this.o();
    }

    private void n() {
        this.\u0552.addBatchListener(this.\u0544);
        this.\u0552.addDataBoxListener(this.\u054c);
        this.\u0552.addDataBoxSequenceListener(this.\u0546);
        this.\u0552.getSelectionModel().addDataBoxSelectionListener(this.\u0554);
        this.\u0552.addElementPropertyChangeListener(this.\u0562);
    }

    private void q() {
        this.\u0552.removeElementPropertyChangeListener(this.\u0562);
        this.\u0552.getSelectionModel().removeDataBoxSelectionListener(this.\u0554);
        this.\u0552.removeDataBoxSequenceListener(this.\u0546);
        this.\u0552.removeDataBoxListener(this.\u054c);
        this.\u0552.removeBatchListener(this.\u0544);
    }

    private void p() {
        if (this.\u0553) {
            return;
        }
        this.\u0553 = true;
        this.\u0556 = (Element)this.getSelectedItem();
        this.\u0552.getSelectionModel().setSelection(this.\u0556);
        this.\u0553 = false;
    }

    private void o() {
        if (this.\u0553) {
            return;
        }
        this.\u0553 = true;
        this.\u0556 = null;
        List selectedList = this.\u0552.getSelectionModel().getAllSelectedElement();
        int size = selectedList.size();
        for (int i2 = size - 1; i2 >= 0; --i2) {
            Element element = (Element)selectedList.get(i2);
            if (!this.\u0551.containsKey(element)) continue;
            this.\u0556 = element;
            break;
        }
        this.setSelectedItem(this.\u0556);
        this.\u0553 = false;
    }

    public boolean isVisible(Element element) {
        if (!this.\u0552.contains(element)) {
            return false;
        }
        Iterator it = this.\u054b.iterator();
        while (it.hasNext()) {
            VisibleFilter filter = (VisibleFilter)it.next();
            if (filter.isVisible(element)) continue;
            return false;
        }
        return true;
    }

    public void updateUI() {
        super.updateUI();
        TComboBoxRenderer renderer = this.getCellRenderer();
        if (renderer instanceof TComboBoxRenderer) {
            renderer.updateUI();
        }
    }

    public boolean isIconVisible() {
        return this.\u0559;
    }

    public void setIconVisible(boolean iconVisible) {
        this.\u0559 = iconVisible;
        this.updateUI();
    }

    public Generator getElementLabelGenerator() {
        return this.\u0561;
    }

    public void setElementLabelGenerator(Generator elementLabelGenerator) {
        this.\u0561 = elementLabelGenerator;
        this.repaint();
    }

    public Generator getElementToolTipTextGenerator() {
        return this.\u0547;
    }

    public void setElementToolTipTextGenerator(Generator elementToolTipTextGenerator) {
        this.\u0547 = elementToolTipTextGenerator;
        this.repaint();
    }

    public Generator getElementIconGenerator() {
        return this.\u0555;
    }

    public void setElementIconGenerator(Generator elementIconGenerator) {
        this.\u0555 = elementIconGenerator;
        this.repaint();
    }

    public TComboBoxRenderer getCellRenderer() {
        return this.\u0563;
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        if (cellRenderer instanceof TComboBoxRenderer) {
            this.\u0563 = (TComboBoxRenderer)cellRenderer;
        } else if (this.\u0563 != null) {
            throw new IllegalArgumentException("cellRenderer of TList should be an instance of TComBoxRender");
        }
        this.setRenderer(cellRenderer);
    }

    public boolean isLazyPublishMode() {
        return this.\u0548;
    }

    public void setLazyPublishMode(boolean lazyPublishMode) {
        this.\u0548 = lazyPublishMode;
    }

    public Comparator getSortComparator() {
        return this.\u054d;
    }

    public void setSortComparator(Comparator sortComparator) {
        this.\u054d = sortComparator;
        this.publishData();
    }

    public List getVisibleFilters() {
        return new ArrayList(this.\u054b);
    }

    public void removeVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null) {
            this.\u054b.remove(visibleFilter);
            this.publishData();
        }
    }

    public void addVisibleFilter(VisibleFilter visibleFilter) {
        if (visibleFilter != null && !this.\u054b.contains(visibleFilter)) {
            this.\u054b.add(visibleFilter);
            this.publishData();
        }
    }

    public boolean isCenterAlignment() {
        return this.\u0563.isCenterAlignment();
    }

    public void setCenterAlignment(boolean isCenterAlignment) {
        this.\u0563.setCenterAlignment(isCenterAlignment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        try {
            if (this.\u0564) {
                this.\u054a = true;
            }
            super.doLayout();
        }
        finally {
            this.\u054a = false;
        }
    }

    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.\u054a) {
            dim.width = Math.max(dim.width, this.getPreferredSize().width);
        }
        return dim;
    }

    public boolean isPopupPreferredSizeWidth() {
        return this.\u0564;
    }

    public void setPopupPreferredSizeWidth(boolean popupPreferredSizeWith) {
        this.\u0564 = popupPreferredSizeWith;
    }

    class _A
    extends AbstractListModel
    implements ComboBoxModel {
        _A() {
        }

        public Object getSelectedItem() {
            return TComboBox.this.\u0556;
        }

        public void setSelectedItem(Object item) {
            if (TComboBox.this.\u0556 != null && !TComboBox.this.\u0556.equals(item) || TComboBox.this.\u0556 == null && item != null) {
                TComboBox.this.\u0556 = (Element)item;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
        }

        public Object getElementAt(int index) {
            return TComboBox.this.getElementByRowIndex(index);
        }

        public int getSize() {
            return TComboBox.this.\u0545;
        }
    }
}

