/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;
import y.base.if;
import y.layout.AbstractLayoutStage;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;

public class ParallelEdgeLayouter
extends AbstractLayoutStage {
    protected EdgeList hiddenEdges = new EdgeList();
    public EdgeMap parallelEdges;
    protected double lineDistance = 10.0;

    public ParallelEdgeLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
    }

    public ParallelEdgeLayouter() {
    }

    public void setLineDistance(double d2) {
        this.lineDistance = d2;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        this.parallelEdges = layoutGraph.createEdgeMap();
        this.findAndHideParallelEdges(layoutGraph);
        this.doLayoutCore(layoutGraph);
        this.c(layoutGraph);
        this.layoutParallelEdges(layoutGraph, this.parallelEdges);
        layoutGraph.disposeEdgeMap(this.parallelEdges);
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (this.getCoreLayouter() == null) {
            return true;
        }
        this.parallelEdges = layoutGraph.createEdgeMap();
        this.findAndHideParallelEdges(layoutGraph);
        boolean bl = this.canLayoutCore(layoutGraph);
        this.c(layoutGraph);
        layoutGraph.disposeEdgeMap(this.parallelEdges);
        return bl;
    }

    protected void layoutParallelEdges(LayoutGraph layoutGraph, EdgeMap edgeMap) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edgeMap.get(edge) != null) {
                EdgeList edgeList = (EdgeList)edgeMap.get(edge);
                LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, this.lineDistance);
            }
            edgeCursor.next();
        }
    }

    protected void findAndHideParallelEdges(Graph graph) {
        NodeMap nodeMap = graph.createNodeMap();
        NodeCursor nodeCursor = graph.nodes();
        while (nodeCursor.ok()) {
            if if_;
            if if_2;
            Object object;
            Node node = nodeCursor.node();
            EdgeCursor edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                if_2 = ((Edge)object).opposite(node);
                if_ = (Edge)nodeMap.get(if_2);
                if (if_ != object) {
                    if (if_ == null) {
                        nodeMap.set(if_2, object);
                    } else {
                        if (this.parallelEdges.get(if_) == null) {
                            this.parallelEdges.set(if_, new EdgeList());
                        }
                        EdgeList edgeList = (EdgeList)this.parallelEdges.get(if_);
                        edgeList.add(object);
                        this.hiddenEdges.push(object);
                        graph.hide((Edge)object);
                    }
                }
                edgeCursor.next();
            }
            object = node.edges();
            while (object.ok()) {
                if_2 = object.edge();
                if_ = ((Edge)if_2).opposite(node);
                nodeMap.set(if_, null);
                object.next();
            }
            nodeCursor.next();
        }
        graph.disposeNodeMap(nodeMap);
    }

    private void c(Graph graph) {
        while (!this.hiddenEdges.isEmpty()) {
            graph.unhide(this.hiddenEdges.popEdge());
        }
    }
}

