/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.geom.YRectangle;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelModel;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.Layouter;

public class LabelLayoutTranslator
implements LayoutStage {
    private Layouter ck;
    private DataProvider cj;
    private EdgeMap ci;

    public void setCoreLayouter(Layouter layouter) {
        this.ck = layouter;
    }

    public Layouter getCoreLayouter() {
        return this.ck;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        if (this.ck != null) {
            this.r(layoutGraph);
            this.ck.doLayout(layoutGraph);
            this.q(layoutGraph);
            this.p(layoutGraph);
        }
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.ck != null ? this.ck.canLayout(layoutGraph) : false;
    }

    private boolean j() {
        return this.cj != null;
    }

    private void r(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider == null) {
            this.ci = layoutGraph.createEdgeMap();
            layoutGraph.addDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY, this.ci);
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                EdgeLabelLayout[] edgeLabelLayoutArray = layoutGraph.getEdgeLabelLayout(edge);
                LabelLayoutData[] labelLayoutDataArray = new LabelLayoutData[edgeLabelLayoutArray.length];
                int n = 0;
                while (n < edgeLabelLayoutArray.length) {
                    YRectangle yRectangle = edgeLabelLayoutArray[n].getBox();
                    labelLayoutDataArray[n] = new LabelLayoutData(yRectangle.getWidth(), yRectangle.getHeight(), edgeLabelLayoutArray[n].getPreferredPlacement());
                    ++n;
                }
                this.ci.set(edge, labelLayoutDataArray);
                edgeCursor.next();
            }
        }
    }

    private void p(LayoutGraph layoutGraph) {
        if (this.ci != null) {
            layoutGraph.removeDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
            layoutGraph.disposeEdgeMap(this.ci);
            this.ci = null;
        }
    }

    private void q(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edge);
            EdgeLabelLayout[] edgeLabelLayoutArray = layoutGraph.getEdgeLabelLayout(edge);
            if (labelLayoutDataArray != null && edgeLabelLayoutArray != null && labelLayoutDataArray.length == edgeLabelLayoutArray.length) {
                int n = 0;
                while (n < edgeLabelLayoutArray.length) {
                    this.a(layoutGraph, edge, edgeLabelLayoutArray[n], labelLayoutDataArray[n]);
                    ++n;
                }
            }
            edgeCursor.next();
        }
    }

    private void a(LayoutGraph layoutGraph, Edge edge, EdgeLabelLayout edgeLabelLayout, LabelLayoutData labelLayoutData) {
        EdgeLabelModel edgeLabelModel = edgeLabelLayout.getLabelModel();
        edgeLabelLayout.setModelParameter(edgeLabelModel.createModelParameter(labelLayoutData.getBounds(), layoutGraph.getEdgeLayout(edge), layoutGraph.getNodeLayout(edge.source()), layoutGraph.getNodeLayout(edge.target())));
    }
}

