/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.tree.xml;

import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.tree.lazyloader.JLazyLoaderTreeNode;
import com.nepxion.swing.tree.xml.Dom4JBasicTreeParser;
import com.nepxion.util.xml.dom4j.Dom4JReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class Dom4JLazyLoaderTreeParser
extends Dom4JBasicTreeParser {
    private String leafTag;

    public Dom4JLazyLoaderTreeParser() {
        this(1);
    }

    public Dom4JLazyLoaderTreeParser(String iconExtensionName) {
        this(1, iconExtensionName);
    }

    public Dom4JLazyLoaderTreeParser(int iconFolderMode) {
        this(iconFolderMode, null);
    }

    public Dom4JLazyLoaderTreeParser(int iconFolderMode, String iconExtensionName) {
        this("index", "name", "text", "icon", "tooltip", "class", "leaf", iconFolderMode, iconExtensionName);
    }

    public Dom4JLazyLoaderTreeParser(String indexTag, String nameTag, String textTag, String iconTag, String toolTipTextTag, String classTag, String leafTag, int iconFolderMode, String iconExtensionName) {
        super(indexTag, nameTag, textTag, iconTag, toolTipTextTag, classTag, iconFolderMode, iconExtensionName);
        this.leafTag = leafTag;
    }

    public void parse(String text, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException {
        Document document = Dom4JReader.getDocument((String)text);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parseFormat(String text, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((String)text);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parse(File file, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getDocument((File)file);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parseFormat(File file, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((File)file);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parse(InputStream inputStream, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException, IOException {
        Document document = Dom4JReader.getDocument((InputStream)inputStream);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parseFormat(InputStream inputStream, JLazyLoaderTreeNode lazyLoaderTreeNode) throws DocumentException, IOException, UnsupportedEncodingException {
        Document document = Dom4JReader.getFormatDocument((InputStream)inputStream);
        this.parse(document, lazyLoaderTreeNode);
    }

    public void parse(Document document, JLazyLoaderTreeNode lazyLoaderTreeNode) {
        Element rootElement = document.getRootElement();
        this.parseElement(rootElement, lazyLoaderTreeNode);
    }

    public void parseElement(Element element, JLazyLoaderTreeNode lazyLoaderTreeNode) {
        Iterator elementIterator = element.elementIterator();
        while (elementIterator.hasNext()) {
            Object childElementObject = elementIterator.next();
            if (!(childElementObject instanceof Element)) continue;
            Element childElement = (Element)childElementObject;
            JLazyLoaderTreeNode childLazyLoaderTreeNode = new JLazyLoaderTreeNode();
            lazyLoaderTreeNode.add(childLazyLoaderTreeNode);
            this.parseAttribute(childElement, childLazyLoaderTreeNode);
        }
    }

    public void parseAttribute(Element element, JLazyLoaderTreeNode lazyLoaderTreeNode) {
        HashMap<String, String> userObject = null;
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String attributeName = attribute.getName().trim();
            String attributeText = attribute.getText().trim();
            if (attributeName.equals(this.indexTag)) {
                lazyLoaderTreeNode.setIndex(Integer.parseInt(attributeText));
                continue;
            }
            if (attributeName.equals(this.textTag)) {
                lazyLoaderTreeNode.setText(attributeText);
                continue;
            }
            if (attributeName.equals(this.iconTag)) {
                String iconName = attributeText + (this.iconExtensionName != null ? this.iconExtensionName : "");
                switch (this.iconFolderMode) {
                    case 0: {
                        lazyLoaderTreeNode.setIcon(IconFactory.getSwingIcon(iconName));
                        break;
                    }
                    case 1: {
                        lazyLoaderTreeNode.setIcon(IconFactory.getContextIcon(iconName));
                        break;
                    }
                    case 2: {
                        lazyLoaderTreeNode.setIcon(IconFactory.getIcon(iconName));
                        break;
                    }
                    default: {
                        lazyLoaderTreeNode.setIcon(IconFactory.getContextIcon(iconName));
                        break;
                    }
                }
                continue;
            }
            if (attributeName.equals(this.toolTipTextTag)) {
                lazyLoaderTreeNode.setToolTipText(attributeText);
                continue;
            }
            if (attributeName.equals(this.classTag)) {
                if (userObject == null) {
                    userObject = new HashMap<String, String>();
                    lazyLoaderTreeNode.setUserObject(userObject);
                }
                Object instance = null;
                try {
                    instance = Class.forName(attributeText).newInstance();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                userObject.put(this.classTag, (String)instance);
                continue;
            }
            if (attributeName.equals(this.leafTag)) {
                boolean isLeaf = Boolean.valueOf(attributeText);
                lazyLoaderTreeNode.setLoaded(isLeaf);
                lazyLoaderTreeNode.setLeaf(isLeaf);
                continue;
            }
            if (userObject == null) {
                userObject = new HashMap();
                lazyLoaderTreeNode.setUserObject(userObject);
            }
            userObject.put(attributeName, attributeText);
        }
    }
}

