/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.table.columnconfig;

import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.selector.checkbox.JCheckBoxListPanel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JColumnConfigListPanel
extends JCheckBoxListPanel {
    private JTable table;

    public JColumnConfigListPanel(JTable table) {
        this.table = table;
        this.retrieveList();
        this.setPreferredSize(new Dimension(300, 300));
    }

    public void updateListFacade() {
        List allElementNodes = this.getAllElementNodes();
        for (ElementNode elementNode : allElementNodes) {
            TableColumn tableColumn = (TableColumn)elementNode.getUserObject();
            boolean retrieveColumn = this.retrieveColumn(tableColumn);
            elementNode.setSelected(retrieveColumn);
        }
        this.updateSelection();
    }

    public void updateTableFacade() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumns.add(tableColumn);
        }
        for (TableColumn tableColumn : tableColumns) {
            this.table.removeColumn(tableColumn);
        }
        List selectedElementNodes = this.getSelectedElementNodes();
        for (ElementNode elementNode : selectedElementNodes) {
            TableColumn tableColumn = (TableColumn)elementNode.getUserObject();
            this.table.addColumn(tableColumn);
        }
    }

    public void retrieveList() {
        ArrayList<ElementNode> allElementNodes = new ArrayList<ElementNode>();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Object identifier = tableColumn.getIdentifier();
            ElementNode elementNode = new ElementNode(identifier.toString(), (Icon)IconFactory.getSwingIcon("element.png"), identifier.toString(), tableColumn, true);
            allElementNodes.add(elementNode);
        }
        this.setAllElementNodes(allElementNodes);
    }

    private boolean retrieveColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return true;
        }
        return false;
    }
}

