/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.file;

import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.file.JBasicFileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class JFileSelector {
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private JBasicFileChooser fileChooser;
    private String title;

    public JFileSelector(Component parentComponent, String title) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent);
        this.initComponents();
    }

    public JFileSelector(Component parentComponent, String title, String currentDirectoryPath) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent, currentDirectoryPath);
        this.initComponents();
    }

    public JFileSelector(Component parentComponent, String title, File currentDirectory) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent, currentDirectory);
        this.initComponents();
    }

    public JFileSelector(Component parentComponent, String title, FileSystemView fsv) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent, fsv);
        this.initComponents();
    }

    public JFileSelector(Component parentComponent, String title, File currentDirectory, FileSystemView fsv) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent, currentDirectory, fsv);
        this.initComponents();
    }

    public JFileSelector(Component parentComponent, String title, String currentDirectoryPath, FileSystemView fsv) {
        this.title = title;
        this.fileChooser = new JBasicFileChooser(parentComponent, currentDirectoryPath, fsv);
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser.setPreferredSize(new Dimension(500, 325));
        this.fileChooser.setDialogTitle(this.title);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.fileChooser.addChoosableFileFilter(fileFilter);
    }

    public FileFilter getFileFilter() {
        return this.fileChooser.getFileFilter();
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileChooser.setFileFilter(fileFilter);
    }

    public String getFileSuffix() {
        return this.fileChooser.getFileSuffix();
    }

    public JBasicFileChooser getChooser() {
        return this.fileChooser;
    }

    public String saveFile(String fileName) {
        this.fileChooser.setFileSelectionMode(0);
        if (fileName != null) {
            String fileSuffix = this.getFileSuffix();
            if (fileSuffix != null) {
                fileName = fileName + "." + fileSuffix;
            }
            this.fileChooser.setSelectedFile(new File(fileName));
        }
        int returnValue = this.fileChooser.showSaveDialog(this.fileChooser.getParentComponent());
        String selectedFilePath = null;
        if (returnValue == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (file.isFile() && file.exists()) {
                int selectedValue = JBasicOptionPane.showConfirmDialog(this.fileChooser.getParentComponent(), SwingLocale.getString("file_overwrite"), SwingLocale.getString("information"), 1);
                if (selectedValue == 0) {
                    selectedFilePath = this.fileChooser.getSelectedFile().getAbsolutePath();
                } else if (selectedValue == 2) {
                    selectedFilePath = this.saveFile(this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            } else {
                selectedFilePath = this.fileChooser.getSelectedFile().getAbsolutePath();
            }
        }
        return selectedFilePath;
    }

    public File openFile() {
        File file;
        this.fileChooser.setFileSelectionMode(0);
        File selectedFile = null;
        int returnValue = this.fileChooser.showOpenDialog(this.fileChooser.getParentComponent());
        if (returnValue == 0 && (file = this.fileChooser.getSelectedFile()).exists() && this.fileChooser.getFileFilter() != null) {
            if (this.fileChooser.getFileFilter().accept(file)) {
                selectedFile = file;
            } else {
                JBasicOptionPane.showMessageDialog(this.fileChooser.getParentComponent(), SwingLocale.getString("file_error_format"), SwingLocale.getString("warning"), 2);
                selectedFile = this.openFile();
            }
        }
        return selectedFile;
    }

    public File openDirectory() {
        this.fileChooser.setFileSelectionMode(1);
        File selectedFile = null;
        int returnValue = this.fileChooser.showOpenDialog(this.fileChooser.getParentComponent());
        if (returnValue == 0) {
            selectedFile = this.fileChooser.getSelectedFile();
        }
        return selectedFile;
    }
}

