/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.chart.line;

import com.nepxion.swing.locale.SwingLocale;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class LineChartFactory {
    public static XYPlot createTimeXYPlot(String title, String legendToolTipText, boolean isShapesVisible) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)title));
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        NumberAxis numberAxis = new NumberAxis(title);
        XYLineAndShapeRenderer xyLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYPlot xyPlot = new XYPlot((XYDataset)timeSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)xyLineAndShapeRenderer);
        LineChartFactory.setXYPlotPreference(xyPlot, legendToolTipText, isShapesVisible);
        return xyPlot;
    }

    public static CombinedDomainXYPlot createCombinedDomainXYPlot(String title) {
        DateAxis dateAxis = new DateAxis(title);
        CombinedDomainXYPlot combinedDomainXYPlot = new CombinedDomainXYPlot((ValueAxis)dateAxis);
        return combinedDomainXYPlot;
    }

    public static void setXYPlotPreference(XYPlot xyPlot, String legendToolTipText, boolean isShapesVisible) {
        xyPlot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.gray, 0.0f, 0.0f, new Color(251, 251, 251), true));
        xyPlot.setDomainGridlinePaint((Paint)Color.white);
        xyPlot.setRangeGridlinePaint((Paint)Color.white);
        xyPlot.setAxisOffset(new RectangleInsets(0.0, 0.0, 5.0, 0.0));
        NumberAxis numberAxis = (NumberAxis)xyPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(true);
        XYLineAndShapeRenderer xyLineAndShapeRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        xyLineAndShapeRenderer.setBaseShapesVisible(isShapesVisible);
        xyLineAndShapeRenderer.setSeriesFillPaint(0, (Paint)Color.white);
        xyLineAndShapeRenderer.setUseFillPaint(true);
        xyLineAndShapeRenderer.setLegendItemToolTipGenerator((XYSeriesLabelGenerator)new StandardXYSeriesLabelGenerator(legendToolTipText + " - {0}"));
        xyLineAndShapeRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0} : " + SwingLocale.getString("time") + " [{1}], " + SwingLocale.getString("value") + " [{2}]", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
    }
}

