/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.border;

import com.nepxion.swing.border.HoverBorder;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class HoverBorderDecoration
extends MouseAdapter {
    private Color hoverBackground;
    private Color background;
    private Color hoverBorderColor;
    private Color borderColor;
    private Border hoverBorder;
    private Border border;
    private JComponent component;

    public HoverBorderDecoration(JComponent component) {
        this.component = component;
        this.background = component.getBackground();
        this.hoverBackground = new Color(255, 255, 225);
        this.borderColor = new Color(125, 125, 125, 100);
        this.hoverBorderColor = new Color(215, 215, 215, 255);
        this.border = BorderFactory.createCompoundBorder(new LineBorder(this.borderColor, 1), new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.hoverBorder = new HoverBorder(this.hoverBorderColor, 3);
        component.setBorder(this.border);
        component.setBackground(this.background);
        component.addMouseListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.component.setBorder(this.hoverBorder);
        this.component.setBackground(this.hoverBackground);
        this.component.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.component.setBorder(this.border);
        this.component.setBackground(this.background);
        this.component.repaint();
    }
}

