/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.selector.checkbox;

import com.nepxion.swing.button.ButtonFocusListener;
import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.dialog.JBasicDialog;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.list.JBasicList;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.selector.checkbox.JCheckBoxListPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class JCheckBoxSelector
extends JBasicDialog {
    private JCheckBoxListPanel checkBoxListPanel;
    private List allElementNodes;
    private boolean isConfirmed;

    public JCheckBoxSelector(Frame owner, String title) {
        this(owner, title, new Dimension(350, 320));
    }

    public JCheckBoxSelector(Dialog owner, String title) {
        this(owner, title, new Dimension(350, 320));
    }

    public JCheckBoxSelector(Frame owner, String title, Dimension dimension) {
        this(owner, title, dimension, null);
    }

    public JCheckBoxSelector(Dialog owner, String title, Dimension dimension) {
        this(owner, title, dimension, null);
    }

    public JCheckBoxSelector(Frame owner, String title, List allElementNodes) {
        this(owner, title, new Dimension(350, 320), allElementNodes);
    }

    public JCheckBoxSelector(Dialog owner, String title, List allElementNodes) {
        this(owner, title, new Dimension(350, 320), allElementNodes);
    }

    public JCheckBoxSelector(Frame owner, String title, Dimension dimension, List allElementNodes) {
        super(owner, title, dimension, true, false, true);
        this.allElementNodes = allElementNodes;
        this.initComponents();
    }

    public JCheckBoxSelector(Dialog owner, String title, Dimension dimension, List allElementNodes) {
        super(owner, title, dimension, true, false, true);
        this.allElementNodes = allElementNodes;
        this.initComponents();
    }

    private void initComponents() {
        this.checkBoxListPanel = new JCheckBoxListPanel(this.allElementNodes);
        JClassicButton selectAllButton = new JClassicButton(SwingLocale.getString("select_all"), IconFactory.getSwingIcon("stereo/redo_16.png"), SwingLocale.getString("select_all"));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelector.this.checkBoxListPanel.adaptListFacade((byte)0);
            }
        });
        JClassicButton selectReverseButton = new JClassicButton(SwingLocale.getString("select_reverse"), IconFactory.getSwingIcon("stereo/undo_16.png"), SwingLocale.getString("select_reverse"));
        selectReverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelector.this.checkBoxListPanel.adaptListFacade((byte)2);
            }
        });
        JClassicButton confirmButton = new JClassicButton(SwingLocale.getString("yes"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("yes"));
        ActionListener confirmActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedElementNodes = JCheckBoxSelector.this.checkBoxListPanel.getSelectedElementNodes();
                if (selectedElementNodes == null || selectedElementNodes.size() == 0) {
                    JBasicOptionPane.showMessageDialog(HandleManager.getFrame(JCheckBoxSelector.this), SwingLocale.getString("select_not_null"), SwingLocale.getString("warning"), 2);
                    return;
                }
                JCheckBoxSelector.this.setVisible(false);
                JCheckBoxSelector.this.isConfirmed = true;
            }
        };
        confirmButton.addFocusListener(new ButtonFocusListener(this));
        confirmButton.addActionListener(confirmActionListener);
        KeyStrokeManager.registerButtonToEnterKey(confirmButton, confirmActionListener);
        JClassicButton cancelButton = new JClassicButton(SwingLocale.getString("no"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("no"));
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxSelector.this.setVisible(false);
                JCheckBoxSelector.this.isConfirmed = false;
            }
        };
        cancelButton.addFocusListener(new ButtonFocusListener(this));
        cancelButton.addActionListener(cancelActionListener);
        KeyStrokeManager.registerButtonToEscapeKey(cancelButton, cancelActionListener);
        double[][] size = new double[][]{{-2.0, 5.0, -2.0, -1.0, -2.0, 5.0, -2.0}, {-1.0, 5.0, 30.0}};
        JPanel panel = new JPanel();
        panel.setLayout(new TableLayout(size));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.checkBoxListPanel, "0, 0, 6, 0");
        panel.add((Component)selectAllButton, "0, 2");
        panel.add((Component)selectReverseButton, "2, 2");
        panel.add((Component)confirmButton, "4, 2");
        panel.add((Component)cancelButton, "6, 2");
        Container container = this.getContentPane();
        container.add(panel);
    }

    public JCheckBoxListPanel getCheckBoxListPanel() {
        return this.checkBoxListPanel;
    }

    public JBasicList getCheckBoxList() {
        return this.checkBoxListPanel.getList();
    }

    public List getSelectedElementNodes() {
        return this.checkBoxListPanel.getSelectedElementNodes();
    }

    public List getSelectedUserObjects() {
        return this.checkBoxListPanel.getSelectedUserObjects();
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }
}

