/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.PlaneObject;
import y.geom.YDimension;
import y.geom.YPoint;

public class YRectangle
extends YDimension
implements PlaneObject {
    public final double x;
    public final double y;
    private YPoint q;

    public YRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public YRectangle(YPoint yPoint, YDimension yDimension) {
        this(yPoint.x, yPoint.y, yDimension.width, yDimension.height);
        this.q = yPoint;
    }

    public YRectangle(double d2, double d3, double d4, double d5) {
        super(d4, d5);
        this.x = d2;
        this.y = d3;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final YPoint getLocation() {
        if (this.q == null) {
            this.q = new YPoint(this.x, this.y);
        }
        return this.q;
    }

    public YRectangle getBoundingBox() {
        return this;
    }

    public boolean contains(double d2, double d3) {
        return d2 >= this.x && d2 - this.x < this.width && d3 >= this.y && d3 - this.y < this.height;
    }

    public boolean contains(YPoint yPoint) {
        return this.contains(yPoint.x, yPoint.y);
    }

    public static boolean intersects(YRectangle yRectangle, YRectangle yRectangle2) {
        return yRectangle.x + yRectangle.width > yRectangle2.x && yRectangle.y + yRectangle.height > yRectangle2.y && yRectangle.x < yRectangle2.x + yRectangle2.width && yRectangle.y < yRectangle2.y + yRectangle2.height;
    }

    public String toString() {
        return "[" + this.x + ',' + this.y + ',' + this.width + ',' + this.height + ']';
    }

    public int hashCode() {
        long l = Double.doubleToRawLongBits(this.x) >> 1 ^ Double.doubleToRawLongBits(this.y);
        return super.hashCode() << 1 ^ (int)(l ^ l >> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YRectangle)) {
            return false;
        }
        YRectangle yRectangle = (YRectangle)object;
        return yRectangle.x == this.x && yRectangle.y == this.y && yRectangle.width == this.width && yRectangle.height == this.height;
    }

    public int compareTo(Object object) {
        YRectangle yRectangle = (YRectangle)object;
        if (this.x < yRectangle.x) {
            return -1;
        }
        if (this.x > yRectangle.x) {
            return 1;
        }
        if (this.y < yRectangle.y) {
            return -1;
        }
        if (this.y > yRectangle.y) {
            return 1;
        }
        return super.compareTo(object);
    }
}

