/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import java.util.Enumeration;
import java.util.Vector;
import y.geom.AffineLine;
import y.geom.Angle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YVector;

public class YCircle
implements Comparable {
    public final YPoint center;
    public final double radius;

    public YCircle(double d2) {
        this.center = YPoint.ORIGIN;
        this.radius = d2;
    }

    public YCircle(YPoint yPoint, YPoint yPoint2, double d2) {
        YVector yVector = new YVector(yPoint2, yPoint);
        yVector.scale(0.5);
        YPoint yPoint3 = YVector.add(yPoint, yVector);
        YVector yVector2 = YVector.orthoNormal(yVector);
        double d3 = yVector.length();
        double d4 = Math.sqrt(d2 * d2 - d3 * d3);
        yVector2.scale(d4);
        this.center = YVector.add(yPoint3, yVector2);
        this.radius = d2;
    }

    public YCircle(YPoint yPoint, YPoint yPoint2, YPoint yPoint3) {
        double d2 = yPoint.getX();
        double d3 = yPoint.getY();
        double d4 = yPoint2.getX();
        double d5 = yPoint2.getY();
        double d6 = yPoint3.getX();
        double d7 = yPoint3.getY();
        double d8 = (d2 * d2 + d3 * d3) * (d5 - d7) + (d4 * d4 + d5 * d5) * (d7 - d3) + (d6 * d6 + d7 * d7) * (d3 - d5);
        double d9 = -(d2 * d2 + d3 * d3) * (d4 - d6) - (d4 * d4 + d5 * d5) * (d6 - d2) - (d6 * d6 + d7 * d7) * (d2 - d4);
        double d10 = 2.0 * ((d4 - d2) * (d7 - d3) - (d6 - d2) * (d5 - d3));
        if (d10 == 0.0) {
            throw new IllegalArgumentException("Points are collinear");
        }
        this.center = new YPoint(d8 / d10, d9 / d10);
        this.radius = YPoint.distance(this.center, yPoint);
    }

    public YCircle(YPoint yPoint, double d2) {
        this.center = yPoint;
        this.radius = d2;
    }

    public YPoint getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public YPoint[] getXCut(double d2) {
        YPoint[] yPointArray;
        double d3;
        double d4 = -2.0 * this.center.getX();
        double d5 = d4 * d4 / 4.0 - (d3 = this.center.getX() * this.center.getX() + d2 * d2 - 2.0 * this.center.getY() * d2 + this.center.getY() * this.center.getY() - this.radius * this.radius);
        if (d5 < 0.0) {
            return null;
        }
        if (d5 == 0.0) {
            yPointArray = new YPoint[]{new YPoint(-d4 / 2.0, d2)};
        } else {
            yPointArray = new YPoint[2];
            d5 = Math.sqrt(d5);
            yPointArray[0] = new YPoint(-d4 / 2.0 - d5, d2);
            yPointArray[1] = new YPoint(-d4 / 2.0 + d5, d2);
        }
        return yPointArray;
    }

    public YPoint[] getYCut(double d2) {
        YPoint[] yPointArray;
        double d3;
        double d4 = -2.0 * this.center.getY();
        double d5 = d4 * d4 / 4.0 - (d3 = this.center.getY() * this.center.getY() + d2 * d2 - 2.0 * this.center.getX() * d2 + this.center.getX() * this.center.getX() - this.radius * this.radius);
        if (d5 < 0.0) {
            return null;
        }
        if (d5 == 0.0) {
            yPointArray = new YPoint[]{new YPoint(d2, -d4 / 2.0)};
        } else {
            yPointArray = new YPoint[2];
            d5 = Math.sqrt(d5);
            yPointArray[0] = new YPoint(d2, -d4 / 2.0 - d5);
            yPointArray[1] = new YPoint(d2, -d4 / 2.0 + d5);
        }
        return yPointArray;
    }

    public YPoint[] getCut(AffineLine affineLine) {
        YPoint[] yPointArray;
        double d2 = affineLine.getA();
        double d3 = affineLine.getB();
        double d4 = affineLine.getC();
        double d5 = this.center.getX();
        double d6 = this.center.getY();
        if (affineLine.getA() == 0.0) {
            YPoint[] yPointArray2;
            double d7 = -d4 / d3;
            double d8 = -2.0 * d5;
            double d9 = (d4 / d3 + d6) * (d4 / d3 + d6) - this.radius * this.radius + d5 * d5;
            double d10 = d8 * d8 / 4.0 - d9;
            if (d10 < 0.0) {
                return null;
            }
            if (d10 == 0.0) {
                yPointArray2 = new YPoint[1];
                double d11 = -d8 / 2.0;
                yPointArray2[0] = new YPoint(d11, d7);
            } else {
                yPointArray2 = new YPoint[2];
                d10 = Math.sqrt(d10);
                double d12 = -d8 / 2.0 - d10;
                yPointArray2[0] = new YPoint(d12, d7);
                d12 = -d8 / 2.0 + d10;
                yPointArray2[1] = new YPoint(d12, d7);
            }
            return yPointArray2;
        }
        double d13 = ((2.0 * d3 * d4 + 2.0 * d3 * d2 * d5) / (d2 * d2) - 2.0 * d6) / (1.0 + d3 * d3 / (d2 * d2));
        double d14 = (d4 * d4 / (d2 * d2) + 2.0 * d4 * d5 / d2 + d5 * d5 + d6 * d6 - this.radius * this.radius) / (1.0 + d3 * d3 / (d2 * d2));
        double d15 = d13 * d13 / 4.0 - d14;
        if (d15 < 0.0) {
            return null;
        }
        if (d15 == 0.0) {
            yPointArray = new YPoint[1];
            double d16 = -d13 / 2.0;
            double d17 = (-d3 * d16 - d4) / d2;
            yPointArray[0] = new YPoint(d17, d16);
        } else {
            yPointArray = new YPoint[2];
            d15 = Math.sqrt(d15);
            double d18 = -d13 / 2.0 - d15;
            double d19 = (-d3 * d18 - d4) / d2;
            yPointArray[0] = new YPoint(d19, d18);
            d18 = -d13 / 2.0 + d15;
            d19 = (-d3 * d18 - d4) / d2;
            yPointArray[1] = new YPoint(d19, d18);
        }
        return yPointArray;
    }

    public YPoint[] getRectCut(YPoint yPoint, YDimension yDimension) {
        YPoint yPoint2;
        YPoint[] yPointArray;
        Object object;
        YPoint[] yPointArray2;
        YPoint[] yPointArray3 = null;
        Vector<Object> vector = new Vector<Object>(2);
        Vector<YPoint> vector2 = new Vector<YPoint>(4);
        YPoint[] yPointArray4 = this.getXCut(yPoint.getY());
        if (yPointArray4 != null) {
            int n = 0;
            while (n < yPointArray4.length) {
                vector2.addElement(yPointArray4[n]);
                ++n;
            }
        }
        if ((yPointArray2 = this.getXCut(yPoint.getY() + yDimension.getHeight())) != null) {
            int n = 0;
            while (n < yPointArray2.length) {
                vector2.addElement(yPointArray2[n]);
                ++n;
            }
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object = (YPoint)enumeration.nextElement();
            if (!(((YPoint)object).getX() >= yPoint.getX()) || !(((YPoint)object).getX() <= yPoint.getX() + yDimension.getWidth())) continue;
            vector.addElement(object);
        }
        object = new Vector(4);
        YPoint[] yPointArray5 = this.getYCut(yPoint.getX());
        if (yPointArray5 != null) {
            int n = 0;
            while (n < yPointArray5.length) {
                ((Vector)object).addElement(yPointArray5[n]);
                ++n;
            }
        }
        if ((yPointArray = this.getYCut(yPoint.getX() + yDimension.getWidth())) != null) {
            int n = 0;
            while (n < yPointArray.length) {
                ((Vector)object).addElement(yPointArray[n]);
                ++n;
            }
        }
        Enumeration enumeration2 = ((Vector)object).elements();
        while (enumeration2.hasMoreElements()) {
            yPoint2 = (YPoint)enumeration2.nextElement();
            if (!(yPoint2.getY() >= yPoint.getY()) || !(yPoint2.getY() <= yPoint.getY() + yDimension.getHeight())) continue;
            vector.addElement(yPoint2);
        }
        if (vector.size() == 0) {
            return null;
        }
        yPointArray3 = new YPoint[((Vector)object).size()];
        if (vector.size() == 2) {
            yPoint2 = (YPoint)((Vector)object).elementAt(0);
            YPoint yPoint3 = (YPoint)((Vector)object).elementAt(1);
            YVector yVector = new YVector(1.0, 0.0);
            YVector yVector2 = new YVector(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0);
            YVector yVector3 = new YVector(yPoint2.getX(), yPoint2.getY());
            YVector yVector4 = new YVector(yPoint3.getX(), yPoint3.getY());
            double d2 = YVector.angle(yVector, yVector2);
            double d3 = YVector.angle(yVector, yVector3);
            double d4 = YVector.angle(yVector, yVector4);
            if (Angle.addAngle(d3, -d2) < Angle.addAngle(d4, -d2)) {
                yPointArray3[0] = yPoint2;
                yPointArray3[1] = yPoint3;
            } else {
                yPointArray3[0] = yPoint3;
                yPointArray3[1] = yPoint2;
            }
        } else {
            int n = 0;
            while (n < vector.size()) {
                yPointArray3[n] = (YPoint)vector.elementAt(n);
                ++n;
            }
        }
        return yPointArray3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YCircle)) {
            return false;
        }
        YCircle yCircle = (YCircle)object;
        return yCircle.radius == this.radius && yCircle.center.equals(this.center);
    }

    public int hashCode() {
        return this.center.hashCode() ^ (int)Double.doubleToRawLongBits(this.radius);
    }

    public int compareTo(Object object) {
        YCircle yCircle = (YCircle)object;
        if (this.center.x < yCircle.center.x) {
            return -1;
        }
        if (this.center.x > yCircle.center.x) {
            return 1;
        }
        if (this.center.y < yCircle.center.y) {
            return -1;
        }
        if (this.center.y > yCircle.center.y) {
            return 1;
        }
        if (this.radius > yCircle.radius) {
            return 1;
        }
        if (this.radius < yCircle.radius) {
            return -1;
        }
        return 0;
    }
}

