/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.timer;

import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.keystroke.KeyStrokeManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.timer.JTimerLabel;
import com.nepxion.swing.timer.JTimerProgressBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class JTimerProgressPanel
extends JPanel {
    private JLabel animationLabel;
    private JTimerProgressBar timerProgressBar;
    private JLabel informationLabel;
    private JClassicButton hideButton;
    private JClassicButton cancelButton;
    private String information;

    public JTimerProgressPanel(JLabel animationLabel, String information) {
        this.animationLabel = animationLabel;
        this.information = information;
        this.initComponents();
    }

    private void initComponents() {
        LabelPanel labelPanel = new LabelPanel();
        ProgressPanel progressPanel = new ProgressPanel();
        ButtonPanel buttonPanel = new ButtonPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)labelPanel, "North");
        this.add((Component)progressPanel, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public void reset() {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerAnimationLabel = (JTimerLabel)this.animationLabel;
            timerAnimationLabel.reset();
        }
        this.timerProgressBar.reset();
    }

    public void start() {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerAnimationLabel = (JTimerLabel)this.animationLabel;
            timerAnimationLabel.restart();
        }
        this.timerProgressBar.start();
    }

    public void start(int delayTime) {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerAnimationLabel = (JTimerLabel)this.animationLabel;
            timerAnimationLabel.restart();
        }
        this.timerProgressBar.start(delayTime);
    }

    public void restart() {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerAnimationLabel = (JTimerLabel)this.animationLabel;
            timerAnimationLabel.restart();
        }
        this.timerProgressBar.restart();
    }

    public void restart(int delayTime) {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerAnimationLabel = (JTimerLabel)this.animationLabel;
            timerAnimationLabel.restart();
        }
        this.timerProgressBar.restart(delayTime);
    }

    public void stop() {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerLabel = (JTimerLabel)this.animationLabel;
            timerLabel.stop();
        }
        this.timerProgressBar.stop();
    }

    public void finish() {
        if (this.animationLabel instanceof JTimerLabel) {
            JTimerLabel timerLabel = (JTimerLabel)this.animationLabel;
            timerLabel.finish();
        }
        this.timerProgressBar.finish();
    }

    public JLabel getAnimationLabel() {
        return this.animationLabel;
    }

    public JTimerProgressBar getTimerProgressBar() {
        return this.timerProgressBar;
    }

    public JLabel getInformationLabel() {
        return this.informationLabel;
    }

    public JClassicButton getHideButton() {
        return this.hideButton;
    }

    public JClassicButton getCancelButton() {
        return this.cancelButton;
    }

    protected abstract void fireHidden();

    protected abstract void fireCancelled();

    public class ButtonPanel
    extends JPanel {
        public ButtonPanel() {
            JTimerProgressPanel.this.hideButton = new JClassicButton(SwingLocale.getString("hide"), IconFactory.getSwingIcon("stereo/confirm_16.png"), SwingLocale.getString("hide"));
            ActionListener hideActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(JTimerProgressPanel.this), SwingLocale.getString("confirm_to_hide"), SwingLocale.getString("confirm"), 0);
                    if (selectedValue != 0) {
                        return;
                    }
                    JTimerProgressPanel.this.stop();
                    JTimerProgressPanel.this.fireHidden();
                }
            };
            JTimerProgressPanel.this.hideButton.addActionListener(hideActionListener);
            KeyStrokeManager.registerButtonToEnterKey(JTimerProgressPanel.this.hideButton, hideActionListener);
            JTimerProgressPanel.this.cancelButton = new JClassicButton(SwingLocale.getString("cancel"), IconFactory.getSwingIcon("stereo/cancel_16.png"), SwingLocale.getString("cancel"));
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selectedValue = JBasicOptionPane.showConfirmDialog(HandleManager.getFrame(JTimerProgressPanel.this), SwingLocale.getString("confirm_to_cancel"), SwingLocale.getString("confirm"), 0);
                    if (selectedValue != 0) {
                        return;
                    }
                    JTimerProgressPanel.this.stop();
                    JTimerProgressPanel.this.fireCancelled();
                }
            };
            JTimerProgressPanel.this.cancelButton.addActionListener(cancelActionListener);
            KeyStrokeManager.registerButtonToEscapeKey(JTimerProgressPanel.this.cancelButton, cancelActionListener);
            this.setLayout(new FlowLayout(2));
            this.add(JTimerProgressPanel.this.hideButton);
            this.add(JTimerProgressPanel.this.cancelButton);
        }
    }

    public class ProgressPanel
    extends JPanel {
        public ProgressPanel() {
            JTimerProgressPanel.this.timerProgressBar = new JTimerProgressBar();
            this.setLayout(new BorderLayout());
            this.add(Box.createHorizontalStrut(5), "West");
            this.add(JTimerProgressPanel.this.timerProgressBar);
            this.add(Box.createHorizontalStrut(5), "East");
        }
    }

    public class LabelPanel
    extends JPanel {
        public LabelPanel() {
            JTimerProgressPanel.this.informationLabel = new JLabel(JTimerProgressPanel.this.information);
            JTimerProgressPanel.this.informationLabel.setIconTextGap(5);
            JTimerProgressPanel.this.informationLabel.setHorizontalAlignment(10);
            this.setLayout(new FlowLayout(3));
            this.add(JTimerProgressPanel.this.animationLabel);
            this.add(Box.createHorizontalStrut(5));
            this.add(JTimerProgressPanel.this.informationLabel);
        }
    }
}

