/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.list.toggle;

import com.nepxion.swing.element.IElementNode;
import com.nepxion.swing.list.toggle.IToggleAdapter;
import com.nepxion.swing.list.toggle.IToggleList;
import com.nepxion.swing.toggle.IToggleContentPanel;
import com.nepxion.swing.toggle.ITogglePanel;
import com.nepxion.swing.toggle.JThreadTogglePanel;

public abstract class AbstractToggleAdapter
implements IToggleAdapter {
    private IToggleList toggleList;

    public AbstractToggleAdapter(IToggleList toggleList) {
        this.toggleList = toggleList;
        this.toggleList.setToggleAdapter(this);
    }

    @Override
    public void toggle(int oldSelectedRow, int newSelectedRow) {
        if (newSelectedRow == -1) {
            return;
        }
        IToggleContentPanel toggleContentPanel = this.toggleList.getToggleContentPanel();
        if (toggleContentPanel == null) {
            return;
        }
        IElementNode elementNode = (IElementNode)this.toggleList.getModel().getElementAt(newSelectedRow);
        ITogglePanel togglePanel = this.getTogglePanel(elementNode);
        if (togglePanel == null) {
            return;
        }
        String text = ((Object)elementNode).toString();
        if (togglePanel.getToggleText() == null) {
            togglePanel.setToggleText(text);
        }
        if (togglePanel.getToggleDescription() == null) {
            togglePanel.setToggleDescription(text);
        }
        toggleContentPanel.toggle(togglePanel);
        if (togglePanel instanceof JThreadTogglePanel) {
            JThreadTogglePanel threadTogglePanel = (JThreadTogglePanel)togglePanel;
            threadTogglePanel.execute();
        }
    }

    public IToggleList getToggleList() {
        return this.toggleList;
    }

    public abstract ITogglePanel getTogglePanel(IElementNode var1);
}

