/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.H.I;
import twaver.chart.Bubble;
import twaver.web.svg.chart.AbstractSVGXYScaleChart;
import twaver.web.svg.network.SVGContext;

public class SVGBubbleChart
extends AbstractSVGXYScaleChart {
    private int \u01bb = TUIManager.getInt("tchart.line.type");
    private int \u01bd = TUIManager.getInt("tchart.inflexion.style");
    private boolean \u01b6 = TUIManager.getBoolean("tchart.inflexion.visible");
    private boolean \u01bf = TUIManager.getBoolean("tchart.bubble.area.selectable");
    private boolean \u01b9 = TUIManager.getBoolean("tchart.bubble.shape.line.visible");
    private boolean \u01b5 = TUIManager.getBoolean("tchart.bubble.shape.bubble.visible");
    private boolean \u01b8 = TUIManager.getBoolean("tchart.bubble.gradient");
    private int \u01ba = TUIManager.getInt("tchart.bubble.gradient.factory");
    private float \u01c0 = TUIManager.getFloat("tchart.bubble.alpha");
    private int \u01bc = TUIManager.getInt("tchart.bubble.style");
    private Color \u01b7 = TUIManager.getColor("tchart.bubble.gradient.color");
    private int \u01be = 1;

    public SVGBubbleChart() {
    }

    public SVGBubbleChart(TDataBox box) {
        super(box);
    }

    public SVGBubbleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor);
    }

    public SVGBubbleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    protected void calculateYAxisRange() {
        int count = this.publishedElements.size();
        double yscaleMax = this.getYScaleMaxValue();
        double yscaleMmin = this.getYScaleMinValue();
        this.max = this.getYScaleMaxValue();
        this.min = this.getYScaleMinValue();
        if (yscaleMax == -1.7976931348623157E308 || yscaleMmin == Double.MAX_VALUE) {
            for (int i2 = 0; i2 < count; ++i2) {
                Element element = (Element)this.publishedElements.get(i2);
                List list = this.getValues(element);
                int count2 = list.size();
                for (int j2 = 0; j2 < count2; ++j2) {
                    Object obj = list.get(j2);
                    Bubble bubble = (Bubble)obj;
                    if (bubble.getX() < this.getXScaleMinValue() || bubble.getX() > this.getXScaleMaxValue()) continue;
                    double value = bubble.getY();
                    if (yscaleMax == -1.7976931348623157E308 && value > this.max) {
                        this.max = value;
                    }
                    if (yscaleMmin != Double.MAX_VALUE || !(value < this.min)) continue;
                    this.min = value;
                }
            }
        }
        if (this.min == Double.MAX_VALUE) {
            if (this.max != -1.7976931348623157E308) {
                this.min = this.max * 0.9;
            } else {
                this.max = 100.0;
                this.min = 0.0;
            }
        } else if (this.max == -1.7976931348623157E308) {
            this.max = this.min * 1.1;
        }
        if (this.max == -1.7976931348623157E308) {
            if (this.min == Double.MAX_VALUE) {
                this.max = 100.0;
                this.min = 0.0;
            } else {
                this.max = this.min * 1.1;
            }
        } else if (this.min == Double.MAX_VALUE) {
            this.min = this.max * 0.9;
        }
        if (this.max == this.min) {
            if (this.max == 0.0) {
                this.max = 10.0;
                this.min = -10.0;
            } else {
                double temp = this.max * 0.1;
                this.max += temp;
                this.min -= temp;
            }
        }
        this.range = Math.abs(Math.max(this.max - this.min, 1.0));
    }

    protected void paintContent(SVGContext context, StringBuffer result, int width, int height) {
        List bubbleList;
        List list;
        Element element;
        int i2;
        int size = this.publishedElements.size();
        for (i2 = 0; i2 < size; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (element.isSelected()) continue;
            list = element.getChartValues();
            bubbleList = this.getBubbleList(element, list);
            this.A(context, result, width, height, bubbleList, element);
        }
        for (i2 = 0; i2 < size; ++i2) {
            element = (Element)this.publishedElements.get(i2);
            if (!element.isSelected()) continue;
            list = element.getChartValues();
            bubbleList = this.getBubbleList(element, list);
            this.A(context, result, width, height, bubbleList, element);
        }
    }

    protected List getBubbleList(Element element, List list) {
        return list;
    }

    private void A(SVGContext context, StringBuffer result, int width, int height, List list, Element element) {
        Rectangle2D.Double drawBound = this.getDrawBound();
        double minValue = this.getXScaleMinValue();
        double maxValue = this.getXScaleMaxValue();
        double xRange = maxValue - minValue;
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        int orListSize = list.size();
        double drawBoundLeftDownPoint = drawBound.y + drawBound.height;
        double zeroLine = drawBound.y + drawBound.height - drawBound.height * (0.0 - this.min) / this.range;
        if (this.min > 0.0) {
            zeroLine = drawBound.y + drawBound.height;
        }
        if (this.max < 0.0) {
            zeroLine = drawBound.y;
        }
        for (int i2 = 0; i2 < orListSize; ++i2) {
            Bubble bubble = (Bubble)list.get(i2);
            double xValue = bubble.getX();
            double yValue = bubble.getY();
            double x = drawBound.x + drawBound.width * (xValue - minValue) / xRange;
            double y = drawBoundLeftDownPoint - drawBound.height * ((yValue - this.min) / this.range);
            points.add(new Point2D.Double(x, y));
        }
        this.A(context, result, list, element, points, zeroLine);
    }

    private void A(SVGContext context, StringBuffer result, List list, Element element, List points, double zeroLine) {
        boolean useXScaleList;
        int size = list.size();
        Rectangle2D.Double drawBound = this.getDrawBound();
        List xScaleList = this.getXScaleTextList();
        boolean bl = useXScaleList = xScaleList != null && xScaleList.size() > 0;
        if (useXScaleList && xScaleList.size() < size) {
            size = xScaleList.size();
        }
        double xPixelGap = 0.0;
        if (useXScaleList) {
            xPixelGap = Math.max(drawBound.getWidth() / (double)xScaleList.size(), 1.0);
        }
        if (size == 1) {
            Bubble bubble = (Bubble)list.get(0);
            Point2D.Double point = (Point2D.Double)points.get(0);
            if (useXScaleList) {
                point.x = drawBound.getX() + xPixelGap / 2.0;
            }
            if (this.\u01bb == 3) {
                Line2D.Double line = new Line2D.Double(point.x, point.y, point.x, zeroLine);
                Stroke stroke = this.getStroke(element);
                if (stroke != null) {
                    this.paintLine(context, result, line, element, stroke, bubble, null);
                }
            }
            this.A(context, result, element, bubble, point, 0);
        } else {
            Bubble bubble = null;
            Bubble nextbubble = null;
            Point2D.Double point = null;
            Point2D.Double nextPoint = null;
            int useValueSpanCount = this.\u01be > 0 ? this.\u01be : 1;
            for (int i2 = 0; i2 < size; ++i2) {
                Color areaColor;
                Stroke stroke;
                Line2D.Double line;
                bubble = (Bubble)list.get(i2);
                point = (Point2D.Double)points.get(i2);
                nextbubble = null;
                nextPoint = null;
                if (i2 % useValueSpanCount != 0) continue;
                if (i2 + useValueSpanCount >= size) {
                    if (this.\u01bb != 3) {
                        continue;
                    }
                } else {
                    nextbubble = (Bubble)list.get(i2 + useValueSpanCount);
                    nextPoint = (Point2D.Double)points.get(i2 + useValueSpanCount);
                }
                if (!useXScaleList && (bubble.getX() < this.getXScaleMinValue() || bubble.getX() > this.getXScaleMaxValue() || this.\u01bb != 3 && (nextbubble.getX() < this.getXScaleMinValue() || nextbubble.getX() > this.getXScaleMaxValue()))) continue;
                if (useXScaleList) {
                    point.x = drawBound.getX() + (double)i2 * xPixelGap + xPixelGap / 2.0;
                    if (i2 + useValueSpanCount < size) {
                        nextPoint.x = drawBound.getX() + xPixelGap / 2.0 + (double)(i2 + useValueSpanCount) * xPixelGap;
                    }
                }
                if (this.\u01bb == 3) {
                    line = new Line2D.Double(point.x, point.y, point.x, zeroLine);
                    stroke = this.getStroke(element);
                    if (stroke != null) {
                        this.paintLine(context, result, line, element, stroke, bubble, nextbubble);
                    }
                    this.A(context, result, element, bubble, point, i2);
                    continue;
                }
                line = new Line2D.Double(point.x, point.y, nextPoint.x, nextPoint.y);
                stroke = this.getStroke(element);
                if (stroke != null) {
                    this.paintLine(context, result, line, element, stroke, bubble, nextbubble);
                }
                if (this.\u01bb == 2 && (areaColor = this.getAreaColor(element)) != null) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo((float)point.x, (float)zeroLine);
                    path.lineTo((float)point.x, (float)point.y);
                    path.lineTo((float)nextPoint.x, (float)nextPoint.y);
                    path.lineTo((float)nextPoint.x, (float)zeroLine);
                    path.closePath();
                    I.A(context, result, path, areaColor);
                }
                this.A(context, result, element, bubble, point, i2);
                if (i2 + useValueSpanCount * 2 < size) continue;
                this.A(context, result, element, nextbubble, nextPoint, i2 + useValueSpanCount);
            }
        }
    }

    protected boolean getShapeLineVisible(Element element) {
        Object value = element.getClientProperty("chart.bubble.shape.line.visible");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.\u01b9;
    }

    protected boolean getShapeBubbleVisible(Element element, Bubble bubble, int index) {
        Object value = element.getClientProperty("chart.bubble.shape.bubble.visible");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.\u01b5;
    }

    protected Shape paintLine(SVGContext context, StringBuffer result, Line2D.Double line, Element element, Stroke stroke, Bubble startBubble, Bubble endBubble) {
        if (!this.getShapeLineVisible(element)) {
            return null;
        }
        Shape segment = stroke.createStrokedShape(line);
        if (element.isSelected()) {
            I.A(context, result, segment, this.getSelectedLineColor(element, startBubble, endBubble), this.getSelectedStroke(element));
        }
        Color color = this.getLineColor(element, startBubble, endBubble);
        I.A(context, result, segment, color);
        return segment;
    }

    protected Color getLineColor(Element element, Bubble startBubble, Bubble endBubble) {
        return this.getColor(element);
    }

    protected Color getSelectedLineColor(Element element, Bubble startBubble, Bubble endBubble) {
        return this.getSelectedColor(element);
    }

    protected void paintShape(SVGContext context, StringBuffer result, Element element, Point2D.Double point, Bubble bubble, int index) {
        Shape shape = this.A(context, result, element, point, bubble, index);
        if (shape != null) {
            if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
                if (this.\u01b8) {
                    String gradientID = this.getGradientID(context, this.\u01ba, this.\u01b7, this.getShapeColor(element, bubble, index));
                    I.A(context, result, shape, (Object)gradientID, null, null, this.\u01c0, 0.0, null);
                } else {
                    I.A(context, result, shape, this.getShapeColor(element, bubble, index));
                }
                if (element.isSelected()) {
                    shape = this.getStroke(element).createStrokedShape(shape);
                    I.A(context, result, shape, this.getSelectedColor(element), this.getSelectedStroke(element));
                    I.A(context, result, shape, this.getShapeColor(element, bubble, index));
                }
            } else {
                Color color = this.getShapeColor(element, bubble, index);
                I.A(context, result, shape, color);
            }
        }
    }

    private void A(SVGContext context, StringBuffer result, Element element, Bubble bubble, Point2D.Double point, int index) {
        if (bubble.getValue() > 0.0) {
            if (this.getShapeBubbleVisible(element, bubble, index)) {
                this.paintShape(context, result, element, point, bubble, index);
            } else if (this.\u01b6) {
                this.paintShape(context, result, element, point, bubble, index);
            }
        } else if (this.\u01b6) {
            this.paintShape(context, result, element, point, bubble, index);
        }
        if (this.valueTextVisible) {
            String text = this.getValueText(element, bubble, index);
            I.A(context, result, text, this.getValueTextColor(element, bubble, index), this.valueTextFont, (int)point.x, (int)point.y, this.getValueTextPosition(element, bubble, index));
        }
    }

    private Shape A(SVGContext context, StringBuffer result, Element element, Point2D.Double point, Bubble bubble, int index) {
        int inflexionStyle = this.getShapeStyle(element, bubble, index);
        Rectangle2D.Double bounds = this.getShapeBounds(element, point, bubble, index);
        Shape shape = null;
        if (inflexionStyle == 1) {
            float x = (float)bounds.x;
            float y = (float)bounds.y;
            float width = (float)bounds.width;
            float height = (float)bounds.height;
            shape = new Ellipse2D.Float(x, y, width, height);
        } else if (inflexionStyle == 2) {
            bounds.x -= 1.0;
            bounds.y -= 1.0;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(bounds.x + bounds.width / 2.0), (float)bounds.y);
            path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height / 2.0));
            path.lineTo((float)(bounds.x + bounds.width / 2.0), (float)(bounds.y + bounds.height));
            path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height / 2.0));
            path.closePath();
            shape = path;
        } else if (inflexionStyle == 3) {
            shape = bounds;
        } else if (inflexionStyle == 4) {
            bounds.x -= 1.0;
            bounds.y -= 1.0;
            GeneralPath path = new GeneralPath();
            path.moveTo((float)(bounds.x + bounds.width / 2.0), (float)bounds.y);
            path.lineTo((float)bounds.x, (float)(bounds.y + bounds.height));
            path.lineTo((float)(bounds.x + bounds.width), (float)(bounds.y + bounds.height));
            path.closePath();
            shape = path;
        }
        return shape;
    }

    protected Color getAreaColor(Element element) {
        Color color = this.getColor(element);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    protected int getValueTextPosition(Element element, Bubble bubble, int index) {
        Object value = element.getClientProperty("chart.value.text.position");
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (this.isValueTextCenter()) {
            return 1;
        }
        return this.valueTextPosition;
    }

    protected Color getValueTextColor(Element element, Bubble bubble, int index) {
        return this.valueTextColor;
    }

    protected String getValueText(Element element, Bubble bubble, int index) {
        String text = "";
        if (bubble.getText() != null) {
            text = bubble.getText();
        } else {
            double value = bubble.getY();
            if (this.format != null) {
                text = this.format.format(value);
            }
        }
        return text;
    }

    protected Color getShapeColor(Element element, Bubble bubble, int index) {
        return this.getColor(element);
    }

    protected int getShapeStyle(Element element, Bubble bubble, int index) {
        Object value;
        String key = "chart.inflexion.style";
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            key = "chart.bubble.style";
        }
        if ((value = element.getClientProperty(key)) instanceof Integer) {
            return (Integer)value;
        }
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            return this.\u01bc;
        }
        return this.\u01bd;
    }

    protected Rectangle2D.Double getShapeBounds(Element element, Point2D.Double point, Bubble bubble, int index) {
        int w = (int)this.getShapeSize(element, bubble, index);
        Rectangle2D.Double bounds = new Rectangle2D.Double(point.x - (double)w, point.y - (double)w, w * 2 + 1, w * 2 + 1);
        if (this.getShapeStyle(element, bubble, index) == 2) {
            if (bounds.width % 2.0 == 1.0) {
                bounds.width += 1.0;
            }
            if (bounds.height % 2.0 == 1.0) {
                bounds.height += 1.0;
            }
        }
        return bounds;
    }

    protected double getShapeSize(Element element, Bubble bubble, int index) {
        if (bubble.getValue() > 0.0 && this.getShapeBubbleVisible(element, bubble, index)) {
            return bubble.getValue();
        }
        Stroke stroke = this.getStroke(element);
        int w = 2;
        if (stroke instanceof BasicStroke) {
            w = (int)((BasicStroke)stroke).getLineWidth() + 1;
        }
        return w;
    }

    public void removeHead(int count) {
        for (int i2 = 0; i2 < this.publishedElements.size(); ++i2) {
            Element element = (Element)this.publishedElements.get(i2);
            List valueList = this.getValues(element);
            for (int remain = count; remain > 0 && valueList.size() > 0; --remain) {
                valueList.remove(0);
                List xScaleTextList = this.getXScaleTextList();
                if (i2 != 0 || xScaleTextList == null || xScaleTextList.size() <= 0) continue;
                xScaleTextList.remove(0);
            }
        }
        this.publishData();
    }

    public boolean isInflexionVisible() {
        return this.\u01b6;
    }

    public void setInflexionVisible(boolean inflexionVisible) {
        this.\u01b6 = inflexionVisible;
    }

    public int getInflexionStyle() {
        return this.\u01bd;
    }

    public void setInflexionStyle(int inflexionStyle) {
        this.\u01bd = inflexionStyle;
    }

    public int getLineType() {
        return this.\u01bb;
    }

    public void setLineType(int lineType) {
        this.\u01bb = lineType;
    }

    public boolean isAreaSelectable() {
        return this.\u01bf;
    }

    public void setAreaSelectable(boolean areaSelectable) {
        this.\u01bf = areaSelectable;
    }

    public boolean isShapeLineVisible() {
        return this.\u01b9;
    }

    public void setShapeLineVisible(boolean lineVisible) {
        this.\u01b9 = lineVisible;
    }

    public boolean isShapeBubbleVisible() {
        return this.\u01b5;
    }

    public void setShapeBubbleVisible(boolean bubbleVisible) {
        this.\u01b5 = bubbleVisible;
    }

    public float getBubbleAlpha() {
        return this.\u01c0;
    }

    public void setBubbleAlpha(float bubbleAlpha) {
        this.\u01c0 = bubbleAlpha;
        if (bubbleAlpha > 1.0f) {
            this.\u01c0 = 1.0f;
        }
        if (bubbleAlpha < 0.0f) {
            this.\u01c0 = 0.0f;
        }
    }

    public int getBubbleGradientFactory() {
        return this.\u01ba;
    }

    public void setBubbleGradientFactory(int bubbleGradientFactory) {
        this.\u01ba = bubbleGradientFactory;
    }

    public boolean isBubbleGradient() {
        return this.\u01b8;
    }

    public void setBubbleGradient(boolean bubbleGradient) {
        this.\u01b8 = bubbleGradient;
    }

    public int getBubbleStyle() {
        return this.\u01bc;
    }

    public void setBubbleStyle(int bubbleStyle) {
        this.\u01bc = bubbleStyle;
    }

    public Color getBubbleGradientColor() {
        return this.\u01b7;
    }

    public void setBubbleGradientColor(Color bubbleGradientColor) {
        this.\u01b7 = bubbleGradientColor;
    }

    public int getValueSpanCount() {
        return this.\u01be;
    }

    public void setValueSpanCount(int valueSpanCount) {
        this.\u01be = valueSpanCount;
    }
}

