/*
 * Decompiled with CFR 0.152.
 */
package twaver.table.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import twaver.AlarmSeverity;
import twaver.AlarmState;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverConst;
import twaver.TWaverUtil;
import twaver.UndoRedoEvent;
import twaver.table.editor.IntegerEditor;

public class AlarmStateEditorUI
extends JDialog {
    TDataBox U;
    AlarmState state;
    ActionListener d;
    final String T = TWaverUtil.getString("Alarm.Severity");
    final String a = TWaverUtil.getString("Alarm.New");
    final String R = TWaverUtil.getString("Alarm.Acked");
    String[] C = new String[]{this.T, this.a, this.R};
    JPanel P = new JPanel();
    BorderLayout H = new BorderLayout();
    JPanel D = new JPanel();
    JPanel G = new JPanel();
    FlowLayout Q = new FlowLayout();
    JButton X = new JButton();
    JButton e = new JButton();
    BorderLayout _ = new BorderLayout();
    JScrollPane B = new JScrollPane();
    JTable b = new JTable();
    DefaultTableModel I = new DefaultTableModel(new Vector(), new Vector<String>(Arrays.asList(this.C))){

        public boolean isCellEditable(int row, int column) {
            return !this.getColumnName(column).equals(AlarmStateEditorUI.this.T);
        }
    };
    IntegerEditor K = new IntegerEditor();
    JButton Y = new JButton();
    JPanel F = new JPanel();
    JPanel W = new JPanel();
    JPanel O = new JPanel();
    GridLayout J = new GridLayout();
    JLabel V = new JLabel();
    JLabel A = new JLabel();
    JLabel E = new JLabel();
    JLabel S = new JLabel();
    JPanel g = new JPanel();
    GridLayout Z = new GridLayout();
    GridLayout c = new GridLayout();
    GridLayout f = new GridLayout();
    JLabel N = new JLabel();
    JLabel M = new JLabel();
    TitledBorder L;

    public AlarmStateEditorUI(Dialog dialog, TDataBox box, AlarmState state, ActionListener actionListener) {
        super(dialog, true);
        this.U = box;
        this.state = state;
        this.d = actionListener;
        this.C();
    }

    public AlarmStateEditorUI(Frame frame, TDataBox box, AlarmState state, ActionListener actionListener) {
        super(frame, true);
        this.U = box;
        this.state = state;
        this.d = actionListener;
        this.C();
    }

    private void C() {
        this.B();
        this.A();
        this.pack();
        this.setSize(450, 350);
        TWaverUtil.centerWindow(this);
    }

    private void B() {
        this.L = new TitledBorder("");
        this.setTitle(TWaverUtil.getString("Alarm.State"));
        this.getRootPane().setDefaultButton(this.e);
        this.P.setLayout(this.H);
        this.G.setLayout(this.Q);
        this.Q.setAlignment(2);
        this.Q.setHgap(10);
        this.Q.setVgap(10);
        this.X.setText(TWaverUtil.getString("CANCEL"));
        this.X.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlarmStateEditorUI.this.C(e2);
            }
        });
        this.e.setText(TWaverUtil.getString("CONFIRM"));
        this.e.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlarmStateEditorUI.this.B(e2);
            }
        });
        this.D.setLayout(this._);
        this.D.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.Y.setText(TWaverUtil.getString("RESET"));
        this.Y.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                AlarmStateEditorUI.this.A(e2);
            }
        });
        this.F.setLayout(this.Z);
        this.Z.setColumns(1);
        this.Z.setRows(3);
        this.Z.setVgap(10);
        this.O.setLayout(this.J);
        this.J.setColumns(2);
        this.V.setText(TWaverUtil.getString("Alarm.Overall.Severity"));
        this.E.setText(TWaverUtil.getString("Alarm.Propagate.Severity"));
        this.W.setLayout(this.c);
        this.g.setLayout(this.f);
        this.c.setColumns(2);
        this.c.setRows(1);
        this.M.setText(TWaverUtil.getString("Alarm.Native.Severity"));
        this.N.setBorder(this.L);
        this.B.setBorder(new TitledBorder(null, TWaverUtil.getString("Alarm.Native.Severity") + " " + TWaverUtil.getString("DETAIL")));
        this.F.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), TWaverUtil.getString("Alarm.Summarizing")), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.A.setBorder(this.L);
        this.S.setBorder(this.L);
        this._.setVgap(5);
        this.getContentPane().add(this.P);
        this.P.add((Component)this.D, "Center");
        this.P.add((Component)this.G, "South");
        this.G.add((Component)this.Y, null);
        this.G.add((Component)this.e, null);
        this.G.add((Component)this.X, null);
        this.D.add((Component)this.B, "Center");
        this.D.add((Component)this.F, "North");
        this.F.add((Component)this.W, null);
        this.W.add((Component)this.V, null);
        this.W.add((Component)this.A, null);
        this.F.add((Component)this.g, null);
        this.g.add((Component)this.M, null);
        this.g.add((Component)this.N, null);
        this.F.add((Component)this.O, null);
        this.O.add((Component)this.E, null);
        this.O.add((Component)this.S, null);
        this.B.getViewport().add((Component)this.b, null);
    }

    private void A() {
        if (this.state.getHighestNativeAlarmSeverity() != null) {
            this.A.setOpaque(true);
            this.A.setBackground(this.state.getHighestNativeAlarmSeverity().getColor());
        }
        if (this.state.getHighestNativeAlarmSeverity() != null) {
            this.N.setOpaque(true);
            this.N.setBackground(this.state.getHighestNativeAlarmSeverity().getColor());
        }
        if (this.state.getPropagateSeverity() != null) {
            this.S.setOpaque(true);
            this.S.setBackground(this.state.getPropagateSeverity().getColor());
        }
        this.b.setModel(this.I);
        Iterator it = AlarmSeverity.iterator();
        while (it.hasNext()) {
            AlarmSeverity severity = (AlarmSeverity)it.next();
            Vector<Comparable> row = new Vector<Comparable>();
            row.addElement(severity);
            row.addElement(TWaverUtil.valueOf(this.state.getNewAlarmCount(severity)));
            row.addElement(TWaverUtil.valueOf(this.state.getAcknowledgedAlarmCount(severity)));
            this.I.addRow(row);
        }
        this.b.getColumn(this.T).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                AlarmSeverity severity = (AlarmSeverity)value;
                label.setBackground(severity.getColor());
                label.setFont(TUIManager.getDefaultBoldFont());
                label.setText(severity.getDisplayName());
                return label;
            }
        });
        this.b.getColumn(this.a).setCellEditor(this.K);
        this.b.getColumn(this.R).setCellEditor(this.K);
    }

    void C(ActionEvent e2) {
        ActionEvent event = new ActionEvent(this, 1001, "cancel");
        this.d.actionPerformed(event);
    }

    void B(ActionEvent e2) {
        if (this.b.isEditing() && !this.K.stopCellEditing()) {
            return;
        }
        AlarmState newAlarmState = new AlarmState();
        Iterator<Vector> it = this.I.getDataVector().iterator();
        while (it.hasNext()) {
            Vector row = it.next();
            AlarmSeverity severity = (AlarmSeverity)row.get(0);
            int newAlarmCount = (Integer)row.get(1);
            int ackAlarmCount = (Integer)row.get(2);
            newAlarmState.setNewAlarmCount(severity, newAlarmCount);
            newAlarmState.setAcknowledgedAlarmCount(severity, ackAlarmCount);
        }
        if (this.U == null || this.U.getSelectionModel().size() == 0) {
            this.state.copyFrom(newAlarmState);
        } else {
            Element element;
            this.U.getUndoRedoManager().setIgnorePropertyChange(true);
            List elements = this.U.getSelectionModel().getAllSelectedElement();
            ArrayList<Object> oldAlarmStates = new ArrayList<Object>();
            for (int i2 = 0; i2 < elements.size(); ++i2) {
                Element element2 = (Element)elements.get(i2);
                oldAlarmStates.add(element2.getAlarmState().clone());
                element2.getAlarmState().copyFrom(newAlarmState);
            }
            this.U.getUndoRedoManager().setIgnorePropertyChange(false);
            if (this.U != null && (element = this.U.getLastSelectedElement()) != null) {
                this.U.getUndoRedoManager().addEvent(new UndoRedoEvent(elements, oldAlarmStates, newAlarmState));
            }
        }
        this.C(e2);
    }

    void A(ActionEvent e2) {
        if (this.b.isEditing()) {
            this.K.cancelCellEditing();
        }
        for (int i2 = 0; i2 < this.I.getRowCount(); ++i2) {
            this.I.setValueAt(TWaverConst.INTEGER0, i2, 1);
            this.I.setValueAt(TWaverConst.INTEGER0, i2, 2);
        }
    }
}

