/*
 * Decompiled with CFR 0.152.
 */
package twaver.network.ui;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import twaver.ShapeLink;
import twaver.base.A.E.d;
import twaver.network.ui.LinkBorderUI;
import twaver.network.ui.ShapeLinkUI;

public class ShapeLinkBorderUI
extends LinkBorderUI {
    public ShapeLinkBorderUI(ShapeLinkUI linkUI) {
        super(linkUI);
    }

    public void paintBorder(Graphics2D g2d) {
        if (this.network.isResizable(this.element)) {
            return;
        }
        super.paintBorder(g2d);
    }

    protected void paintPoints(Graphics2D g2d) {
        if (this.network.isResizable(this.element) && this.isVisible()) {
            ShapeLink shapeLink = (ShapeLink)this.getElement();
            int type = shapeLink.getShapeLinkType();
            if (type == 3 || type == 2) {
                GeneralPath path = new GeneralPath();
                List points = shapeLink.getPoints();
                ShapeLinkUI ui = (ShapeLinkUI)this.getElementUI();
                Point2D point = ui.getFromPoint();
                path.moveTo((int)point.getX(), (int)point.getY());
                for (int i2 = 0; i2 < points.size(); ++i2) {
                    point = (Point2D)points.get(i2);
                    path.lineTo((int)point.getX(), (int)point.getY());
                }
                point = ui.getToPoint();
                path.lineTo((int)point.getX(), (int)point.getY());
                d.A(g2d, (Shape)path);
            }
            d.B(g2d, (Shape)this.C());
        }
    }

    private Area C() {
        if (!this.isVisible()) {
            return null;
        }
        Area area = new Area();
        ShapeLink shapeLink = (ShapeLink)this.getElement();
        List points = shapeLink.getPoints();
        for (int i2 = 0; i2 < points.size(); ++i2) {
            Point2D point = (Point2D)points.get(i2);
            Rectangle rect = new Rectangle((int)point.getX() - 3, (int)point.getY() - 3, 6, 6);
            area.add(new Area(rect));
        }
        return area;
    }

    public int getPointIndex(Point p2) {
        if (p2 == null || !this.isVisible()) {
            return -1;
        }
        ShapeLink shapeLink = (ShapeLink)this.getElement();
        List points = shapeLink.getPoints();
        for (int i2 = 0; i2 < points.size(); ++i2) {
            Point2D point = (Point2D)points.get(i2);
            Rectangle rect = new Rectangle((int)point.getX() - 3, (int)point.getY() - 3, 6, 6);
            if (!rect.contains(p2)) continue;
            return i2;
        }
        return -1;
    }
}

