/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar.demo;

import com.toedter.calendar.JCalendar;
import com.toedter.calendar.JDateChooser;
import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JYearChooser;
import com.toedter.calendar.demo.DateChooserPanel;
import com.toedter.components.JLocaleChooser;
import com.toedter.components.JSpinField;
import com.toedter.components.JTitlePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JCalendarDemo
extends JApplet
implements PropertyChangeListener {
    private static final long serialVersionUID = 6739986412544494316L;
    private JSplitPane splitPane;
    private JPanel calendarPanel;
    private JComponent[] beans;
    private JPanel propertyPanel;
    private JTitlePanel propertyTitlePanel;
    private JTitlePanel componentTitlePanel;
    private JPanel componentPanel;
    private JToolBar toolBar;

    public void init() {
        this.initializeLookAndFeels();
        this.beans = new JComponent[6];
        this.beans[0] = new DateChooserPanel();
        this.beans[1] = new JCalendar();
        this.beans[2] = new JDayChooser();
        this.beans[3] = new JMonthChooser();
        this.beans[4] = new JYearChooser();
        this.beans[5] = new JSpinField();
        ((JSpinField)this.beans[5]).adjustWidthToMaximumValue();
        ((JYearChooser)this.beans[4]).setMaximum(((JSpinField)this.beans[5]).getMaximum());
        ((JYearChooser)this.beans[4]).adjustWidthToMaximumValue();
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.toolBar = this.createToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.splitPane.setDividerSize(4);
        this.splitPane.setDividerLocation(200);
        BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)this.splitPane.getUI()).getDivider();
        if (basicSplitPaneDivider != null) {
            basicSplitPaneDivider.setBorder(null);
        }
        this.propertyPanel = new JPanel();
        this.componentPanel = new JPanel();
        URL uRL = this.beans[0].getClass().getResource("images/" + this.beans[0].getName() + "Color16.gif");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.propertyTitlePanel = new JTitlePanel("Properties", null, this.propertyPanel, BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.componentTitlePanel = new JTitlePanel("Component", imageIcon, this.componentPanel, BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.splitPane.setBottomComponent(this.propertyTitlePanel);
        this.splitPane.setTopComponent(this.componentTitlePanel);
        this.installBean(this.beans[0]);
        this.getContentPane().add((Component)this.splitPane, "Center");
    }

    public final void initializeLookAndFeels() {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            boolean bl = false;
            for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
                if (!lookAndFeelInfoArray[i].getName().equals("JGoodies Plastic 3D")) continue;
                bl = true;
            }
            if (!bl) {
                UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            }
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        }
        catch (Throwable throwable) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public JToolBar createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.putClientProperty("jgoodies.headerStyle", "Both");
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        for (int i = 0; i < this.beans.length; ++i) {
            JButton jButton;
            try {
                final JComponent jComponent = this.beans[i];
                URL uRL = jComponent.getClass().getResource("images/" + jComponent.getName() + "Color16.gif");
                ImageIcon imageIcon = new ImageIcon(uRL);
                jButton = new JButton(imageIcon);
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JCalendarDemo.this.installBean(jComponent);
                    }
                };
                jButton.addActionListener(actionListener);
            }
            catch (Exception exception) {
                System.out.println("JCalendarDemo.createToolBar(): " + exception);
                jButton = new JButton(this.beans[i].getName());
            }
            jButton.setFocusPainted(false);
            this.toolBar.add(jButton);
        }
        return this.toolBar;
    }

    public JMenuBar createMenuBar() {
        Object object;
        JMenuItem jMenuItem;
        Serializable serializable;
        final JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Components");
        jMenu.setMnemonic('C');
        jMenuBar.add(jMenu);
        for (int i = 0; i < this.beans.length; ++i) {
            Serializable serializable2;
            try {
                serializable2 = this.beans[i].getClass().getResource("images/" + this.beans[i].getName() + "Color16.gif");
                serializable = new ImageIcon((URL)serializable2);
                jMenuItem = new JMenuItem(this.beans[i].getName(), (Icon)((Object)serializable));
            }
            catch (Exception exception) {
                System.out.println("JCalendarDemo.createMenuBar(): " + exception + " for URL: " + "images/" + this.beans[i].getName() + "Color16.gif");
                jMenuItem = new JMenuItem(this.beans[i].getName());
            }
            jMenu.add(jMenuItem);
            serializable2 = this.beans[i];
            object = new ActionListener((JComponent)serializable2){
                private final /* synthetic */ JComponent val$bean;
                {
                    this.val$bean = jComponent;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JCalendarDemo.this.installBean(this.val$bean);
                }
            };
            jMenuItem.addActionListener((ActionListener)object);
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        serializable = new ButtonGroup();
        jMenuItem = new JMenu("Look&Feel");
        jMenuItem.setMnemonic('L');
        jMenuBar.add((JMenu)jMenuItem);
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (lookAndFeelInfoArray[i].getName().equals("CDE/Motif")) continue;
            object = new JRadioButtonMenuItem(lookAndFeelInfoArray[i].getName());
            ((JMenu)jMenuItem).add((JMenuItem)object);
            ((AbstractButton)object).setSelected(UIManager.getLookAndFeel().getName().equals(lookAndFeelInfoArray[i].getName()));
            ((JComponent)object).putClientProperty("lnf name", lookAndFeelInfoArray[i]);
            ((AbstractButton)object).addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
                    if (jRadioButtonMenuItem.isSelected()) {
                        UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)jRadioButtonMenuItem.getClientProperty("lnf name");
                        try {
                            jMenuBar.putClientProperty("jgoodies.headerStyle", "Both");
                            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                            SwingUtilities.updateComponentTreeUI(JCalendarDemo.this);
                            for (int i = 0; i < JCalendarDemo.this.beans.length; ++i) {
                                SwingUtilities.updateComponentTreeUI(JCalendarDemo.this.beans[i]);
                            }
                            BasicSplitPaneDivider basicSplitPaneDivider = ((BasicSplitPaneUI)JCalendarDemo.this.splitPane.getUI()).getDivider();
                            if (basicSplitPaneDivider != null) {
                                basicSplitPaneDivider.setBorder(null);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            System.err.println("Unable to set UI " + exception.getMessage());
                        }
                    }
                }
            });
            ((ButtonGroup)serializable).add((AbstractButton)object);
        }
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic('H');
        object = jMenu2.add(new AboutAction(this));
        ((AbstractButton)object).setMnemonic('A');
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.calendarPanel == null || propertyChangeEvent.getPropertyName().equals("calendar")) {
            // empty if block
        }
    }

    public static void main(String[] stringArray) {
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        JFrame jFrame = new JFrame("JCalendar Demo");
        jFrame.addWindowListener(windowAdapter);
        JCalendarDemo jCalendarDemo = new JCalendarDemo();
        jCalendarDemo.init();
        jFrame.getContentPane().add(jCalendarDemo);
        jFrame.pack();
        jFrame.setBounds(200, 200, (int)jFrame.getPreferredSize().getWidth() + 20, (int)jFrame.getPreferredSize().getHeight() + 180);
        jFrame.setVisible(true);
    }

    private void installBean(JComponent jComponent) {
        try {
            this.componentPanel.removeAll();
            this.componentPanel.add(jComponent);
            BeanInfo beanInfo = Introspector.getBeanInfo(jComponent.getClass(), jComponent.getClass().getSuperclass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            this.propertyPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            this.propertyPanel.setLayout(gridBagLayout);
            int n = 0;
            String[] stringArray = new String[]{"class java.util.Locale", "boolean", "int", "class java.awt.Color", "class java.util.Date", "class java.lang.String"};
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                    ActionListener actionListener;
                    Serializable serializable;
                    if (propertyDescriptorArray[j].getWriteMethod() == null) continue;
                    String string = propertyDescriptorArray[j].getPropertyType().toString();
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[j];
                    final JComponent jComponent2 = jComponent;
                    Method method = propertyDescriptor.getReadMethod();
                    final Method method2 = propertyDescriptor.getWriteMethod();
                    if (!string.equals(stringArray[i]) || (method == null || method2 == null) && !"class java.util.Locale".equals(string)) continue;
                    if ("boolean".equals(string)) {
                        boolean bl = false;
                        try {
                            serializable = (Boolean)method.invoke((Object)jComponent, (Object[])null);
                            bl = (Boolean)serializable;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        serializable = new JCheckBox("", bl);
                        ((AbstractButton)serializable).addActionListener(new ActionListener((JCheckBox)serializable, method2, jComponent2){
                            private final /* synthetic */ JCheckBox val$checkBox;
                            private final /* synthetic */ Method val$writeMethod;
                            private final /* synthetic */ JComponent val$currentBean;
                            {
                                this.val$checkBox = jCheckBox;
                                this.val$writeMethod = method;
                                this.val$currentBean = jComponent;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    if (this.val$checkBox.isSelected()) {
                                        this.val$writeMethod.invoke((Object)this.val$currentBean, new Boolean(true));
                                    } else {
                                        this.val$writeMethod.invoke((Object)this.val$currentBean, new Boolean(false));
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        });
                        this.addProperty(propertyDescriptorArray[j], (JComponent)serializable, gridBagLayout);
                        ++n;
                        continue;
                    }
                    if ("int".equals(string)) {
                        JSpinField jSpinField = new JSpinField();
                        jSpinField.addPropertyChangeListener(new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                try {
                                    if (propertyChangeEvent.getPropertyName().equals("value")) {
                                        method2.invoke((Object)jComponent2, propertyChangeEvent.getNewValue());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        try {
                            serializable = (Integer)method.invoke((Object)jComponent, (Object[])null);
                            jSpinField.setValue((Integer)serializable);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        this.addProperty(propertyDescriptorArray[j], jSpinField, gridBagLayout);
                        ++n;
                        continue;
                    }
                    if ("class java.lang.String".equals(string)) {
                        String string2 = "";
                        try {
                            string2 = (String)method.invoke((Object)jComponent, (Object[])null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        serializable = new JTextField(string2);
                        actionListener = new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                try {
                                    method2.invoke((Object)jComponent2, actionEvent.getActionCommand());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        ((JTextField)serializable).addActionListener(actionListener);
                        this.addProperty(propertyDescriptorArray[j], (JComponent)serializable, gridBagLayout);
                        ++n;
                        continue;
                    }
                    if ("class java.util.Locale".equals(string)) {
                        JLocaleChooser jLocaleChooser = new JLocaleChooser(jComponent);
                        jLocaleChooser.setPreferredSize(new Dimension(200, jLocaleChooser.getPreferredSize().height));
                        this.addProperty(propertyDescriptorArray[j], jLocaleChooser, gridBagLayout);
                        ++n;
                        continue;
                    }
                    if ("class java.util.Date".equals(string)) {
                        Date date = null;
                        try {
                            date = (Date)method.invoke((Object)jComponent, (Object[])null);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        serializable = new JDateChooser(date);
                        ((Container)serializable).addPropertyChangeListener(new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                try {
                                    if (propertyChangeEvent.getPropertyName().equals("date")) {
                                        method2.invoke((Object)jComponent2, propertyChangeEvent.getNewValue());
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                        this.addProperty(propertyDescriptorArray[j], (JComponent)serializable, gridBagLayout);
                        ++n;
                        continue;
                    }
                    if (!"class java.awt.Color".equals(string)) continue;
                    JButton jButton = new JButton();
                    try {
                        serializable = (Color)method.invoke((Object)jComponent, (Object[])null);
                        jButton.setText("...");
                        jButton.setBackground((Color)serializable);
                        actionListener = new ActionListener((Color)serializable, jButton, method2, jComponent2){
                            private final /* synthetic */ Color val$colorObj;
                            private final /* synthetic */ JButton val$button;
                            private final /* synthetic */ Method val$writeMethod;
                            private final /* synthetic */ JComponent val$currentBean;
                            {
                                this.val$colorObj = color;
                                this.val$button = jButton;
                                this.val$writeMethod = method;
                                this.val$currentBean = jComponent;
                            }

                            public void actionPerformed(ActionEvent actionEvent) {
                                Color color = JColorChooser.showDialog(JCalendarDemo.this, "Choose Color", this.val$colorObj);
                                this.val$button.setBackground(color);
                                try {
                                    this.val$writeMethod.invoke((Object)this.val$currentBean, color);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        };
                        jButton.addActionListener(actionListener);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.addProperty(propertyDescriptorArray[j], jButton, gridBagLayout);
                    ++n;
                }
            }
            URL uRL = jComponent.getClass().getResource("images/" + jComponent.getName() + "Color16.gif");
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.componentTitlePanel.setTitle(jComponent.getName(), imageIcon);
            jComponent.invalidate();
            this.propertyPanel.invalidate();
            this.componentPanel.invalidate();
            this.componentPanel.repaint();
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    private void addProperty(PropertyDescriptor propertyDescriptor, JComponent jComponent, GridBagLayout gridBagLayout) {
        String string = propertyDescriptor.getDisplayName();
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || i == 0) {
                if (i == 0) {
                    c = (char)(c - 32);
                }
                string2 = string2 + " " + c;
                continue;
            }
            string2 = string2 + c;
        }
        JLabel jLabel = new JLabel(string2 + ": ", null, 4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.propertyPanel.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.propertyPanel.add(jComponent);
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 4514530330521503732L;

            public Dimension getPreferredSize() {
                return new Dimension(10, 2);
            }
        };
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.propertyPanel.add(jPanel);
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -5204865941545323214L;
        private final JCalendarDemo demo;

        AboutAction(JCalendarDemo jCalendarDemo2) {
            super("About...");
            this.demo = jCalendarDemo2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(this.demo, "JCalendar Demo\nVersion 1.3.2\n\nKai Toedter\nkai@toedter.com\nwww.toedter.com", "About...", 1);
        }
    }
}

