/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLayout;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.LayoutOrientation;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.util.DataProviderAdapter;

public class OrientationLayouter
extends AbstractLayoutStage
implements LayoutOrientation {
    DataProvider ca;
    DataProvider b8;
    DataProvider b6;
    DataProvider b9;
    private byte b7;

    public OrientationLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
        this.setOrientation((byte)0);
    }

    public OrientationLayouter() {
    }

    public void setOrientation(byte by) {
        this.b7 = by;
    }

    public byte getOrientation() {
        return this.b7;
    }

    public boolean isHorizontalOrientation() {
        return this.b7 == 1 || this.b7 == 3;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        this.prepareOrientationChange(layoutGraph);
        if (this.getCoreLayouter() != null) {
            this.doLayoutCore(layoutGraph);
        }
        this.completeOrientationChange(layoutGraph);
    }

    protected void prepareOrientationChange(LayoutGraph layoutGraph) {
        this.e(layoutGraph);
        this.k(layoutGraph);
        this.i(layoutGraph);
        this.h(layoutGraph);
    }

    private void e(LayoutGraph layoutGraph) {
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.prepareTransform(yPoint));
            nodeCursor.next();
        }
    }

    protected void completeOrientationChange(LayoutGraph layoutGraph) {
        this.l(layoutGraph);
        this.j(layoutGraph);
        this.f(layoutGraph);
        this.g(layoutGraph);
    }

    private void l(LayoutGraph layoutGraph) {
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.completeTransform(yPoint));
            nodeCursor.next();
        }
    }

    private void j(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
            YPoint yPoint = edgeLayout.getSourcePoint();
            edgeLayout.setSourcePoint(this.completeTransform(yPoint));
            yPoint = edgeLayout.getTargetPoint();
            edgeLayout.setTargetPoint(this.completeTransform(yPoint));
            int n = 0;
            while (n < edgeLayout.pointCount()) {
                yPoint = this.completeTransform(edgeLayout.getPoint(n));
                edgeLayout.setPoint(n, yPoint.getX(), yPoint.getY());
                ++n;
            }
            edgeCursor.next();
        }
    }

    private void k(LayoutGraph layoutGraph) {
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
            YPoint yPoint = edgeLayout.getSourcePoint();
            edgeLayout.setSourcePoint(this.prepareTransform(yPoint));
            yPoint = edgeLayout.getTargetPoint();
            edgeLayout.setTargetPoint(this.prepareTransform(yPoint));
            int n = 0;
            while (n < edgeLayout.pointCount()) {
                yPoint = this.prepareTransform(edgeLayout.getPoint(n));
                edgeLayout.setPoint(n, yPoint.getX(), yPoint.getY());
                ++n;
            }
            edgeCursor.next();
        }
    }

    protected YPoint transform(YPoint yPoint, boolean bl) {
        return bl ? this.prepareTransform(yPoint) : this.completeTransform(yPoint);
    }

    protected YPoint prepareTransform(YPoint yPoint) {
        switch (this.b7) {
            case 0: {
                return yPoint;
            }
            case 1: {
                return new YPoint(-yPoint.getY(), yPoint.getX());
            }
            case 3: {
                return new YPoint(yPoint.getY(), -yPoint.getX());
            }
            case 2: {
                return new YPoint(yPoint.getX(), -yPoint.getY());
            }
        }
        return yPoint;
    }

    protected YPoint completeTransform(YPoint yPoint) {
        switch (this.b7) {
            case 0: {
                return yPoint;
            }
            case 1: {
                return new YPoint(yPoint.getY(), -yPoint.getX());
            }
            case 3: {
                return new YPoint(-yPoint.getY(), yPoint.getX());
            }
            case 2: {
                return new YPoint(yPoint.getX(), -yPoint.getY());
            }
        }
        return yPoint;
    }

    private void f(LayoutGraph layoutGraph) {
        if (this.ca != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.ca);
            this.ca = null;
            this.b6 = null;
        }
        if (this.b8 != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.b8);
            this.b8 = null;
            this.b9 = null;
        }
    }

    private void g(LayoutGraph layoutGraph) {
        this.a(layoutGraph, false);
    }

    private void i(LayoutGraph layoutGraph) {
        this.ca = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (this.ca != null) {
            this.b6 = new _a(this.ca);
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.b6);
        }
        this.b8 = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (this.b8 != null) {
            this.b9 = new _a(this.b8);
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.b9);
        }
    }

    private void h(LayoutGraph layoutGraph) {
        this.a(layoutGraph, true);
    }

    private void a(LayoutGraph layoutGraph, boolean bl) {
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edge);
                if (labelLayoutDataArray != null) {
                    int n = 0;
                    while (n < labelLayoutDataArray.length) {
                        LabelLayoutData labelLayoutData = labelLayoutDataArray[n];
                        YPoint yPoint = this.transform(new YPoint(labelLayoutData.getX() + labelLayoutData.getWidth() / 2.0, labelLayoutData.getY() + labelLayoutData.getHeight() / 2.0), bl);
                        if (this.isHorizontalOrientation()) {
                            labelLayoutData.setSize(labelLayoutData.getHeight(), labelLayoutData.getWidth());
                        }
                        labelLayoutData.setLocation(yPoint.getX() - labelLayoutData.getWidth() / 2.0, yPoint.getY() - labelLayoutData.getHeight() / 2.0);
                        if (this.b7 == 2) {
                            int n2 = labelLayoutData.getPreferredPlacement() & 7;
                            int n3 = labelLayoutData.getPreferredPlacement() & 0x38;
                            if ((n3 & 8) != 0) {
                                n2 |= 8;
                            }
                            if ((n3 & 0x10) != 0) {
                                n2 |= 0x20;
                            }
                            if ((n3 & 0x20) != 0) {
                                n2 |= 0x10;
                            }
                            labelLayoutData.setPreferredPlacement((byte)n2);
                        }
                        ++n;
                    }
                }
                edgeCursor.next();
            }
        }
    }

    private class _a
    extends DataProviderAdapter {
        DataProvider ab;

        _a(DataProvider dataProvider) {
            this.ab = dataProvider;
        }

        public Object get(Object object) {
            PortConstraint portConstraint = (PortConstraint)this.ab.get(object);
            if (portConstraint != null && !portConstraint.isAtAnySide()) {
                boolean bl = portConstraint.isStrong();
                switch (OrientationLayouter.this.getOrientation()) {
                    case 1: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 3: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 2: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 4: {
                                return portConstraint;
                            }
                            case 1: {
                                return PortConstraint.create((byte)2, bl);
                            }
                            case 8: {
                                return portConstraint;
                            }
                        }
                    }
                }
            }
            return portConstraint;
        }
    }
}

