/*
 * Decompiled with CFR 0.152.
 */
package y.base;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.GraphEvent;
import y.base.GraphInterface;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.base.YCursor;
import y.base.for;
import y.base.if;
import y.base.int;
import y.util.Cursors;
import y.util.D;

public class Graph
implements GraphInterface {
    int v = new int();
    int x = new int();
    boolean y = false;
    boolean u = false;
    private for z = new for(3, 5);
    private for w = new for(3, 5);
    private Hashtable t = new Hashtable(11);
    protected Vector listeners;
    public static final int BEFORE = 1;
    public static final int AFTER = 0;

    public Graph() {
    }

    public Graph(Graph graph) {
        this(graph, graph.nodes());
    }

    public Graph(Graph graph, YCursor yCursor) {
        this();
        if if_;
        Object object;
        this.z = graph.z.a();
        this.w = graph.w.a();
        NodeMap nodeMap = graph.createNodeMap();
        while (yCursor.ok()) {
            object = (Node)yCursor.current();
            if_ = ((Node)object).createCopy(this);
            nodeMap.set(object, if_);
            this.z.a((Node)object, (Node)if_);
            yCursor.next();
        }
        object = graph.edges();
        while (object.ok()) {
            if_ = object.edge();
            Node node = (Node)nodeMap.get(((Edge)if_).source());
            Node node2 = (Node)nodeMap.get(((Edge)if_).target());
            if (node != null && node2 != null) {
                Edge edge = ((Edge)if_).createCopy(this, node, node2);
                this.w.a((Edge)if_, edge);
            }
            object.next();
        }
        if (graph.listeners != null) {
            this.listeners = (Vector)graph.listeners.clone();
        }
        graph.t = (Hashtable)graph.t.clone();
        graph.disposeNodeMap(nodeMap);
    }

    public Graph createCopy() {
        return new Graph(this);
    }

    public Node createNode() {
        Node node = new Node(this);
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.a(this, node));
        }
        return node;
    }

    public Edge createEdge(Node node, Node node2) {
        return this.createEdge(node, null, node2, null, 0, 0);
    }

    public Edge createEdge(Node node, Edge edge, Node node2, Edge edge2, int n, int n2) {
        Edge edge3 = new Edge(this, node, edge, node2, edge2, n, n2);
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.c(this, edge3));
        }
        return edge3;
    }

    public void removeNode(Node node) {
        this.b(node);
    }

    private void b(Node node) {
        Edge edge;
        if (this.listeners != null) {
            this.firePreEvent();
            this.fireGraphEvent(GraphEvent.d(this, node));
        }
        while ((edge = node.o[0]) != null) {
            this.removeEdge(edge);
        }
        while ((edge = node.o[1]) != null) {
            this.removeEdge(edge);
        }
        this.v.a(node);
        node.m = null;
        this.y = true;
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.c(this, node));
            this.firePostEvent();
        }
    }

    public void removeEdge(Edge edge) {
        this.a(edge);
    }

    private void a(Edge edge) {
        if (edge.getGraph() != this) {
            throw new IllegalArgumentException("edge is not in graph");
        }
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.b(this, edge));
        }
        Node node = edge.source();
        Node node2 = edge.target();
        this.a(edge, node, node2);
        this.x.a(edge);
        edge.a((Graph)null);
        this.u = true;
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.a(this, edge));
        }
    }

    public void reInsertNode(Node node) {
        node.p = this.v.f();
        node.b(this);
        node.d();
        if (node.b.length < this.z.b) {
            this.z.a(node, node.b.length, this.z.b);
        }
        if (node.b.length != this.z.b) {
            D.fatal("reinserted node with mismatched slot size!!!\n" + node.b.length + " <- ! -> " + this.z.b);
        }
        this.v.d(node);
        this.y = true;
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.b(this, node));
        }
    }

    public void reInsertEdge(Edge edge) {
        if (edge.getGraph() != null) {
            throw new IllegalArgumentException("Edge " + edge + " already in graph!!!");
        }
        if (edge.b.length < this.w.b) {
            this.w.a(edge, edge.b.length, this.w.b);
        }
        if (edge.b.length != this.w.b) {
            D.fatal("reinserted edge with mismatched slot size!!!\n" + edge.b.length + " <- ! -> " + this.w.b);
        }
        if (edge.a() == null || ((Edge)edge.a()).getGraph() != this) {
            this.x.d(edge);
        } else {
            this.x.a(edge, edge.a(), 1);
        }
        edge.a(this);
        edge.onReinsert();
        this.b(edge, edge.source(), null, edge.target(), null, 0, 0);
        this.u = true;
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.f(this, edge));
        }
    }

    public void changeEdge(Edge edge, Edge edge2, Edge edge3, int n, int n2) {
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 8, edge));
        }
        Node node = edge.source();
        Node node2 = edge.target();
        this.a(edge, node, node2);
        if (edge2 != null) {
            edge.h = edge2.source();
        }
        if (edge3 != null) {
            edge.j = edge3.target();
        }
        this.b(edge, edge.source(), edge2, edge.target(), edge3, n, n);
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 9, edge));
        }
    }

    public void changeEdge(Edge edge, Node node, Node node2) {
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 8, edge));
        }
        Node node3 = edge.source();
        Node node4 = edge.target();
        if (edge.getGraph() == null) {
            edge.h = node;
            edge.j = node2;
        } else {
            if (node3 != node) {
                node3.a(edge, 0, 0);
                edge.h = node;
                node.a(edge, null, 0, 0, 0);
            }
            if (node4 != node2) {
                node4.a(edge, 1, 1);
                edge.j = node2;
                node2.a(edge, null, 1, 1, 0);
            }
        }
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 9, edge));
        }
    }

    public void reverseEdge(Edge edge) {
        this.changeEdge(edge, edge.target(), edge.source());
    }

    public void hide(Edge edge) {
        Vector vector = this.listeners;
        this.listeners = null;
        this.a(edge);
        this.listeners = vector;
    }

    public void unhide(Edge edge) {
        Vector vector = this.listeners;
        this.listeners = null;
        this.reInsertEdge(edge);
        this.listeners = vector;
    }

    public void hide(Node node) {
        Vector vector = this.listeners;
        this.listeners = null;
        this.removeNode(node);
        this.listeners = vector;
    }

    public void unhide(Node node) {
        Vector vector = this.listeners;
        this.listeners = null;
        this.reInsertNode(node);
        this.listeners = vector;
    }

    public void moveToLast(Node node) {
        this.v.a(node);
        this.v.d(node);
        this.y = true;
    }

    public void moveToFirst(Node node) {
        this.v.a(node);
        this.v.a(node, this.v.c(), 1);
        this.y = true;
    }

    public void moveToLast(Edge edge) {
        this.x.a(edge);
        this.x.d(edge);
        this.u = true;
    }

    public void moveToFirst(Edge edge) {
        this.x.a(edge);
        this.x.a(edge, this.x.c(), 1);
        this.u = true;
    }

    public int N() {
        return this.v.f();
    }

    public int nodeCount() {
        return this.v.f();
    }

    public int E() {
        return this.x.f();
    }

    public int edgeCount() {
        return this.x.f();
    }

    public boolean isEmpty() {
        return this.v.e();
    }

    public void clear() {
        this.firePreEvent();
        while (!this.v.e()) {
            this.removeNode((Node)this.v.a());
        }
        this.firePostEvent();
    }

    public boolean contains(Node node) {
        return node.getGraph() == this;
    }

    public boolean contains(Edge edge) {
        return edge.getGraph() == this;
    }

    public boolean containsEdge(Node node, Node node2) {
        return node.getEdgeTo(node2) != null;
    }

    public Node firstNode() {
        return (Node)this.v.a();
    }

    public Edge firstEdge() {
        return (Edge)this.x.a();
    }

    public Node lastNode() {
        return (Node)this.v.b();
    }

    public Edge lastEdge() {
        return (Edge)this.x.b();
    }

    public Node[] getNodeArray() {
        Node[] nodeArray = new Node[this.nodeCount()];
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            nodeArray[nodeCursor.node().index()] = nodeCursor.node();
            nodeCursor.next();
        }
        return nodeArray;
    }

    public Edge[] getEdgeArray() {
        Edge[] edgeArray = new Edge[this.edgeCount()];
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            edgeArray[edgeCursor.edge().index()] = edgeCursor.edge();
            edgeCursor.next();
        }
        return edgeArray;
    }

    public NodeCursor nodes() {
        return this.v.h();
    }

    public EdgeCursor edges() {
        return this.x.h();
    }

    public EdgeList moveSubGraph(NodeList nodeList, Graph graph) {
        EdgeCursor edgeCursor;
        Node node;
        NodeCursor nodeCursor = nodeList.nodes();
        EdgeList edgeList = new EdgeList();
        NodeMap nodeMap = this.createNodeMap();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            nodeMap.setBool(node, true);
            nodeCursor.next();
        }
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            edgeCursor = node.edges();
            while (edgeCursor.ok()) {
                if (!nodeMap.getBool(edgeCursor.edge().opposite(node))) {
                    edgeList.addFirst(edgeCursor.edge());
                    this.removeEdge(edgeCursor.edge());
                }
                edgeCursor.next();
            }
            nodeCursor.next();
        }
        this.disposeNodeMap(nodeMap);
        nodeCursor.toFirst();
        while (nodeCursor.ok()) {
            node = nodeCursor.node();
            edgeCursor = node.outEdges();
            while (edgeCursor.ok()) {
                this.x.a(edgeCursor.edge());
                edgeCursor.edge().a(graph);
                graph.x.d(edgeCursor.edge());
                edgeCursor.next();
            }
            this.v.a(node);
            node.b(graph);
            graph.v.d(node);
            nodeCursor.next();
        }
        if (this.listeners != null) {
            this.fireGraphEvent(new GraphEvent(this, 11, nodeList));
        }
        if (graph.listeners != null) {
            graph.fireGraphEvent(new GraphEvent(graph, 10, nodeList));
        }
        this.u = true;
        this.y = true;
        graph.y = true;
        graph.u = true;
        return edgeList;
    }

    public Graph createGraph() {
        return new Graph();
    }

    public void sortEdges(Comparator comparator, Comparator comparator2) {
        block4: {
            Edge[] edgeArray;
            block5: {
                block3: {
                    edgeArray = new Edge[this.E()];
                    if (comparator == null || comparator2 == null) break block3;
                    NodeCursor nodeCursor = this.nodes();
                    while (nodeCursor.ok()) {
                        nodeCursor.node().a(comparator, 1, edgeArray);
                        nodeCursor.node().a(comparator2, 0, edgeArray);
                        nodeCursor.next();
                    }
                    break block4;
                }
                if (comparator2 != null || comparator == null) break block5;
                NodeCursor nodeCursor = this.nodes();
                while (nodeCursor.ok()) {
                    nodeCursor.node().a(comparator, 1, edgeArray);
                    nodeCursor.next();
                }
                break block4;
            }
            if (comparator2 == null || comparator != null) break block4;
            NodeCursor nodeCursor = this.nodes();
            while (nodeCursor.ok()) {
                nodeCursor.node().a(comparator2, 0, edgeArray);
                nodeCursor.next();
            }
        }
    }

    public void addGraphListener(GraphListener graphListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(graphListener);
        }
        if (this.listeners.size() == 0) {
            this.listeners = null;
        }
    }

    public Iterator getGraphListeners() {
        if (this.listeners == null) {
            return new Vector(1).iterator();
        }
        return this.listeners.iterator();
    }

    public void firePreEvent() {
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.b(this));
        }
    }

    public void firePostEvent() {
        if (this.listeners != null) {
            this.fireGraphEvent(GraphEvent.a(this));
        }
    }

    protected void fireGraphEvent(GraphEvent graphEvent) {
        if (this.listeners != null) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((GraphListener)this.listeners.elementAt(n)).onGraphEvent(graphEvent);
                ++n;
            }
        }
    }

    public NodeMap createNodeMap() {
        return this.z.b(this.v, "ANONYMOUS");
    }

    public EdgeMap createEdgeMap() {
        return this.w.a(this.x, "ANONYMOUS");
    }

    public void disposeNodeMap(NodeMap nodeMap) {
        this.z.a(nodeMap, this.v);
    }

    public void disposeEdgeMap(EdgeMap edgeMap) {
        this.w.a(edgeMap, this.x);
    }

    public NodeMap[] getRegisteredNodeMaps() {
        return this.z.b();
    }

    public EdgeMap[] getRegisteredEdgeMaps() {
        return this.w.c();
    }

    public Object getSource(Object object) {
        return ((Edge)object).source();
    }

    public Object getTarget(Object object) {
        return ((Edge)object).target();
    }

    public Iterator nodeObjects() {
        return Cursors.createIterator(this.nodes());
    }

    public Iterator edgeObjects() {
        return Cursors.createIterator(this.edges());
    }

    public DataProvider getDataProvider(Object object) {
        return (DataProvider)this.t.get(object);
    }

    public void addDataProvider(Object object, DataProvider dataProvider) {
        this.t.put(object, dataProvider);
    }

    public void removeDataProvider(Object object) {
        this.t.remove(object);
    }

    public Object[] getDataProviderKeys() {
        Object[] objectArray = new Object[this.t.size()];
        int n = 0;
        Enumeration enumeration = this.t.keys();
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = enumeration.nextElement();
        }
        return objectArray;
    }

    protected static final Edge firstOutEdge(Node node) {
        return node.o[1];
    }

    static final Edge a(Node node, int n) {
        return node.q[n];
    }

    static final Edge b(Edge edge, int n) {
        return edge.k[n];
    }

    static final Edge a(Edge edge, int n) {
        return edge.f[n];
    }

    Edge b(Edge edge, Node node) {
        return Graph.b(edge, edge.a(node) ? 0 : 1);
    }

    Edge a(Edge edge, Node node) {
        return Graph.a(edge, edge.a(node) ? 0 : 1);
    }

    private void b(Edge edge, Node node, Edge edge2, Node node2, Edge edge3, int n, int n2) {
        node.a(edge, edge2, 0, 0, n);
        node2.a(edge, edge3, 1, 1, n2);
    }

    private void a(Edge edge, Node node, Node node2) {
        node.a(edge, 0, 0);
        node2.a(edge, 1, 1);
    }

    void c() {
        int n = 0;
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            nodeCursor.node().p = n++;
            nodeCursor.next();
        }
        this.y = false;
    }

    void b() {
        int n = 0;
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            edgeCursor.edge().e = n++;
            edgeCursor.next();
        }
        this.u = false;
    }

    void a(Node node) {
        node.a(this, this.z.b);
        node.p = this.v.f();
        this.v.d(node);
    }

    void a(Edge edge, Node node, Edge edge2, Node node2, Edge edge3, int n, int n2) {
        edge.a(this, node, node2, this.w.b);
        edge.e = this.x.f();
        this.x.d(edge);
        this.b(edge, edge.source(), edge2, edge.target(), edge3, n, n2);
    }

    public void printNodeSlotSize() {
        System.out.println("Nodes slot size: " + this.z.b);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("nodes #" + this.nodeCount() + " [");
        NodeCursor nodeCursor = this.nodes();
        while (nodeCursor.ok()) {
            stringBuffer.append(nodeCursor.node().toString());
            nodeCursor.next();
            if (!nodeCursor.ok()) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append("]\nedges #" + this.edgeCount() + " [");
        EdgeCursor edgeCursor = this.edges();
        while (edgeCursor.ok()) {
            stringBuffer.append(edgeCursor.edge().toString());
            edgeCursor.next();
            if (!edgeCursor.ok()) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static {
        new D();
    }
}

