/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.jni;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

public class JacobUtil {
    public static void callInternetExplorer(String url) throws Exception {
        ActiveXComponent internetExplorer = null;
        try {
            internetExplorer = new ActiveXComponent("InternetExplorer.Application");
            internetExplorer.setProperty("Visible", new Variant(true));
            internetExplorer.setProperty("AddressBar", new Variant(true));
            internetExplorer.setProperty("StatusText", new Variant((Object)"Nepxion"));
            Dispatch.call((Dispatch)internetExplorer.getObject(), (String)"Navigate", (Object)new Variant((Object)url));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (internetExplorer != null) {
                internetExplorer = null;
            }
            ComThread.Release();
        }
    }

    public static void callWord(String filePath, boolean readOnly) throws Exception {
        ActiveXComponent word = null;
        try {
            word = new ActiveXComponent("Word.Application");
            word.setProperty("Visible", new Variant(true));
            Dispatch documents = word.getProperty("Documents").toDispatch();
            Dispatch.invoke((Dispatch)documents, (String)"Open", (int)1, (Object[])new Object[]{filePath, new Variant(true), new Variant(readOnly)}, (int[])new int[1]).toDispatch();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (word != null) {
                word = null;
            }
            ComThread.Release();
        }
    }

    public static void callExcel(String filePath, boolean readOnly) throws Exception {
        ActiveXComponent excel = null;
        try {
            excel = new ActiveXComponent("Excel.Application");
            excel.setProperty("Visible", new Variant(true));
            Dispatch workbooks = excel.getProperty("Workbooks").toDispatch();
            Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{filePath, new Variant(true), new Variant(readOnly)}, (int[])new int[1]).toDispatch();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (excel != null) {
                excel = null;
            }
            ComThread.Release();
        }
    }

    public static void callPowerPoint(String filePath, boolean readOnly, boolean fullScreen) throws Exception {
        ActiveXComponent powerPoint = null;
        try {
            powerPoint = new ActiveXComponent("PowerPoint.Application");
            powerPoint.setProperty("Visible", new Variant(true));
            ActiveXComponent presentations = powerPoint.getPropertyAsComponent("Presentations");
            ActiveXComponent presentation = presentations.invokeGetComponent("Open", new Variant((Object)filePath), new Variant(readOnly));
            if (fullScreen) {
                ActiveXComponent slideShowSettings = presentation.getPropertyAsComponent("SlideShowSettings");
                slideShowSettings.invoke("Run");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (powerPoint != null) {
                powerPoint = null;
            }
            ComThread.Release();
        }
    }

    public static void transformWordToHtml(String wordFilePath, String htmlFilePath) throws Exception {
        ActiveXComponent word = null;
        try {
            word = new ActiveXComponent("Word.Application");
            word.setProperty("Visible", new Variant(false));
            Dispatch documents = word.getProperty("Documents").toDispatch();
            Dispatch document = Dispatch.invoke((Dispatch)documents, (String)"Open", (int)1, (Object[])new Object[]{wordFilePath, new Variant(true), new Variant(false)}, (int[])new int[1]).toDispatch();
            Dispatch.invoke((Dispatch)document, (String)"SaveAs", (int)1, (Object[])new Object[]{htmlFilePath, new Variant(8)}, (int[])new int[1]);
            Dispatch.call((Dispatch)document, (String)"Close", (Object)new Variant(false));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (word != null) {
                word.invoke("Quit", new Variant[0]);
                word = null;
            }
            ComThread.Release();
        }
    }

    public static void transformExcelToHtml(String excelFilePath, String htmlFilePath) throws Exception {
        ActiveXComponent excel = null;
        try {
            excel = new ActiveXComponent("Excel.Application");
            excel.setProperty("Visible", new Variant(false));
            Dispatch workbooks = excel.getProperty("Workbooks").toDispatch();
            Dispatch workbook = Dispatch.invoke((Dispatch)workbooks, (String)"Open", (int)1, (Object[])new Object[]{excelFilePath, new Variant(true), new Variant(false)}, (int[])new int[1]).toDispatch();
            Dispatch.invoke((Dispatch)workbook, (String)"SaveAs", (int)1, (Object[])new Object[]{htmlFilePath, new Variant(44)}, (int[])new int[1]);
            Dispatch.call((Dispatch)workbook, (String)"Close", (Object)new Variant(false));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (excel != null) {
                excel.invoke("Quit", new Variant[0]);
                excel = null;
            }
            ComThread.Release();
        }
    }
}

