/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.dialog;

import com.nepxion.swing.button.JClassicButton;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.dialog.JBasicDialog;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.font.FontContext;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.label.JBasicLabel;
import com.nepxion.swing.layout.filed.FiledLayout;
import com.nepxion.swing.layout.table.TableLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.renderer.combobox.ElementComboBoxCellRenderer;
import com.nepxion.swing.separator.JBasicSeparator;
import com.nepxion.swing.textfield.JBasicPasswordField;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.util.locale.LocaleConstants;
import com.nepxion.util.locale.LocaleContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class JLoginDialog
extends JBasicDialog {
    public static final int FONT_SIZE = 12;
    public static final int FONT_STYLE = 0;
    public static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder(Color.white, Color.gray);
    protected JBasicLabel imageLabel;
    protected JBasicLabel accountLabel = new JBasicLabel();
    protected JBasicTextField accountTextField;
    protected JBasicLabel passwordLabel;
    protected JBasicPasswordField passwordField;
    protected JBasicLabel localeLabel;
    protected JBasicComboBox localeComboBox;
    protected JClassicButton loginButton;
    protected JClassicButton resetButton;
    protected JClassicButton exitButton;
    protected JPanel contentPanel;
    protected JPanel editorPanel;
    protected JPanel buttonPanel;
    protected JBasicSeparator separator;

    public JLoginDialog() {
        this((Frame)null);
    }

    public JLoginDialog(Frame owner) {
        this(owner, IconFactory.getSwingIcon("banner/logo.png"));
    }

    public JLoginDialog(Frame owner, Icon icon) {
        super(owner, SwingLocale.getString("login"));
        this.accountLabel.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.accountTextField = new JBasicTextField();
        this.passwordLabel = new JBasicLabel();
        this.passwordLabel.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.passwordField = new JBasicPasswordField();
        this.localeLabel = new JBasicLabel();
        this.localeLabel.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.localeComboBox = new JBasicComboBox();
        this.localeComboBox.setRenderer(new ElementComboBoxCellRenderer());
        this.localeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = JLoginDialog.this.localeComboBox.getSelectedIndex();
                Locale locale = JLoginDialog.this.getSelectedLocale();
                JLoginDialog.this.initLocale(locale);
                JLoginDialog.this.localeComboBox.setSelectedIndex(selectedIndex);
            }
        });
        this.initEditorPanelLayout();
        this.loginButton = new JClassicButton();
        this.loginButton.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.loginButton.setPreferredSize(new Dimension(72, 32));
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String account = JLoginDialog.this.accountTextField.getText().trim();
                String password = JLoginDialog.this.passwordField.getPasswordText().trim();
                Locale locale = JLoginDialog.this.getSelectedLocale();
                if (account.equals("") || password.equals("")) {
                    JBasicOptionPane.showMessageDialog(JLoginDialog.this, SwingLocale.getString("login_not_null", locale), SwingLocale.getString("warning", locale), 2);
                    return;
                }
                boolean flag = true;
                try {
                    flag = JLoginDialog.this.login(account, password, locale);
                }
                catch (Exception ex) {
                    ExceptionTracer.traceException(JLoginDialog.this, SwingLocale.getString("login_failure_service", locale), ex);
                    return;
                }
                if (flag) {
                    JLoginDialog.this.setVisible(false);
                } else {
                    JBasicOptionPane.showMessageDialog(JLoginDialog.this, SwingLocale.getString("login_failure_validation", locale), SwingLocale.getString("warning", locale), 2);
                }
            }
        });
        this.getRootPane().setDefaultButton(this.loginButton);
        this.resetButton = new JClassicButton();
        this.resetButton.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.resetButton.setPreferredSize(new Dimension(72, 32));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLoginDialog.this.accountTextField.setText("");
                JLoginDialog.this.passwordField.setText("");
            }
        });
        this.exitButton = new JClassicButton();
        this.exitButton.setFont(new Font(FontContext.getFontName(), 0, 12));
        this.exitButton.setPreferredSize(new Dimension(72, 32));
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JLoginDialog.this.destroy();
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.loginButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.resetButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.exitButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.separator = new JBasicSeparator(0, "LoweredStyle", 280);
        this.imageLabel = new JBasicLabel(icon, 2);
        this.imageLabel.setBorder(ETCHED_BORDER);
        this.initContentPanel();
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(20, 0));
        container.setBorder(BorderFactory.createCompoundBorder(ETCHED_BORDER, BorderFactory.createEmptyBorder(20, 20, 20, 20)));
        container.add((Component)this.imageLabel, "West");
        container.add((Component)this.contentPanel, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)container, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvent) {
                JLoginDialog.this.destroy();
            }
        });
        this.setResizable(false);
        this.pack();
        Locale locale = LocaleContext.getLocale();
        this.initLocale(locale);
        this.setSelectedLocale(locale);
    }

    protected void initEditorPanelLayout() {
        double[][] size = new double[][]{{80.0, 180.0}, {-2.0, -2.0, -2.0}};
        TableLayout tableLayout = new TableLayout(size);
        tableLayout.setVGap(10);
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(tableLayout);
        this.editorPanel.add((Component)this.accountLabel, "0, 0");
        this.editorPanel.add((Component)this.accountTextField, "1, 0");
        this.editorPanel.add((Component)this.passwordLabel, "0, 1");
        this.editorPanel.add((Component)this.passwordField, "1, 1");
        this.editorPanel.add((Component)this.localeLabel, "0, 2");
        this.editorPanel.add((Component)this.localeComboBox, "1, 2");
    }

    protected void initContentPanel() {
        int margin = (this.imageLabel.getPreferredSize().height - this.buttonPanel.getPreferredSize().height - this.separator.getPreferredSize().height - this.editorPanel.getPreferredSize().height) / 4;
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(ETCHED_BORDER, BorderFactory.createEmptyBorder(margin, 20, margin, 20)));
        this.contentPanel.setLayout(new FiledLayout(0, 1, margin));
        this.contentPanel.add(this.editorPanel);
        this.contentPanel.add(this.separator);
        this.contentPanel.add(this.buttonPanel);
        int indent = this.contentPanel.getPreferredSize().height - this.imageLabel.getPreferredSize().height;
        if (indent > 0) {
            int totalFixedMargin = margin * 2 - indent;
            int fixedMargin = totalFixedMargin / 2;
            this.contentPanel.setBorder(BorderFactory.createCompoundBorder(ETCHED_BORDER, BorderFactory.createEmptyBorder(fixedMargin, 20, totalFixedMargin - fixedMargin, 20)));
        }
    }

    protected void initLocale(Locale locale) {
        this.setTitle(SwingLocale.getString("login", locale));
        this.accountLabel.setText(SwingLocale.getString("account", locale));
        this.passwordLabel.setText(SwingLocale.getString("password", locale));
        this.localeLabel.setText(SwingLocale.getString("language", locale));
        Locale[] locales = LocaleConstants.LOCALE_LIST;
        ElementNode[] elementNodes = new ElementNode[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            Locale localeEntity = locales[i];
            String localeName = localeEntity.toString().toLowerCase();
            String text = SwingLocale.getString(localeName, locale);
            ImageIcon icon = IconFactory.getSwingIcon("flag_" + localeName + ".png");
            elementNodes[i] = new ElementNode(text, (Icon)icon, text, localeEntity);
        }
        this.localeComboBox.setModel(new DefaultComboBoxModel<ElementNode>(elementNodes));
        this.loginButton.setText(SwingLocale.getString("login", locale));
        this.loginButton.setToolTipText(SwingLocale.getString("login", locale));
        this.resetButton.setText(SwingLocale.getString("reset", locale));
        this.resetButton.setToolTipText(SwingLocale.getString("reset", locale));
        this.exitButton.setText(SwingLocale.getString("exit", locale));
        this.exitButton.setToolTipText(SwingLocale.getString("exit", locale));
    }

    public String getAccount() {
        return this.accountTextField.getText().trim();
    }

    public void setAccount(String account) {
        this.accountTextField.setText(account.trim());
    }

    public String getPassword() {
        return this.passwordField.getPasswordText().trim();
    }

    public void setPassword(String password) {
        this.passwordField.setText(password.trim());
    }

    public void setLoginFocus() {
        this.loginButton.requestFocus();
    }

    public JBasicTextField getAccountTextField() {
        return this.accountTextField;
    }

    public JBasicPasswordField getPasswordField() {
        return this.passwordField;
    }

    public JBasicComboBox getLocaleComboBox() {
        return this.localeComboBox;
    }

    public Locale getSelectedLocale() {
        ElementNode selectedElementNode = (ElementNode)this.localeComboBox.getSelectedItem();
        Locale locale = (Locale)selectedElementNode.getUserObject();
        return locale;
    }

    public void setSelectedLocale(Locale locale) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.localeComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ElementNode elementNode = (ElementNode)model.getElementAt(i);
            Locale localeEntity = (Locale)elementNode.getUserObject();
            if (!localeEntity.equals(locale)) continue;
            this.localeComboBox.setSelectedItem(elementNode);
            break;
        }
    }

    public JClassicButton getLoginButton() {
        return this.loginButton;
    }

    public JClassicButton getResetButton() {
        return this.resetButton;
    }

    public JClassicButton getExitButton() {
        return this.exitButton;
    }

    public void destroy() {
        System.exit(0);
    }

    public abstract boolean login(String var1, String var2, Locale var3) throws Exception;
}

