/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import y.io.gml.GMLEncoder;
import y.util.D;

public class GMLTokenizer {
    private Callback a;
    protected static final int OPEN = 0;
    protected static final int CLOSE = 1;
    protected static final int AMPERSAND = 2;
    protected static final int QUOTE = 3;
    protected static final int WHITESPACE = 4;
    protected static final int LETTER = 5;
    protected static final int DIGIT = 6;
    protected static final int EOF = 7;
    protected static final int NEWLINE = 8;
    protected static final int COMMENT = 9;
    protected static final int UNKNOWN = -1;

    public GMLTokenizer() {
        this(null);
    }

    public GMLTokenizer(Callback callback) {
        this.setCallback(callback);
    }

    public void parse(Reader reader) throws IOException {
        PushbackReader pushbackReader = new PushbackReader(reader);
        this.parse(pushbackReader);
    }

    protected int lookAhead(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if (n == -1) {
            return 7;
        }
        pushbackReader.unread(n);
        return this.classify((char)n);
    }

    protected void parse(PushbackReader pushbackReader) throws IOException {
        int n = this.lookAhead(pushbackReader);
        while (n == 9) {
            this.parseComment(pushbackReader);
            n = this.lookAhead(pushbackReader);
        }
        while (n != 7) {
            if (n == 4 || n == 8) {
                this.parseWhiteSpace(pushbackReader);
            }
            if ((n = this.lookAhead(pushbackReader)) == 5) {
                String string = this.parseKey(pushbackReader);
                this.parseWhiteSpace(pushbackReader);
                n = this.lookAhead(pushbackReader);
                if (n == 0) {
                    this.a.beginScope(string);
                    pushbackReader.read();
                    this.parse(pushbackReader);
                    this.a.endScope(string);
                } else {
                    Object object = this.parseValue(pushbackReader);
                    if (object instanceof String) {
                        this.a.attribute(string, (String)object);
                    } else if (object instanceof Number) {
                        this.a.attribute(string, (Number)object);
                    }
                }
                n = this.lookAhead(pushbackReader);
            }
            if (n != 1) continue;
            pushbackReader.read();
            return;
        }
    }

    protected int classify(char c2) {
        switch (c2) {
            case '[': {
                return 0;
            }
            case ']': {
                return 1;
            }
            case '&': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '#': {
                return 9;
            }
            case '+': 
            case '-': 
            case '.': {
                return 6;
            }
            case '\n': 
            case '\f': 
            case '\r': {
                return 8;
            }
        }
        if (Character.isWhitespace(c2)) {
            return 4;
        }
        if (Character.isDigit(c2)) {
            return 6;
        }
        if (Character.isLetter(c2)) {
            return 5;
        }
        return -1;
    }

    protected void parseWhiteSpace(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        while (n != -1) {
            int n2 = this.classify((char)n);
            if (n2 == 4) {
                n = pushbackReader.read();
                continue;
            }
            if (n2 == 8) {
                while (n2 == 8) {
                    n = pushbackReader.read();
                    n2 = this.classify((char)n);
                }
                if (n2 == 9) {
                    pushbackReader.unread(n);
                    this.parseComment(pushbackReader);
                    n = pushbackReader.read();
                    continue;
                }
            }
            if (n2 != 4) break;
        }
        if (n != -1) {
            pushbackReader.unread(n);
        }
    }

    protected void parseComment(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if ((char)n != '#') {
            throw new IOException("ParseException: expected # but found: " + n);
        }
        n = pushbackReader.read();
        int n2 = this.classify((char)n);
        while (n2 != 8 && n2 != 7) {
            n = pushbackReader.read();
            n2 = this.classify((char)n);
        }
        pushbackReader.unread(n);
    }

    protected String parseKey(PushbackReader pushbackReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(20);
        int n = pushbackReader.read();
        while (n != -1 && !Character.isWhitespace((char)n)) {
            stringBuffer.append((char)n);
            n = pushbackReader.read();
        }
        if (n != -1) {
            pushbackReader.unread(n);
        }
        return stringBuffer.toString();
    }

    protected Object parseValue(PushbackReader pushbackReader) throws IOException {
        int n = this.lookAhead(pushbackReader);
        if (n == 3) {
            return this.parseString(pushbackReader);
        }
        if (n == 0) {
            return this.parseList(pushbackReader);
        }
        if (n == 6) {
            return this.parseNumber(pushbackReader);
        }
        throw new IOException("ParseException, did not find QUOTE, OPEN or DIGIT but " + pushbackReader.read());
    }

    protected Number parseNumber(PushbackReader pushbackReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(10);
        int n = pushbackReader.read();
        boolean bl = true;
        while (!Character.isWhitespace((char)n)) {
            if (bl) {
                switch (n) {
                    case 43: 
                    case 46: 
                    case 69: 
                    case 101: {
                        bl = false;
                    }
                }
            }
            stringBuffer.append((char)n);
            n = pushbackReader.read();
        }
        pushbackReader.unread(n);
        if (bl) {
            return new Integer(stringBuffer.toString());
        }
        return new Double(stringBuffer.toString());
    }

    protected String parseString(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if ((char)n != '\"') {
            throw new IOException("Expected \" but found " + n);
        }
        String string = this.parseInString(pushbackReader);
        n = pushbackReader.read();
        if ((char)n != '\"') {
            throw new IOException("Expected \" but found " + n);
        }
        return string;
    }

    protected String parseInString(PushbackReader pushbackReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(20);
        int n = pushbackReader.read();
        while ((char)n != '\"' && n != -1) {
            if ((char)n == '&') {
                pushbackReader.unread(n);
                n = this.parseEntity(pushbackReader);
            }
            stringBuffer.append((char)n);
            n = pushbackReader.read();
        }
        pushbackReader.unread(n);
        return stringBuffer.toString();
    }

    protected char parseEntity(PushbackReader pushbackReader) throws IOException {
        int n = pushbackReader.read();
        if ((char)n != '&') {
            throw new IOException("Expected & but found " + n);
        }
        n = pushbackReader.read();
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((char)n != ';' && n != -1) {
            stringBuffer.append((char)n);
            n = pushbackReader.read();
        }
        String string = stringBuffer.toString();
        if (string.equals("#13")) {
            return '\n';
        }
        if (string.equals("para")) {
            return '\n';
        }
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        return '?';
    }

    protected List parseList(PushbackReader pushbackReader) throws IOException {
        return new ArrayList(0);
    }

    public Callback getCallback() {
        return this.a;
    }

    public void setCallback(Callback callback) {
        this.a = callback;
    }

    public static final class EncoderCallback
    implements Callback {
        private GMLEncoder a;

        public EncoderCallback(GMLEncoder gMLEncoder) {
            this.a = gMLEncoder;
        }

        public void beginScope(String string) {
            try {
                this.a.beginSection(string);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void endScope(String string) {
            try {
                this.a.endSection();
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string, String string2) {
            try {
                this.a.addAttribute(string, string2);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string, Number number) {
            try {
                this.a.addAttribute(string, number);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }
    }

    public static final class DebugCallback
    implements Callback {
        public void beginScope(String string) {
            System.out.println("begin scope " + string);
        }

        public void endScope(String string) {
            System.out.println("end scope " + string);
        }

        public void attribute(String string, String string2) {
            System.out.println("string attribute " + string + " => " + string2);
        }

        public void attribute(String string, Number number) {
            System.out.println("Number attribute " + string + " => " + number);
        }
    }

    public static interface Callback {
        public void beginScope(String var1);

        public void endScope(String var1);

        public void attribute(String var1, String var2);

        public void attribute(String var1, Number var2);
    }
}

