/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.cots.twaver.graph;

import com.nepxion.cots.twaver.element.TDataBoxPropertyChangeAdapter;
import com.nepxion.cots.twaver.element.TGroup;
import com.nepxion.cots.twaver.element.TNode;
import com.nepxion.cots.twaver.element.TType;
import com.nepxion.cots.twaver.graph.TExportDataConfig;
import com.nepxion.cots.twaver.graph.TExportImageConfig;
import com.nepxion.cots.twaver.graph.TGraphAdapter;
import com.nepxion.cots.twaver.graph.TGraphBackground;
import com.nepxion.cots.twaver.graph.TGraphManager;
import com.nepxion.cots.twaver.graph.TGraphToolBar;
import com.nepxion.cots.twaver.graph.TInternalFrame;
import com.nepxion.cots.twaver.graph.TLabelConfig;
import com.nepxion.cots.twaver.graph.TOverview;
import com.nepxion.cots.twaver.icon.TIconFactory;
import com.nepxion.swing.action.JSecurityAction;
import com.nepxion.swing.selector.file.JFileSelector;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionListener;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.TWaverUtil;
import twaver.network.TNetwork;
import twaver.network.background.Background;

public class TGraph
extends TNetwork {
    public static final Cursor PAN_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(TIconFactory.getContextIcon("pan_cursor.png").getImage(), new Point(0, 0), "Pan");
    public static final Cursor ZOOM_IN_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(TIconFactory.getContextIcon("zoom_in_cursor.png").getImage(), new Point(0, 0), "ZoomIn");
    public static final Cursor ZOOM_OUT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(TIconFactory.getContextIcon("zoom_out_cursor.png").getImage(), new Point(0, 0), "ZoomOut");
    public static final Cursor ZOOM_IN_RECTANGLE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(TIconFactory.getContextIcon("zoom_in_rectangle_cursor.png").getImage(), new Point(0, 0), "ZoomInRectangle");
    private TGraphBackground background;
    private TOverview overview;
    private JFileSelector importDataFileSelector;
    private TExportDataConfig exportDataConfig;
    private JFileSelector exportDataFileSelector;
    private JFileSelector svgFileSelector;
    private TExportImageConfig exportImageConfig;
    private JFileSelector imageFileSelector;
    private TLabelConfig labelConfig;
    private TInternalFrame controlBarInternalFrame;
    private TInternalFrame layoutInternalFrame;
    private TInternalFrame scaleInternalFrame;
    private TGraphAdapter adapter;
    private TType type;
    private Object dndObject;

    public TGraph() {
        this(new TDataBox());
    }

    public TGraph(TDataBox dataBox) {
        this(dataBox, null);
    }

    public TGraph(TType type) {
        this(new TDataBox(), type);
    }

    public TGraph(TDataBox dataBox, TType type) {
        super(dataBox);
        this.type = type;
        this.initServiceStyle();
        this.initComponents();
        this.initListeners();
    }

    private void initServiceStyle() {
        this.getViewport().setBackground(Color.white);
        this.setEnableDeleteWithKeyboard(false);
        this.setEnableCopyPasteWithKeyboard(false);
        this.setEnableUndoRedoWithKeyboard(false);
        this.setEnsureVisibleOnSelected(true);
        this.setElementTransparentAreaSelectable(true);
        TGraphManager.setResizableFilter(this, true);
        TUIManager.registerDefault((String)"label.selectable", (Object)Boolean.TRUE);
        TUIManager.registerDefault((String)"label.highlightable", (Object)Boolean.TRUE);
        TUIManager.registerDefault((String)"border.type", (Object)TWaverUtil.valueOf((int)2));
        TUIManager.registerDefault((String)"border.stroke", (Object)"solid.thinnest");
        TUIManager.registerDefault((String)"border.insets", (Object)TWaverUtil.valueOf((int)4));
        TUIManager.registerDefault((String)"border.fill", (Object)Boolean.TRUE);
        TGraphManager.setElementSelectColorGenerator(this, new Color(125, 125, 125), new Color(0, 0, 0, 0));
        TUIManager.registerDefault((String)"border.fill.color", (Object)Color.red);
        TGraphManager.setMagnifierShape(this, new Rectangle(0, 0, 160, 160));
        TUIManager.registerDefault((String)"link.color", (Object)new Color(220, 222, 224));
        TUIManager.registerDefault((String)"link.width", (Object)TWaverUtil.valueOf((int)3));
        TUIManager.registerDefault((String)"link.outline.width", (Object)TWaverUtil.valueOf((int)1));
        TUIManager.registerPredefinedPropertyCopied((String)"userObject", (boolean)false);
    }

    private void initComponents() {
        new TGraphToolBar(this);
    }

    private void initListeners() {
        TGraphManager.addLinkSelectionListener(this, Color.red);
        TGraphManager.addVisibleFilter(this);
        new TDataBoxPropertyChangeAdapter(this.getDataBox());
        TGraphManager.addCanvasAdjustListener(this);
    }

    public void setDataBox(TDataBox dataBox) {
        TDataBox oldDataBox = this.getDataBox();
        super.setDataBox(dataBox);
        TDataBox newDataBox = this.getDataBox();
        TGraphManager.fireDataBoxChangeEvent(oldDataBox, newDataBox);
        TGraphManager.fireElementPropertyChangeEvent(oldDataBox, newDataBox);
        super.setName(newDataBox.getName());
    }

    public boolean isMovable(Element element) {
        TGroup group;
        TNode node;
        if (element instanceof TNode && !(node = (TNode)element).isMovable()) {
            return false;
        }
        if (element instanceof TGroup && !(group = (TGroup)element).isMovable()) {
            return false;
        }
        return super.isMovable(element);
    }

    public void registerKeyboardAction(JSecurityAction action, int keyCode, int modifiers) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        action.putValue("AcceleratorKey", (Object)keyStroke);
        this.getCanvas().registerKeyboardAction((ActionListener)action, keyStroke, 1);
    }

    public TGraphBackground getGraphBackground() {
        return this.background;
    }

    public void setGraphBackground(TGraphBackground background) {
        super.setBackground((Background)background);
        this.background = background;
    }

    public TOverview getOverview() {
        return this.overview;
    }

    public void setOverview(TOverview overview) {
        this.overview = overview;
    }

    public JFileSelector getImportDataFileSelector() {
        return this.importDataFileSelector;
    }

    public void setImportDataFileSelector(JFileSelector importDataFileSelector) {
        this.importDataFileSelector = importDataFileSelector;
    }

    public TExportDataConfig getExportDataConfig() {
        return this.exportDataConfig;
    }

    public void setExportDataConfig(TExportDataConfig exportDataConfig) {
        this.exportDataConfig = exportDataConfig;
    }

    public JFileSelector getExportDataFileSelector() {
        return this.exportDataFileSelector;
    }

    public void setExportDataFileSelector(JFileSelector exportDataFileSelector) {
        this.exportDataFileSelector = exportDataFileSelector;
    }

    public TExportImageConfig getExportImageConfig() {
        return this.exportImageConfig;
    }

    public void setExportImageConfig(TExportImageConfig exportImageConfig) {
        this.exportImageConfig = exportImageConfig;
    }

    public JFileSelector getSVGFileSelector() {
        return this.svgFileSelector;
    }

    public void setSVGFileSelector(JFileSelector svgFileSelector) {
        this.svgFileSelector = svgFileSelector;
    }

    public JFileSelector getImageFileSelector() {
        return this.imageFileSelector;
    }

    public void setImageFileSelector(JFileSelector imageFileSelector) {
        this.imageFileSelector = imageFileSelector;
    }

    public TLabelConfig getLabelConfig() {
        return this.labelConfig;
    }

    public void setLabelConfig(TLabelConfig labelConfig) {
        this.labelConfig = labelConfig;
    }

    public TInternalFrame getControlBarInternalFrame() {
        return this.controlBarInternalFrame;
    }

    public void setControlBarInternalFrame(TInternalFrame controlBarInternalFrame) {
        this.controlBarInternalFrame = controlBarInternalFrame;
    }

    public TInternalFrame getLayoutInternalFrame() {
        return this.layoutInternalFrame;
    }

    public void setLayoutInternalFrame(TInternalFrame layoutInternalFrame) {
        this.layoutInternalFrame = layoutInternalFrame;
    }

    public TInternalFrame getScaleInternalFrame() {
        return this.scaleInternalFrame;
    }

    public void setScaleInternalFrame(TInternalFrame scaleInternalFrame) {
        this.scaleInternalFrame = scaleInternalFrame;
    }

    public TType getGraphType() {
        return this.type;
    }

    public void setGraphType(TType type) {
        this.type = type;
        this.setName(type.toString());
    }

    public TGraphAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(TGraphAdapter adapter) {
        this.adapter = adapter;
    }

    public Object getDndObject() {
        return this.dndObject;
    }

    public void setDnDObject(Object dndObject) {
        this.dndObject = dndObject;
    }

    public void handleDrop(DropTargetDropEvent e, String className) {
        Element element = this.createDnDElement(this.dndObject);
        if (element != null) {
            this.dropComplete(e, element);
        }
    }

    public Element createDnDElement(Object dndObject) {
        return null;
    }

    public JViewport getViewport() {
        return this.getCanvasScrollPane().getViewport();
    }

    public void setName(String name) {
        super.setName(name);
        this.getDataBox().setName(name);
    }
}

