/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import twaver.SubNetwork;
import twaver.base.A.E.E;
import twaver.base.A.E.L;
import twaver.base.A.E.b;

public class PolySubNetwork
extends SubNetwork {
    private static final GeneralPath \u00cb = L.A(6, new Dimension(50, 50));
    private GeneralPath \u00cc = null;
    private GeneralPath \u00ca = null;

    public PolySubNetwork() {
        this.setBaseShape(\u00cb);
        this.init();
    }

    public PolySubNetwork(Object id) {
        super(id);
        this.setBaseShape(\u00cb);
        this.init();
    }

    public PolySubNetwork(Shape baseShape) {
        this.setBaseShape(baseShape);
        this.init();
    }

    public PolySubNetwork(Object id, Shape baseShape) {
        super(id);
        this.setBaseShape(baseShape);
        this.init();
    }

    public GeneralPath getBaseShape() {
        return this.\u00cc;
    }

    public void setBaseShape(Shape baseShape) {
        if (baseShape instanceof GeneralPath) {
            this.setBaseShape((GeneralPath)baseShape);
        } else {
            this.setBaseShape(new GeneralPath(baseShape));
        }
    }

    public void setBaseShape(GeneralPath baseShape) {
        if (baseShape == null) {
            throw new NullPointerException("baseShape can't be null.");
        }
        GeneralPath oldvalue = this.\u00cc;
        this.\u00cc = new GeneralPath(L.A((Shape)baseShape));
        this.firePropertyChange("baseShape", oldvalue, this.\u00cc);
        this.createTransformedShape();
    }

    protected void init() {
        this.getClientProperties().put("texture.factory", "stipple.loose");
    }

    public void setLocation(Point2D.Double location) {
        super.setLocation(location);
        this.createTransformedShape();
    }

    public String getUIClassID() {
        return "PolySubNetworkUI";
    }

    public String getSVGUIClassID() {
        return "PolySubNetworkSVGUI";
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    public Rectangle getBounds() {
        return this.getShape().getBounds();
    }

    public GeneralPath getShape() {
        return this.\u00ca;
    }

    protected void createTransformedShape() {
        AffineTransform at = AffineTransform.getTranslateInstance(this.getLocation().getX(), this.getLocation().getY());
        GeneralPath oldValue = this.\u00ca;
        this.\u00ca = new GeneralPath(at.createTransformedShape(this.\u00cc));
        this.firePropertyChange("transformedShape", oldValue, this.\u00ca);
    }

    public boolean isAdjustToBottom() {
        return E.A(this);
    }

    public void putPolyOutlineWidth(int polyOutlineWidth) {
        this.putClientProperty((Object)"poly.outline.width", polyOutlineWidth);
    }

    public void putPolyOutlineColor(Color polyOutlineColor) {
        this.putClientProperty((Object)"poly.outline.color", polyOutlineColor);
    }

    public void putPolyFill(boolean polyFill) {
        this.putClientProperty((Object)"poly.fill", polyFill);
    }

    public void putPoly3D(boolean poly3D) {
        this.putClientProperty((Object)"poly.3d", poly3D);
    }

    public int getPolyOutlineWidth() {
        return b.J(this, "poly.outline.width");
    }

    public Color getPolyOutlineColor() {
        return b.P(this, "poly.outline.color");
    }

    public boolean isPolyFill() {
        return b.K(this, "poly.fill");
    }

    public boolean isPoly3D() {
        return b.K(this, "poly.3d");
    }
}

