/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.thread.container;

import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.thread.container.AbstractSwingWorker;
import com.nepxion.swing.thread.container.AbstractThreadContainer;
import com.nepxion.swing.timer.JTimerLabel;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class JThreadContainer
extends AbstractThreadContainer {
    private SwingWorker swingWorker;
    private int delayTime = 200;
    private boolean isLoadCache = false;

    public JThreadContainer() {
        this(SwingLocale.getString("transact_and_wait"));
    }

    public JThreadContainer(String information) {
        this(new JTimerLabel("thread/magnifier/"), information);
    }

    public JThreadContainer(JLabel animationLabel, String information) {
        super(animationLabel, information);
    }

    @Override
    public void execute() {
        if (!this.isLoadCache()) {
            if (this.swingWorker == null) {
                this.swingWorker = new SwingWorker();
                this.swingWorker.execute();
            } else if (this.swingWorker.isDone()) {
                this.swingWorker = new SwingWorker();
                this.swingWorker.execute();
            }
        } else {
            this.fireHidden();
        }
    }

    @Override
    protected void fireHidden() {
        Component contentPane = this.getContentPane();
        if (contentPane != null) {
            this.addComponent(contentPane, "Center");
        }
    }

    @Override
    protected void fireCancelled() {
        if (this.swingWorker != null) {
            this.swingWorker.cancel(true);
        }
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public boolean isLoadCache() {
        return this.isLoadCache;
    }

    public void setLoadCache(boolean isLoadCache) {
        this.isLoadCache = isLoadCache;
    }

    public abstract Component getContentPane();

    protected abstract void loadForeground(Object var1) throws Exception;

    protected abstract Object loadBackground() throws Exception;

    public class SwingWorker
    extends AbstractSwingWorker {
        public SwingWorker() {
            super(JThreadContainer.this, JThreadContainer.this.delayTime);
        }

        @Override
        protected void loadForeground(final Object data) throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (data instanceof Exception) {
                        return;
                    }
                    try {
                        JThreadContainer.this.loadForeground(data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        SwingWorker.this.fireForegroundException(e);
                        Exception exception = null;
                        exception = e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
                        ExceptionTracer.traceException(HandleManager.getFrame(SwingWorker.this.getComponent()), exception);
                        return;
                    }
                    JThreadContainer.this.fireHidden();
                }
            });
        }

        @Override
        protected Object loadBackground() throws Exception {
            return JThreadContainer.this.loadBackground();
        }
    }
}

