/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.framework.ribbon;

import com.nepxion.swing.container.JContainer;
import com.nepxion.swing.exception.ExceptionTracer;
import com.nepxion.swing.framework.ribbon.IRibbonComponent;
import com.nepxion.swing.framework.ribbon.JRibbonTweenPanel;
import com.nepxion.swing.handle.HandleManager;
import com.nepxion.swing.icon.IconFactory;
import com.nepxion.swing.internalframe.InternalFrameManager;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.optionpane.JBasicOptionPane;
import com.nepxion.swing.panel.JReflectionPanel;
import com.nepxion.swing.popupmenu.JBasicPopupMenu;
import com.nepxion.swing.selector.checkbox.JCheckBoxSelector;
import com.nepxion.swing.tabbedpane.ITabbedPane;
import com.nepxion.swing.tabbedpane.JEclipseTabbedPane;
import com.nepxion.swing.tabbedpane.TabbedPaneManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;

public class JRibbonContainer
extends JContainer {
    public static final int CONTAINER_STYLE_INTERNAL_FRAME = 0;
    public static final int CONTAINER_STYLE_TABBEDPANE = 1;
    public static final int CONTAINER_STYLE_PANEL = 2;
    public static final Border INTERNAL_FRAME_BORDER = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    public static final Border ECLIPSE_TABBEDPANE_BORDER = BorderFactory.createEmptyBorder(-1, 0, 0, 0);
    public static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(2, 0, 0, 0);
    private JDesktopPane desktopPane;
    private ITabbedPane tabbedPane;
    private JRibbonTweenPanel panel;
    private JCheckBoxSelector checkBoxSelector;
    private int containerStyle = 0;
    private int maximumCount = 8;

    public JRibbonContainer() {
        this(0);
    }

    public JRibbonContainer(int containerStyle) {
        this.containerStyle = containerStyle;
        this.desktopPane = new JDesktopPane();
        this.desktopPane.setDragMode(1);
        this.setLayout(new BorderLayout());
        this.addComponent(this.desktopPane, "Center");
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JDesktopPane) {
                    JRibbonContainer.this.setBorder(INTERNAL_FRAME_BORDER);
                } else if (child instanceof JEclipseTabbedPane) {
                    JRibbonContainer.this.setBorder(ECLIPSE_TABBEDPANE_BORDER);
                } else if (child instanceof JContainer) {
                    JRibbonContainer.this.setBorder(PANEL_BORDER);
                }
            }
        });
    }

    public void addRibbonComponent(String name, String title, Icon icon, String toolTipText, IRibbonComponent component) {
        JComponent ribbonComponent = (JComponent)((Object)component);
        JComponent handler = this.retrieveRibbonComponent(ribbonComponent);
        switch (this.containerStyle) {
            case 0: {
                JInternalFrame internalFrame = null;
                if (handler == null) {
                    JInternalFrame[] internalFrames = this.desktopPane.getAllFrames();
                    if (internalFrames.length >= this.maximumCount) {
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("open_panel_count_limited") + " " + this.maximumCount + " " + SwingLocale.getString("open_panel_suffix"), SwingLocale.getString("warning"), 2);
                        return;
                    }
                    int x = 0;
                    int y = 0;
                    if (internalFrames.length != 0) {
                        x = 16 * internalFrames.length;
                        y = 35 * internalFrames.length;
                    }
                    int width = ribbonComponent.getSize().width;
                    int height = ribbonComponent.getSize().height;
                    ribbonComponent.setName(name);
                    internalFrame = new JInternalFrame(title, true, true, true, true);
                    internalFrame.setName(name);
                    internalFrame.setFrameIcon(icon);
                    internalFrame.setToolTipText(toolTipText);
                    internalFrame.setContentPane(ribbonComponent);
                    internalFrame.setSize(width != 0 ? width + 50 : 640, height != 0 ? height + 50 : 480);
                    internalFrame.setLocation(x, y);
                    internalFrame.setVisible(true);
                    this.desktopPane.add(internalFrame);
                } else {
                    internalFrame = (JInternalFrame)handler;
                }
                try {
                    internalFrame.toFront();
                    internalFrame.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                JComponent tabbedComponent = (JComponent)((Object)this.tabbedPane);
                if (tabbedComponent.getParent() == null) {
                    this.addComponent(tabbedComponent, "Center");
                }
                if (handler == null) {
                    if (this.tabbedPane.getTabCount() >= this.maximumCount) {
                        JBasicOptionPane.showMessageDialog(HandleManager.getFrame(this), SwingLocale.getString("open_panel_count_limited") + " " + this.maximumCount + " " + SwingLocale.getString("open_panel_suffix"), SwingLocale.getString("warning"), 2);
                        return;
                    }
                    this.tabbedPane.addTab(title, icon, ribbonComponent, toolTipText, true);
                    this.tabbedPane.setSelectedComponent(ribbonComponent);
                    ribbonComponent.setName(name);
                    break;
                }
                this.tabbedPane.setSelectedComponent(handler);
                break;
            }
            case 2: {
                if (this.panel.getParent() == null) {
                    this.desktopPane.add(this.panel);
                }
                if (handler != null) break;
                this.panel.setTitle(title);
                this.panel.setIcon(icon != null ? icon : IconFactory.getSwingIcon("component/internal_frame_16.png"));
                this.panel.setToolTipText(toolTipText);
                this.panel.setContentPane(ribbonComponent);
            }
        }
    }

    public void closeRibbonComponent() {
        switch (this.containerStyle) {
            case 0: {
                InternalFrameManager.showCloseDialog(this.desktopPane, this.checkBoxSelector);
                break;
            }
            case 1: {
                TabbedPaneManager.showCloseDialog(this.tabbedPane, this.checkBoxSelector);
                break;
            }
            case 2: {
                this.closePanelChildren();
            }
        }
    }

    private void closePanelChildren() {
        if (this.panel.getParent() != null && this.panel.getParent() == this.desktopPane) {
            this.desktopPane.remove(this.panel);
        }
        this.addComponent(this.desktopPane, "Center");
        this.setBorder(INTERNAL_FRAME_BORDER);
    }

    private JComponent retrieveRibbonComponent(JComponent component) {
        switch (this.containerStyle) {
            case 0: {
                JInternalFrame[] internalFrames = this.desktopPane.getAllFrames();
                for (int i = 0; i < internalFrames.length; ++i) {
                    JInternalFrame internalFrame = internalFrames[i];
                    JComponent c = (JComponent)internalFrame.getContentPane();
                    if (c != component) continue;
                    return internalFrame;
                }
                return null;
            }
            case 1: {
                if (this.tabbedPane == null) {
                    IllegalArgumentException e = new IllegalArgumentException(SwingLocale.getString("ribbon_tabbedpane_not_register"));
                    ExceptionTracer.traceException(HandleManager.getFrame(this), e);
                    throw e;
                }
                for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                    JComponent c = (JComponent)this.tabbedPane.getComponentAt(i);
                    if (c != component) continue;
                    return component;
                }
                return null;
            }
            case 2: {
                if (this.panel == null) {
                    IllegalArgumentException e = new IllegalArgumentException(SwingLocale.getString("ribbon_panel_not_register"));
                    ExceptionTracer.traceException(HandleManager.getFrame(this), e);
                    throw e;
                }
                for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                    JComponent c = (JComponent)this.panel.getComponent(i);
                    if (c != component) continue;
                    return component;
                }
                return null;
            }
        }
        return null;
    }

    public int getContainerStyle() {
        return this.containerStyle;
    }

    public void setContainerStyle(int containerStyle) {
        this.containerStyle = containerStyle;
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public void setMaximumCount(int maximumCount) {
        this.maximumCount = maximumCount;
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    public ITabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setTabbedPane(final ITabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        tabbedPane.setPopupMenu(new JBasicPopupMenu(), true);
        JComponent tabbedComponent = (JComponent)((Object)tabbedPane);
        tabbedComponent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("__index_to_remove__") && tabbedPane.getTabCount() == 0) {
                    JRibbonContainer.this.addComponent(JRibbonContainer.this.desktopPane, "Center");
                    JRibbonContainer.this.setBorder(INTERNAL_FRAME_BORDER);
                }
            }
        });
    }

    public JReflectionPanel getPanel() {
        return this.panel;
    }

    public void setPanel(final JRibbonTweenPanel panel) {
        this.panel = panel;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (JRibbonContainer.this.containerStyle == 2) {
                    Dimension desktopSize = JRibbonContainer.this.desktopPane.getSize();
                    Point desktopPoint = JRibbonContainer.this.desktopPane.getLocation();
                    Dimension panelSize = new Dimension(desktopSize.width - panel.getWidthOffset() * 2, desktopSize.height - panel.getHeightOffset() * 2);
                    panel.setSize(panelSize);
                    panel.setLocation((desktopSize.width - panelSize.width) / 2 + desktopPoint.x, (desktopSize.height - panelSize.height) / 2 + desktopPoint.y);
                }
            }
        });
    }
}

