/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.timer;

import com.nepxion.swing.timer.ITimerComponent;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class JTimerProgressBar
extends JProgressBar
implements ITimerComponent {
    private UpdateTimer updateTimer;
    private int delayTime = 30;
    private int value = 0;
    private int blockValue = 99;

    public JTimerProgressBar() {
        this.initComponents();
    }

    public JTimerProgressBar(int orient) {
        super(orient);
        this.initComponents();
    }

    public JTimerProgressBar(int min, int max) {
        super(min, max);
        this.initComponents();
    }

    public JTimerProgressBar(int min, int max, int delayTime, int blockValue) {
        this(min, max);
        this.delayTime = delayTime;
        this.blockValue = blockValue;
    }

    public JTimerProgressBar(int orient, int min, int max) {
        super(orient, min, max);
        this.initComponents();
    }

    public JTimerProgressBar(int orient, int min, int max, int delayTime, int blockValue) {
        this(orient, min, max);
        this.delayTime = delayTime;
        this.blockValue = blockValue;
    }

    public JTimerProgressBar(BoundedRangeModel newModel) {
        super(newModel);
        this.initComponents();
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 24));
        this.updateTimer = new UpdateTimer();
        this.setStringPainted(true);
        this.reset();
    }

    @Override
    public boolean isRunning() {
        return this.updateTimer.isRunning();
    }

    @Override
    public void reset() {
        this.value = this.getMinimum();
        this.setValue(this.value);
    }

    @Override
    public void start() {
        this.reset();
        this.updateTimer.start();
    }

    @Override
    public void start(int delayTime) {
        this.setDelayTime(delayTime);
        this.start();
    }

    @Override
    public void restart() {
        this.updateTimer.start();
    }

    @Override
    public void restart(int delayTime) {
        this.setDelayTime(delayTime);
        this.restart();
    }

    @Override
    public void stop() {
        this.updateTimer.stop();
    }

    @Override
    public void finish() {
        int max = this.getMaximum();
        this.setValue(max);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int getDelayTime() {
        return this.delayTime;
    }

    @Override
    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
        this.updateTimer.setDelay(delayTime);
    }

    public int getBlockValue() {
        return this.blockValue;
    }

    public void setBlockValue(int blockValue) {
        this.blockValue = blockValue;
    }

    public class UpdateTimer
    extends Timer
    implements ActionListener {
        public UpdateTimer() {
            super(JTimerProgressBar.this.delayTime, null);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JTimerProgressBar.this.getValue() < JTimerProgressBar.this.blockValue) {
                JTimerProgressBar.this.value++;
                JTimerProgressBar.this.setValue(JTimerProgressBar.this.value);
            } else {
                this.stop();
            }
        }
    }
}

