/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.util.searcher.ip.tencent;

import com.nepxion.util.net.http.apache.ClientInvoker;
import com.nepxion.util.net.http.apache.ClientRequestGet;
import com.nepxion.util.searcher.ip.tencent.TencentIPConstants;
import com.nepxion.util.searcher.ip.tencent.TencentIPEntity;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TencentIPSearcher
implements TencentIPConstants {
    private String charset = "GBK";
    private ClientInvoker clientInvoker;

    public TencentIPSearcher() {
        this("GBK");
    }

    public TencentIPSearcher(String charset) {
        this.charset = charset;
        this.clientInvoker = new ClientInvoker();
    }

    public TencentIPEntity search() throws Exception {
        String text = this.getText();
        return this.createEntity(text);
    }

    private TencentIPEntity createEntity(String text) {
        if (text == null || text.equals("")) {
            return null;
        }
        TencentIPEntity ipEntity = new TencentIPEntity();
        StringTokenizer stringTokenizer = new StringTokenizer(text, ",");
        String ip = stringTokenizer.nextToken();
        ip = ip.substring(ip.indexOf("\"") + 1, ip.lastIndexOf("\""));
        ipEntity.setIP(ip);
        String country = stringTokenizer.nextToken();
        country = country.substring(country.indexOf("\"") + 1, country.lastIndexOf("\""));
        ipEntity.setCountry(country);
        String province = stringTokenizer.nextToken();
        province = province.substring(province.indexOf("\"") + 1, province.lastIndexOf("\""));
        ipEntity.setProvince(province);
        String city = stringTokenizer.nextToken();
        city = city.substring(city.indexOf("\"") + 1, city.lastIndexOf("\""));
        ipEntity.setCity(city);
        return ipEntity;
    }

    public String getText() throws Exception {
        ClientRequestGet clientRequestGet = new ClientRequestGet();
        clientRequestGet.setURI(URI.create("http://fw.qq.com/ipaddress"));
        ArrayList clientParameters = new ArrayList();
        clientRequestGet.setParameterEntity(clientParameters, this.charset);
        String responseText = this.clientInvoker.getResponseText(clientRequestGet, this.charset);
        return responseText;
    }
}

