/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.separator;

import com.nepxion.swing.dimension.DimensionManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class JBasicSeparator
extends JComponent
implements SwingConstants {
    public static final String RAISED_STYLE = "RaisedStyle";
    public static final String LOWERED_STYLE = "LoweredStyle";
    public static final int DEFAULT_THICKNESS = 10;
    protected Color brightColor = Color.white;
    protected Color darkColor = Color.gray;
    private int orientation;
    private String style;
    private int length;

    public JBasicSeparator() {
        this(22);
    }

    public JBasicSeparator(int length) {
        this(LOWERED_STYLE, length);
    }

    public JBasicSeparator(String style, int length) {
        this(1, style, length);
    }

    public JBasicSeparator(int orientation, String style, int length) {
        this.orientation = orientation;
        this.style = style;
        this.setLength(length);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.repaint();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        Dimension dimension = new Dimension();
        if (this.orientation == 1) {
            dimension.width = 10;
            dimension.height = length;
        } else if (this.orientation == 0) {
            dimension.width = length;
            dimension.height = 10;
        }
        DimensionManager.setDimension(this, dimension);
    }

    public void setBrightColor(Color brightColor) {
        this.brightColor = brightColor;
    }

    public void setDarkColor(Color darkColor) {
        this.darkColor = darkColor;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.style.equals(RAISED_STYLE)) {
            g.setColor(this.brightColor);
        } else if (this.style.equals(LOWERED_STYLE)) {
            g.setColor(this.darkColor);
        }
        if (this.orientation == 1) {
            g.drawLine(w / 2 - 1, 0, w / 2 - 1, h);
        } else if (this.orientation == 0) {
            g.drawLine(0, h / 2 - 1, w, h / 2 - 1);
        }
        if (this.style.equals(LOWERED_STYLE)) {
            g.setColor(this.brightColor);
        } else if (this.style.equals(RAISED_STYLE)) {
            g.setColor(this.darkColor);
        }
        if (this.orientation == 1) {
            g.drawLine(w / 2, 0, w / 2, h);
        } else if (this.orientation == 0) {
            g.drawLine(0, h / 2, w, h / 2);
        }
    }
}

